﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using System.Windows.Forms;
using System.IO;
using System.Text;
using System.Net;
using System.Collections.Generic;
using DBUtility;

public partial class Controls_DataCollection_UserAptitudeCollection : System.Web.UI.UserControl
{
    /// <summary>
    /// 定义接口实现
    /// </summary>
    IBLL.IAptitudecolleCtionCyclostyle aptitudecolleCtionCyclostyle = BLLFactory.BusinessLogic.CreateAptitudecolleCtionCyclostyle();
    protected void Page_Load(object sender, EventArgs e)
    {
        //清除缓存
        Response.Expires = -1;
        if (!Page.IsPostBack)
        {
            pager.RecordCount = Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_GetAptitudecolleCtionCyclostyle", null));
            getBind();
        }
    }

    /// <summary>
    /// 绑定GridView
    /// </summary>
    protected void getBind()
    {
        //获得所有数据
        pager.RecordCount = Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_GetAptitudecolleCtionCyclostyle", null));
        //分页
        Model.PagerParameter pagers = new Model.PagerParameter(pager.StartRecordIndex, pager.EndRecordIndex, false);
        //通过声明Model查询所有数据
        IList<Model.AptitudecolleCtionCyclostyle> modelAptitudecolleCtionCyclostyle = aptitudecolleCtionCyclostyle.SelectAptitudecolleCtionCyclostyleList(pagers);
        gvBind.DataSource = modelAptitudecolleCtionCyclostyle;
        gvBind.DataBind();
        //自定义信息显示
        pager.CustomInfoHTML = "记录总数：<font color=\"blue\"><b>" + pager.RecordCount.ToString() + "</b></font>";
        pager.CustomInfoHTML += "  总页数：<font color=\"blue\"><b>" + pager.PageCount.ToString() + "</b></font>";
        pager.CustomInfoHTML += "  当前页：<font color=\"red\"><b>" + pager.CurrentPageIndex.ToString() + "</b></font>";
    }

    /// <summary>
    /// 实现分页
    /// </summary>
    /// <param name="src"></param>
    /// <param name="e"></param>
    protected void pager_PageChanging(object src, Wuqi.Webdiyer.PageChangingEventArgs e)
    {
        pager.CurrentPageIndex = e.NewPageIndex;
        //重新绑定GridView
        getBind();
    }

    /// <summary>
    /// 删除数据
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnDelete_Command(object sender, CommandEventArgs e)
    {
        //获得id
        int id = Convert.ToInt32(e.CommandArgument);
        //通过id删除
        aptitudecolleCtionCyclostyle.RemovePagerAptitudecolleCtionCyclostyle(id);
        //重新绑定GridView
        getBind();
    }

    /// <summary>
    /// 导出数据
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lkbtnExcel_Command(object sender, CommandEventArgs e)
    {
        //重新绑定GridView
        getBind();
        //输出流格试
        Response.ContentType = "application/vnd.ms-Excel";
        //弹出提示框（提示打开，保存，取消）
        Response.AddHeader("Content-Disposition", "inline;filename=" + HttpUtility.UrlEncode("Excel.xls", Encoding.UTF8));        
    }

    /// <summary>
    /// 采集
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lkbAuto_Command(object sender, CommandEventArgs e)
    {
        int id = Convert.ToInt32(e.CommandArgument);
        GetPrototypeValue(id);
    }

    /// <summary>
    /// 通过IE请求获得要采集页的源码
    /// </summary>
    /// <param name="url"></param>
    /// <returns></returns>
    public string GetCodeSource(string url)
    {
        //获得url,发出请求
        WebRequest request = WebRequest.Create(url);
        //返回Internet请求的响应
        WebResponse response = request.GetResponse();
        //从Internet资源返回数据流
        Stream resStream = response.GetResponseStream();
        //从字节流中读取字符
        StreamReader sr = new StreamReader(resStream, System.Text.Encoding.Default);
        //从流的当前位置到末尾位置读取流(获取数据源代码)
        string html = sr.ReadToEnd();
        sr.Close();
        resStream.Close();
        return html;
    }

    /// <summary>
    /// 实现采集
    /// </summary>
    /// <param name="id">采集id</param>
    public void GetPrototypeValue(int id)
    {
        //通过采集id查询所有数据 
        Model.AptitudecolleCtionCyclostyle model = aptitudecolleCtionCyclostyle.SelectAptitudecolleCtionCyclostyle(id);
        string cyclostyleName = model.CyclostyleName;
        string appCyclostyleVolume = model.AppCyclostyleVolume;
        string bookInfoAddress = model.BookInfoAddress;
        string listAddress = model.ListAddress;
        string collectionLabel = model.CollectionLabel;


        //调用GetCodeSource()方法,通过输入地址进行采集
        string html = GetCodeSource(bookInfoAddress);

        //取得输入的数据，根据'＄'号进行分隔
        //起始位置
        //结束位置
        //起始位置字符串
        //结束位置字符串
        //通过Substring进行采集
        string[] sfilt = model.FiltrateBigBound.Split('$');
        string filtStart = sfilt[0].ToString();
        string filtEnd = sfilt[1].ToString();
        int filtstartIndex = html.IndexOf(filtStart);
        int filtendIndex = html.IndexOf(filtEnd);
        string filtHtml = html.Substring(filtstartIndex, filtendIndex - filtstartIndex);

        //取得输入的数据，根据'＄'号进行分隔
        //起始位置
        //结束位置
        //起始位置字符串
        //结束位置字符串
        //通过Substring进行采集
        string[] sbook = model.BookNameBound.Split('$');
        string bookStart = sbook[0].ToString();
        string bookEnd = sbook[1].ToString();
        int bookstartIndex = html.IndexOf(bookStart);
        int bookendIndex = html.IndexOf(bookEnd);
        string bookHtml = html.Substring(bookstartIndex, bookendIndex - bookstartIndex);

        //取得输入的数据，根据'＄'号进行分隔
        //起始位置
        //结束位置
        //起始位置字符串
        //结束位置字符串
        //通过Substring进行采集
        string[] sauthor = model.AuthorBound.Split('$');
        string authorStart = sauthor[0].ToString();
        string authorEnd = sauthor[1].ToString();
        int authorstartIndex = html.IndexOf(bookStart);
        int authorendIndex = html.IndexOf(bookEnd);
        string authorHtml = html.Substring(authorstartIndex, authorendIndex - authorstartIndex);

        //取得输入的数据，根据'＄'号进行分隔
        //起始位置
        //结束位置
        //起始位置字符串
        //结束位置字符串
        //通过Substring进行采集
        string[] sintro = model.IntroBound.Split('$');
        string introStart = sintro[0].ToString();
        string introEnd = sintro[1].ToString();
        int introstartIndex = html.IndexOf(introStart);
        int introendIndex = html.IndexOf(introEnd);
        string introHtml = html.Substring(introstartIndex, introendIndex - introstartIndex);

        //取得输入的数据，根据'＄'号进行分隔
        //起始位置
        //结束位置
        //起始位置字符串
        //结束位置字符串
        //通过Substring进行采集
        string[] skeyword = model.KeywordBound.Split('$');
        string keywordStart = skeyword[0].ToString();
        string keywordEnd = skeyword[1].ToString();
        int keywordstartIndex = html.IndexOf(keywordStart);
        int keywordendIndex = html.IndexOf(keywordEnd);
        string keywordHtml = html.Substring(keywordstartIndex, keywordendIndex - keywordstartIndex);

        //取得输入的数据，根据'＄'号进行分隔
        //起始位置
        //结束位置
        //起始位置字符串
        //结束位置字符串
        //通过Substring进行采集
        string[] sstairSort = model.StairSortCatalog.Split('$');
        string stairSortStart = sstairSort[0].ToString();
        string stairSortEnd = sstairSort[1].ToString();
        int stairSortstartIndex = html.IndexOf(stairSortStart);
        int stairSortendIndex = html.IndexOf(stairSortEnd);
        string stairSortHtml = html.Substring(stairSortstartIndex, stairSortendIndex - stairSortstartIndex);

        //取得输入的数据，根据'＄'号进行分隔
        //起始位置
        //结束位置
        //起始位置字符串
        //结束位置字符串
        //通过Substring进行采集
        string[] slightSort = model.LightSortCatalog.Split('$');
        string slightSortStart = slightSort[0].ToString();
        string slightSortEnd = slightSort[1].ToString();
        int lightSortstartIndex = html.IndexOf(slightSortStart);
        int lightSortendIndex = html.IndexOf(slightSortEnd);
        string lightSortHtml = html.Substring(lightSortstartIndex, lightSortendIndex - lightSortstartIndex);

        //取得输入的数据，根据'＄'号进行分隔
        //起始位置
        //结束位置
        //起始位置字符串
        //结束位置字符串
        //通过Substring进行采集
        string[] scoverImage = model.CoverImage.Split('$');
        string coverImageStart = scoverImage[0].ToString();
        string coverImageEnd = scoverImage[1].ToString();
        int coverImagestartIndex = html.IndexOf(coverImageStart);
        int coverImageendIndex = html.IndexOf(coverImageEnd);
        string coverImageHtml = html.Substring(coverImagestartIndex, coverImageendIndex - coverImagestartIndex);

        //取得输入的数据，根据'＄'号进行分隔
        //起始位置
        //结束位置
        //起始位置字符串
        //结束位置字符串
        //通过Substring进行采集
        string[] sbookEstate = model.BookEstate.Split('$');
        string bookEstateStart = sbookEstate[0].ToString();
        string bookEstateEnd = sbookEstate[1].ToString();
        int bookEstatestartIndex = html.IndexOf(bookEstateStart);
        int bookEstateendIndex = html.IndexOf(bookEstateEnd);
        string bookEstateHtml = html.Substring(bookEstatestartIndex, bookEstateendIndex - bookEstatestartIndex);

        string verdict404Error = model.Verdict404Error;

        //取得输入的数据，根据'＄'号进行分隔
        //起始位置
        //结束位置
        //起始位置字符串
        //结束位置字符串
        //通过Substring进行采集
        string[] sdelLetter = model.DelLetter.Split('$');
        string delLetterStart = sdelLetter[0].ToString();
        string delLetterEnd = sdelLetter[1].ToString();
        int delLetterstartIndex = html.IndexOf(delLetterStart);
        int delLetterendIndex = html.IndexOf(delLetterEnd);
        string delLetterHtml = html.Substring(delLetterstartIndex, delLetterendIndex - delLetterstartIndex);

        //把所有数据保存到数组中
        string[] strNewsHtml = new string[] { cyclostyleName, appCyclostyleVolume, bookInfoAddress, listAddress, collectionLabel ,
        filtHtml,bookHtml,authorHtml,introHtml,keywordHtml,stairSortHtml,lightSortHtml,coverImageHtml,bookEstateHtml,verdict404Error,
        delLetterHtml};
        //定义要查示的参数,并保存到数组中
        string[] strOldHtml = new string[] { "@CyclostyleName", "@AppCyclostyleVolume", "@BookInfoAddress", "@ListAddress", "@CollectionLabel",
            "@FiltHtml", "@BookHtml", "@AuthorHtml", "@IntroHtml", "@KeywordHtml", "@StairSortHtml", "@LightSortHtml", "@CoverImageHtml"
            , "@BookEstateHtml", "@Verdict404Error", "@DelLetterHtml"};
        //以时间为名字保存html
        string strFileName = DateTime.Now.ToString("ddhhmmss") + ".html";
        //将文件保存到NewsHtml文件夹中
        string strFilePath = string.Format("NewsHtml/{0}", strFileName);
        try
        {
            if (common.CreatHtmlPage(strNewsHtml, strOldHtml, "mode.htm", strFilePath))
            {
                Response.Write("<script>alert('采集成功！文件已保存在NewsHtml文件夹中请检查！！')</script>");
            }
            else
            {
                Response.Write("<script>alert('采集失败！')</script>");
            }
        }
        catch
        {
            Response.Write("<script>alert('采集失败！')</script>");
        }
    }

    /// <summary>
    /// 鼠标移动事件
    /// 鼠标放在GridView相应的行上面变色,离开时变回原色
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void gvBind_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            //鼠标放在上面变色
            e.Row.Attributes.Add("onmouseover", "c=this.style.backgroundColor;this.style.backgroundColor='#E1E1E1';this.style.cursor='hand';");
            //鼠标离开变回原色
            e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=c");
        }
    }
}