﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;
using DBUtility;

public partial class Controls_DataCollection_UserArticle : System.Web.UI.UserControl
{
    IBLL.INewsCollection newsCollection = BLLFactory.BusinessLogic.CreateNewsCollection();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            //获得所有数据
            pager.RecordCount = Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_GetNewsCollection", null));
            getBind();
        }
    }

    /// <summary>
    /// 查询采集内容信息
    /// </summary>
    public void getBind()
    { 
        //获得所有数据
        pager.RecordCount = Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_GetNewsCollection", null));
        //分页
        Model.PagerParameter pagers = new Model.PagerParameter(pager.StartRecordIndex, pager.EndRecordIndex, false);
        //通过声明Model查询所有数据
        IList<Model.NewsCollection> mdoelNewsCollection = newsCollection.GetNewsCollection(pagers);
        gvBind.DataSource = mdoelNewsCollection;
        gvBind.DataBind();
        //自定义信息显示
        pager.CustomInfoHTML = "记录总数：<font color=\"blue\"><b>" + pager.RecordCount.ToString() + "</b></font>";
        pager.CustomInfoHTML += "  总页数：<font color=\"blue\"><b>" + pager.PageCount.ToString() + "</b></font>";
        pager.CustomInfoHTML += "  当前页：<font color=\"red\"><b>" + pager.CurrentPageIndex.ToString() + "</b></font>";
    }

    /// <summary>
    /// 分页显示
    /// </summary>
    /// <param name="src"></param>
    /// <param name="e"></param>
    protected void pager_PageChanging(object src, Wuqi.Webdiyer.PageChangingEventArgs e)
    {
        pager.CurrentPageIndex = e.NewPageIndex;
        getBind();
    }
}
