﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Net;
using System.IO;
public partial class Controls_DataCollection_UserCollectionArticle : System.Web.UI.UserControl
{
    IBLL.INewsCollection newsCollection = BLLFactory.BusinessLogic.CreateNewsCollection();
    Model.NewsCollection modelNewsCollecton = new Model.NewsCollection();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            getBind();
        }
    }

    /// <summary>
    /// 获取源码
    /// </summary>
    protected void getBind()
    {
        //获得路径
        string url = Request.QueryString["collectionAddress"].ToString();
        //通过路径发出请求
        WebRequest request = WebRequest.Create(url);
        //当子类被重写时返回对请求的响应
        WebResponse response = request.GetResponse();
        //返回数据流
        Stream resStream = response.GetResponseStream();
        //用指定的编码格式初始化一个新实体
        StreamReader sr = new StreamReader(resStream, System.Text.Encoding.Default);
        //读取流
        string html = sr.ReadToEnd();
        //输入为HTML编码格式
        labName.Text = Server.HtmlEncode(html);
        sr.Close();
        resStream.Close();
    }

    /// <summary>
    /// 采集
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCollection_Click(object sender, EventArgs e)
    {
        modelNewsCollecton.NewsTitle = txtTitle.Text;
        modelNewsCollecton.NewsBody = labName.Text;
        modelNewsCollecton.NewsURL = Request.QueryString["collectionAddress"].ToString();
        newsCollection.AddNewsCollection(modelNewsCollecton);
        Response.Write("<script>window.close();</script>");
    }
}
