﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using DBUtility;
using System.Collections.Generic;

public partial class Controls_DataCollection_UserDayDotHit : System.Web.UI.UserControl
{
    /// <summary>
    /// 定义接口实现
    /// </summary>
    IBLL.ICollectionBookCyclostyle collectionBookCyclostyle = BLLFactory.BusinessLogic.CreateCollectionBookCyclostyle();
    protected void Page_Load(object sender, EventArgs e)
    {
        //清除缓存
        Response.Expires = -1;
        if (!Page.IsPostBack)
        {
            pager.RecordCount = Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_GetCollectionBookCyclostyle", null));
            getBind();
        }
    }

    /// <summary>
    /// 分页
    /// </summary>
    /// <param name="src"></param>
    /// <param name="e"></param>
    protected void pager_PageChanging(object src, Wuqi.Webdiyer.PageChangingEventArgs e)
    {
        pager.CurrentPageIndex = e.NewPageIndex;
        getBind();
    }

    /// <summary>
    /// 绑定GridView方法
    /// </summary>
    protected void getBind()
    {
        pager.RecordCount = Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_GetCollectionBookCyclostyle", null));
        //声明Model.PagerParameter对象
        Model.PagerParameter pagers = new Model.PagerParameter(pager.StartRecordIndex, pager.EndRecordIndex, false);
        //创建<Model.CollectionBookCyclosotyle>类型集合
        IList<Model.CollectionBookCyclostyle> modelcollectionBookCyclostyle = collectionBookCyclostyle.GetCollectionBookCyclostyleList(pagers);
        gvBind.DataSource = modelcollectionBookCyclostyle;
        gvBind.DataBind();
        //自定义信息显示
        pager.CustomInfoHTML = "记录总数：<font color=\"blue\"><b>" + pager.RecordCount.ToString() + "</b></font>";
        pager.CustomInfoHTML += "  总页数：<font color=\"blue\"><b>" + pager.PageCount.ToString() + "</b></font>";
        pager.CustomInfoHTML += "  当前页：<font color=\"red\"><b>" + pager.CurrentPageIndex.ToString() + "</b></font>";
    }

    /// <summary>
    /// 删除数据
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lkbtnDelete_Command(object sender, CommandEventArgs e)
    {
        //获取ID
        int id = Convert.ToInt32(e.CommandArgument);
        //调用RemoveCollectionBookCyclostyle(),根据ID进行删除
        collectionBookCyclostyle.RemoveCollectionBookCyclostyle(id);
        getBind();
    }

    /// <summary>
    /// 鼠标移动事件
    /// 鼠标放在GridView相应的行上面变色,离开时变回原色
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void gvBind_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Cells[3].Style.Add("word-break","break-all");
            //鼠标放在上面变色
            e.Row.Attributes.Add("onmouseover", "c=this.style.backgroundColor;this.style.backgroundColor='#E1E1E1';this.style.cursor='hand';");
            //鼠标离开变回原色
            e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=c");
        }
    }
}
