﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using DBUtility;

public partial class Controls_CategoryManager : System.Web.UI.UserControl
{
    IBLL.IAuthority authority = BLLFactory.BusinessLogic.CreateAuthority();
    string sql_count = "select count(*) from Authority";
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Session["UserName"] != null)
        {
            ProfileCommon p = Profile.GetProfile(Session["UserName"].ToString());
            ViewState["role"] = common.GetAuthorityName(p.Rating);
            if (ViewState["role"].ToString() == "系统管理员")
            {
                if (int.Parse(Request["id"]) == 7)
                {
                    getBind();
                }
                else
                {
                    BindById();
                }
            }
            else
            {
                Response.Redirect("/TengfeiWeb/BookManager/Sorry.aspx");
            }
        }
        else
        {
            Response.Redirect("/TengfeiWeb/Clientele/SessionOut.aspx");
        }
    }
    
    
    public void getBind()
    {
        pager.RecordCount = Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.Text, sql_count, null));
        Model.PagerParameter pagers = new Model.PagerParameter(pager.StartRecordIndex,pager.EndRecordIndex,false);
        IList<Model.Authority> authorityList = authority.GetAllAuthority(pagers);
        GridView1.DataSource = authorityList;
        GridView1.DataBind();
        //分页自定义信息显示
        pager.CustomInfoHTML = "记录总数：<font color=\"blue\"><b>" + pager.RecordCount.ToString() + "</b></font>";
        pager.CustomInfoHTML += "  总页数：<font color=\"blue\"><b>" + pager.PageCount.ToString() + "</b></font>";
        pager.CustomInfoHTML += "  当前页：<font color=\"red\"><b>" + pager.CurrentPageIndex.ToString() + "</b></font>";
    }
    protected void pager_PageChanging(object src, Wuqi.Webdiyer.PageChangingEventArgs e)
    {
        pager.CurrentPageIndex = e.NewPageIndex;
        getBind();
    }
    //绑定GridView
    public void BindById()
    {
        pager.RecordCount = Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.Text, sql_count, null));
         Model.PagerParameter pagers = new Model.PagerParameter(pager.StartRecordIndex,pager.EndRecordIndex,false);
        int id = int.Parse(Request["id"]);
        IList<Model.Authority> authorityList = authority.GetAuthorityById(pagers, id);
        GridView1.DataSource = authorityList;
        GridView1.DataBind();
    }
    //删除权限
    protected void lbtnDelete_Command(object sender, CommandEventArgs e)
    {
        int id = Convert.ToInt32(e.CommandArgument);
        authority.RemoveAuthority(id);
        getBind();
        Response.Write("<script>alert('删除成功！！')</script>");
        
    }
    public string GetAuthorityName(int id)
    {
        return common.GetAuthorityName(id);
    }
    protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            //鼠标放在上面变色
            e.Row.Attributes.Add("onmouseover", "c=this.style.backgroundColor;this.style.backgroundColor='#E1E1E1';this.style.cursor='hand';");
            //鼠标离开变回原色
            e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=c");
        }
    }
}
