﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Controls_Economy : System.Web.UI.UserControl
{
    IBLL.ISystemInfo systemInfo = BLLFactory.BusinessLogic.CreateSystemInfo();
   
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Session["UserName"] != null)
            {
                ProfileCommon p = Profile.GetProfile(Session["UserName"].ToString());
                ViewState["role"] = common.GetAuthorityName(p.Rating);
                if (ViewState["role"].ToString() == "系统管理员")
                {
                    GetView();
                }
                else
                {
                    Response.Redirect("/TengfeiWeb/BookManager/Sorry.aspx");
                }
            }
            else
            {
                Response.Redirect("/TengfeiWeb/Clientele/SessionOut.aspx");
            } 
        }
    }
    //更新系统参数
    protected void btnKeep_Click(object sender, EventArgs e)
    {
        Model.SystemInfo modelSystemInfo = 
                                            new Model.SystemInfo(1,
                                            int.Parse(radlWhether.SelectedValue),
                                            txtClosenet.Text, 
                                            txtNetname.Text,
                                            txtNetaddress.Text,
                                            txtEmail.Text,
                                            txtLeaf.Text,
                                            txtLogo.Text,
                                            txtMeta.Text,
                                            txtLow.Text,
                                            txtValidate.Text,
                                            int.Parse(radlPassword.Text),
                                            int.Parse(radlValidate.SelectedValue),
                                            int.Parse(radlLanding.SelectedValue),
                                            int.Parse(radlAppear.SelectedValue),
                                            int.Parse(radlBack.SelectedValue),
                                            txtIp.Text,
                                            gropColour.SelectedItem.Text,
                                            int.Parse(txtShow.Text),
                                            radlLang.Text,
                                            int.Parse(radlRead.SelectedValue),
                                            int.Parse(radlUnlock.SelectedValue),
                                            gropStatic.SelectedItem.Text,
                                            gropPaper.SelectedItem.Text,
                                            gropSerialize.SelectedItem.Text,
                                            radlSerialize.Text,
                                            int.Parse(radlHtml.SelectedValue),
                                            int.Parse(radlAutomatism.SelectedValue),
                                            int.Parse(radlAuditing.SelectedValue),
                                            int.Parse(radlChapter.SelectedValue),
                                            int.Parse(radlChm.SelectedValue),
                                            gropChm.SelectedItem.Text,
                                            int.Parse(radlFiltrate.SelectedValue),
                                            int.Parse(radlUbb.SelectedValue),
                                            txtKey.Text,
                                            radlCareer.Text,
                                            int.Parse(radlOpe.SelectedValue),
                                            int.Parse(radlAllow.SelectedValue),
                                            int.Parse(radlBook.SelectedValue),
                                            txtSift.Text,
                                            int.Parse(txtTime.Text), 
                                            int.Parse(txtLimit.Text),
                                            int.Parse(txtAppear.Text),
                                            txtIntegralName.Text,
                                            int.Parse(txtEnrol.Text),
                                            int.Parse(txtLanding.Text),
                                            int.Parse(txtAdd.Text),
                                            int.Parse(txtExtract.Text),
                                            int.Parse(txtGroom.Text),
                                            int.Parse(txtBill.Text),
                                            chklProscenium.Text,
                                            int.Parse(radlAuthor.SelectedValue),
                                            gropData.SelectedItem.Text,
                                            gropPopedom.SelectedItem.Text,
                                            int.Parse(radlLogin.SelectedValue),
                                            int.Parse(radlInsider.SelectedValue),
                                            txtWord.Text,
                                            txtExplain.Text,
                                            txtInsider.Text);
        systemInfo.ModifySystemInfo(modelSystemInfo);
    }
    //查询系统参数
    public void GetView()
    {
          Model.SystemInfo syInfo = systemInfo.GetAllSystemInfo();
          radlWhether.SelectedValue=syInfo.MeshworkOpen.ToString();
          txtClosenet.Text=syInfo.MeshworkClose;
          txtNetname.Text=syInfo.MeshworkName;
          txtNetaddress.Text=syInfo.MeshworkAddress;
          txtEmail.Text=syInfo.Email;
          txtLeaf.Text=syInfo.Pagelayout;
          txtLogo.Text=syInfo.LoGo;
          txtMeta.Text=syInfo.MeshworkDepict;
          txtLow.Text=syInfo.RootCopyright;
          txtValidate.Text=syInfo.Verify;
          radlPassword.SelectedIndex=syInfo.PasswordEncrypt;
          radlValidate.SelectedIndex=syInfo.LoginOpenVerify;
          radlLanding.SelectedIndex = syInfo.LandOpenVerify;
          radlAppear.SelectedIndex = syInfo.UtterOpenVerify;
          radlBack.SelectedIndex = syInfo.GetPasswordOpenVerify;
          txtIp.Text=syInfo.ConfineIp;
          gropColour.SelectedItem.Text=syInfo.MeshworkStencil;
          txtShow.Text=Convert.ToString(syInfo.ShowHow);
          radlLang.Text=syInfo.MeshworkLang;
          radlRead.SelectedIndex = syInfo.Reada;
          radlUnlock.SelectedIndex = syInfo.StaticPage;
          gropStatic.SelectedItem.Text=syInfo.SimulatePage;
          gropPaper.SelectedItem.Text=syInfo.FileExtend;
          gropSerialize.SelectedItem.Text=syInfo.SerialiseSort;
          radlSerialize.Text=syInfo.SerialiseSortLevel;
          radlHtml.SelectedIndex = syInfo.AutomatismHTML;
          radlAutomatism.SelectedIndex = syInfo.AutomatismAuditingBook;
          radlAuditing.SelectedIndex = syInfo.AutomatismBookChapter;
          radlChapter.SelectedIndex = syInfo.BookAuditingChapter;
          radlChm.SelectedIndex = syInfo.BuildCHM;
          gropChm.SelectedItem.Text=syInfo.Chmbuild;
          radlFiltrate.SelectedIndex = syInfo.PercolationHtml;
          radlUbb.SelectedIndex = syInfo.PercolationUbb;
          txtKey.Text=syInfo.PercolationKeyWord;
          radlCareer.Text=syInfo.HtmlMake;
          radlOpe.SelectedIndex = syInfo.OpenReview;
          radlAllow.SelectedIndex = syInfo.GrantVisitorDeliver;
          radlBook.SelectedIndex = syInfo.AutomatismBookDeliver;
          txtSift.Text=syInfo.DeliverKeyWord;
          txtTime.Text=Convert.ToString(syInfo.AppearDeliverTime);
          txtLimit.Text=Convert.ToString(syInfo.DeliverNumberRestrict);
          txtAppear.Text=Convert.ToString(syInfo.IntegralDeliver);
          txtIntegralName.Text=syInfo.IntegralName;
          txtEnrol.Text=Convert.ToString(syInfo.LoginIntegral);
          txtLanding.Text=Convert.ToString(syInfo.LandAddIntegral);
          txtAdd.Text=Convert.ToString(syInfo.DeliverIntegral);
          txtExtract.Text=Convert.ToString(syInfo.HighlightIntegral);
          txtGroom.Text=Convert.ToString(syInfo.CommendIntegral);
          txtBill.Text=Convert.ToString(syInfo.DrumbeatingIntegral);
          chklProscenium.Text=syInfo.StageShow;
          radlAuthor.SelectedIndex = syInfo.SerialiseAuthor;
          gropData.SelectedItem.Text=syInfo.SerialiseData;
          gropPopedom.SelectedItem.Text=syInfo.Serialisepopedom;
          radlLogin.SelectedIndex = syInfo.InsiderEnrol;
          radlInsider.SelectedIndex = syInfo.InsiderAuditing;
          txtWord.Text=syInfo.EnrolFiltrateKeyWord;
          txtExplain.Text = syInfo.CloseInsiderExplain;
          txtInsider.Text = syInfo.InsiderEnrolConfer;
    }
}
