﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using DBUtility;

public partial class Controls_User_ApplyAuthor : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Session["UserName"] != null)
            {
                txtUserName.Text = Session["UserName"].ToString();
                ProfileCommon p = Profile.GetProfile(txtUserName.Text);
                if (string.IsNullOrEmpty(p.PenName) == false)
                {
                    txtPenName.Text = p.PenName;
                    txtRealName.Text = p.RealName;
                    ddlSystemPurview.SelectedValue = p.Rating.ToString();
                    dropAuthorTitle.SelectedValue = p.AuthorTitle;
                    txtPersonInfo.Text = p.PersonInfo;
                    txtcardId.Text = p.CardId;
                    txtPhone.Text = p.Phone;
                    btnSubmit.Text = "修改";
                }
            }
            else
            {
                Server.Transfer("Login.aspx");
            }
        }
    }
    protected void btnSubmit_Click(object sender, EventArgs e)
    {
            int i = common.ValidateUser(txtUserName.Text);
            if (i > 0)
            {
                ProfileCommon p = Profile.GetProfile(txtUserName.Text);
                p.PenName = txtPenName.Text;
                p.RealName = txtRealName.Text;
                p.Rating = int.Parse(ddlSystemPurview.SelectedValue);
                p.AuthorTitle = dropAuthorTitle.SelectedItem.Text;
                string personInfo = txtPersonInfo.Text;
                if (personInfo.Length> 50)
                {
                    personInfo = personInfo.Substring(0, 50);
                }
                p.PersonInfo = personInfo;
                p.CardId = txtcardId.Text;
                p.Phone = txtPhone.Text;
                p.IsAuthor = true;
                p.ApplyAuthorTime = DateTime.Now.ToString();
                p.Save();
                FailureText.Text = "作者申请成功。";
            }
            else
            {
                FailureText.Text = "该用户不存在，不能申请为作者，<br/>请先注册帐号，<a href='Regist.aspx'>点击注册</a>";
            }
    }
    protected void btnReset_Click(object sender, EventArgs e)
    {
        txtPenName.Text = "";
        txtRealName.Text = "";
        ddlSystemPurview.SelectedValue = "";
        dropAuthorTitle.SelectedValue = "";
        txtPersonInfo.Text = "";
        txtcardId.Text = "";
        txtPhone.Text = "";
    }
}
