﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

public partial class Controls_PersonInfo : System.Web.UI.UserControl
{
    IBLL.IMemberGroup member = BLLFactory.BusinessLogic.CreateMemberGroup();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Session["UserName"] != null)
            {
                fvUserInfo.DataSource = PersonInfo(Session["UserName"].ToString());
                fvUserInfo.DataBind();
            }
            else
            {
                Server.Transfer("Login.aspx");
            }
        }
    }
    public DataTable PersonInfo(string UserName)
    {
        //创建数据表DataTable来存储用户信息
        DataTable dt = new DataTable();
        dt.Columns.Add("UserName", Type.GetType("System.String"));
        dt.Columns.Add("NickName",Type.GetType("System.String"));
        dt.Columns.Add("Sex", Type.GetType("System.String"));
        dt.Columns.Add("Birthday",Type.GetType("System.String"));
        dt.Columns.Add("Email",Type.GetType("System.String"));
        dt.Columns.Add("QQ",Type.GetType("System.String"));
        dt.Columns.Add("Address",Type.GetType("System.String"));
        dt.Columns.Add("MemberGroup", Type.GetType("System.String"));
        dt.Columns.Add("Rating", Type.GetType("System.String"));
        dt.Columns.Add("Score",Type.GetType("System.Int32"));
        dt.Columns.Add("IsLoked",Type.GetType("System.String"));
        dt.Columns.Add("PostCount",Type.GetType("System.Int32"));
        dt.Columns.Add("CreationDate",Type.GetType("System.DateTime"));//创建用户日期
        dt.Columns.Add("IsOnline",Type.GetType("System.String"));      //是否在线
        //dt.Columns.Add("LastLockoutDate",Type.GetType("System.DateTime"));//最后一次被锁定日期
        dt.Columns.Add("LoginCount",Type.GetType("System.Int32"));
        dt.Columns.Add("LastLoginDate",Type.GetType("System.DateTime"));  //最后一次登录时间
        dt.Columns.Add("LastPasswordChangedDate",Type.GetType("System.DateTime"));//最后一次修改密码时间
        dt.Columns.Add("DayVoteCount", Type.GetType("System.Int32"));     //日推荐票数
        dt.Columns.Add("DayAdCount", Type.GetType("System.Int32"));
        dt.Columns.Add("CollectBookCount", Type.GetType("System.Int32"));
        DataRow dr = dt.NewRow();
        MembershipUser user = Membership.GetUser(UserName);
        ProfileCommon p = Profile.GetProfile(UserName);
        dr[0] = p.UserName;  //用户帐号
        dr[1] = p.NickName;  //用户昵称
        dr[2] = p.Sex;       //性别
        dr[3] = p.Birthday;  //出生日期
        dr[4] = user.Email;  //邮箱地址
        dr[5] = p.QQ;        //QQ号
        string[] s=p.Address.Split(',');
        dr[6] = common.GetProvince(Convert.ToInt32(s[0])) + "," + common.GetCity(Convert.ToInt32(s[1])) + "," + common.GetArea(Convert.ToInt32(s[2]));   //地址
        dr[7] =common.GetMemberGroupName(p.MemberGroup);//隶属会员组
        dr[8] = common.GetAuthorityName(p.Rating);//隶属等级
        dr[9] = p.Score;            //积分
        dr[10] =IsLocked(p.IsLoked); //是否锁定
        dr[11] = p.PostCount;       //发帖数
        dr[12] = user.CreationDate; //创建帐号日期
        dr[13] = IsOnline(user.IsOnline);   //用户在线状况
        dr[14] = p.LoginCount;              //登录次数
        dr[15] = user.LastLoginDate;        //用户最后一次登录时间    
        dr[16] = user.LastPasswordChangedDate;//用户最后一次修改密码时间
        dr[17] = member.GetMemberGroupById(p.MemberGroup).DayRecTicket;//日推荐票数
        dr[18] = member.GetMemberGroupById(p.MemberGroup).DayAdTicket; //日广告票        
        dr[19] = member.GetMemberGroupById(p.MemberGroup).LibraryCount;//可藏书数量
        dt.Rows.Add(dr);     //将行添加到表中
        dt.AcceptChanges();  //保存数据
        return dt;           //返回DataTable对象
    }
    //返回String类型判断是否在线
    public string IsOnline(bool i)
    {
        string isOnline = "";
        switch (i)
        {
            case true:
                isOnline= "在线";
                break;
            case false:
                isOnline= "离线";
                break;
        }
        return isOnline;
    }
    //返回String类型判断是否被锁定
    public string IsLocked(bool i)
    {
        string isLocked = "";
        switch (i)
        {
            case true:
                isLocked= "已锁定";
                break;
            case false:
                isLocked= "正常";
                break;
        }
        return isLocked;
    }
}
