﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using DBUtility;

public partial class Controls_UserAppAuthor : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        //清除缓存
        Response.Expires = 0;
        Response.AddHeader("pragma", "on-cache");
        Response.AddHeader("Cache-Control", "no-cache, must-revalidate");
        if (!IsPostBack)
        {
            SystemPurviewBind();
            AuthorInfo();
        }
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
       
        int i = common.ValidateUser(txtUserName.Text);
        if (i > 0)
        {
            lalValidateUser.Visible = false;
            ProfileCommon p = Profile.GetProfile(txtUserName.Text);
            p.PenName = txtPenName.Text;
            p.RealName = txtRealName.Text;
            p.Rating = int.Parse(ddlSystemPurview.SelectedValue);
            p.AuthorTitle = dropAuthorTitle.SelectedItem.Text;
            p.PersonInfo = txtPersonInfo.Text;
            p.CardId = txtcardId.Text;
            p.Phone = txtPhone.Text;
            p.IsLoked = bool.Parse(rdbLocked.SelectedValue);
            p.IsAuthor = true;
            p.ApplyAuthorTime = DateTime.Now.ToString();
            p.Save();
            if (Request["do"] != null)
            {
                if (Request["do"].ToString() == "Edit")
                    Response.Write("<script>alert('修改成功!');</script>");
            }
            else
            {
                Response.Write("<script>alert('添加成功!');</script>");
            }
        }
        else
        {
            lalValidateUser.Visible = true;
            lalValidateUser.Text = "该用户不存在！";
        }
    }
    public void SystemPurviewBind()
    {
        SqlParameter parm = new SqlParameter("@ParentId", SqlDbType.Int);
        parm.Value = 18;
        common.DropDownListBind(ddlSystemPurview, "Text", "id", SqlHelper.connectionString,
                                CommandType.StoredProcedure, "Tengfei_SelectSystemUserInTree_Admin", parm);
    }
    public void AuthorInfo()
    {
        if (Request["UserName"] != null)
        {
            ProfileCommon p = Profile.GetProfile(Request["UserName"].ToString());
            txtUserName.Text = p.UserName;
            txtPenName.Text = p.PenName;
            ddlSystemPurview.SelectedValue = p.Rating.ToString();
            dropAuthorTitle.Text = p.AuthorTitle;
            txtPersonInfo.Text = p.PersonInfo;
            txtRealName.Text = p.RealName;
            txtcardId.Text = p.CardId;
            txtPhone.Text = p.Phone;
            rdbLocked.SelectedValue = p.IsLoked.ToString();
        }
    }
    
}
