﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

public partial class Controls_UserSystemInfo : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Request["id"] != null)
        {
            ViewState["id"] = Request["id"].ToString();
        }
        if (!IsPostBack)
        {
            if (Session["UserName"] != null)
            {
                ProfileCommon p = Profile.GetProfile(Session["UserName"].ToString());
                ViewState["role"] = common.GetAuthorityName(p.Rating);
                if (ViewState["role"].ToString() == "系统管理员")
                {
                    Bind();
                }
                else
                {
                    Response.Redirect("/TengfeiWeb/BookManager/Sorry.aspx");
                }
            }
            else
            {
                Response.Redirect("/TengfeiWeb/Clientele/SessionOut.aspx");
            }
        }
    }
    public void Bind()
    {
        if (ViewState["id"] != null)
        {
            gvSystemInfo.DataSource = getSystemInfoByRating(Convert.ToInt32(ViewState["id"]));
            gvSystemInfo.DataBind();
        }
        else
        {
            gvSystemInfo.DataSource = getSystemInfo();
            gvSystemInfo.DataBind();
        }
    }
    public DataTable getSystemInfo()
    {
        DataTable dt = new DataTable();
        dt.Columns.Add("UserName", Type.GetType("System.String"));
        dt.Columns.Add("PenName", Type.GetType("System.String"));
        dt.Columns.Add("Rating", Type.GetType("System.Int32"));
        dt.Columns.Add("IsLoked", Type.GetType("System.String"));
        MembershipUserCollection u = Membership.GetAllUsers();
        foreach (MembershipUser user in u)
        {
            ProfileCommon p = Profile.GetProfile(user.UserName);
            DataRow dr=dt.NewRow();

            dr[0] = p.UserName;         //用户帐号
            dr[1] = p.PenName;          //用户昵称
            dr[2] = p.Rating;           //等级
            dr[3] = IsLoked(p.IsLoked); //是否锁定

            dt.Rows.Add(dr);//将行添加到表中
        }  
        dt.AcceptChanges();  //保存数据
        return dt;           //返回DataTable对象
    }
    public DataTable getSystemInfoByRating(int Id)
    {
        DataTable dt = new DataTable();
        dt.Columns.Add("UserName", Type.GetType("System.String"));
        dt.Columns.Add("PenName", Type.GetType("System.String"));
        dt.Columns.Add("Rating", Type.GetType("System.Int32"));
        dt.Columns.Add("IsLoked", Type.GetType("System.String"));
        MembershipUserCollection u = Membership.GetAllUsers();
        foreach (MembershipUser user in u)
        {
            ProfileCommon p = Profile.GetProfile(user.UserName);
            if (p.Rating == Id)
            {
                DataRow dr = dt.NewRow();
                dr[0] = p.UserName;         //用户帐号
                dr[1] = p.PenName;          //用户昵称
                dr[2] = p.Rating;           //等级
                dr[3] = IsLoked(p.IsLoked); //是否锁定

                dt.Rows.Add(dr);//将行添加到表中
            }
        }
        dt.AcceptChanges();  //保存数据
        return dt;           //返回DataTable对象
    }

    //返回String类型判断是否被锁定
    public string IsLoked(bool i)
    {
        string isLoked = "";
        if (i == true)
            isLoked = "已锁定";
        else
            isLoked = "正常";
        return isLoked;
    }
    public string GetAuthorityName(int Id)
    {
        return common.GetAuthorityName(Id);
    }
    protected void lkbDelete_Command(object sender, CommandEventArgs e)
    {
        string userName = Convert.ToString(e.CommandArgument);
        bool i = Membership.DeleteUser(userName);
        Bind();
    }
    protected void lkbLock_Command(object sender, CommandEventArgs e)
    {
        string userName = e.CommandArgument.ToString();
        ProfileCommon p = Profile.GetProfile(userName);
        p.IsLoked = true;
        p.Save();
        Bind();
    }
    protected void lkbUnLock_Command(object sender, CommandEventArgs e)
    {
        string userName = e.CommandArgument.ToString();
        ProfileCommon p = Profile.GetProfile(userName);
        p.IsLoked = false;
        p.Save();
        Bind();
    }
    protected void lkbUpdatePasswrod_Command(object sender, CommandEventArgs e)
    {
        Response.Write("<script language=javascript>window.open('UpdatePassWord.aspx?UserName=" + e.CommandArgument.ToString() + "','newwindow', 'height=200, width=355, top=200, left=350, toolbar=no, menubar=no, scrollbars=no, resizable=no,location=no,status=no')</script>");
    }
    protected void lkbEdit_Command(object sender, CommandEventArgs e)
    {
        Response.Write("<script language=javascript>window.open('AppAuthor.aspx?UserName=" + e.CommandArgument.ToString() + "&&do=Edit','newwindow', 'height=380, width=370, top=200, left=350, toolbar=no, menubar=no, scrollbars=no, resizable=no,location=no,status=no')</script>");
    }
    protected void gvSystemInfo_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onmouseover", "c=this.style.backgroundColor;this.style.backgroundColor='#E1E1E1';this.style.cursor='hand';");
            e.Row.Attributes.Add("onmouseout","this.style.backgroundColor=c");
        }
    }
}
