﻿/* 请提高版权意识，不要删除这些版权声明。
 * --------------------------------------------------------------------------------------
 * 产品名称：问沫聚合门户管理系统
 * 产品作者：Guidy
 * 版权所有：问沫工作室 [VMoom Studio]
 * --------------------------------------------------------------------------------------
 * 官方网站：http://www.vmoom.net/
 * 技术论坛：http://bbs.vmoom.net/
 * ------------------------------------------------------------------------------------*/

using System;
using System.Diagnostics;
using System.IO;
using System.Security.Cryptography;
using System.Windows.Forms;
using Microsoft.Win32;

namespace LiveUpdate.Framework
{
	public sealed class Utils
	{
		public static string FormatFileSize(long size)
		{
			string s = "";
			string[] u = new string[] { "B", "KB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB", "NB", "DB" };

			double i = size;
			int n = 0;
			while (i > 1024)
			{
				i = i / 1024.0;
				n++;
				if (n == 4) break;
			}

			s = i.ToString("F2") + u[n];

			return s;
		}

		/// <summary>
		/// 按照指定的方式打开 URL。
		/// </summary>
		/// <param name="url">要打开的 URL 地址，必须是遵循 http(s) 协议的 URL。</param>
		/// <param name="target">取值为1时则在新窗口打开 URL，否则会自动选择当前窗口。</param>
		public static void OpenUrl(string url, bool _blank)
		{
			try
			{
				if (!_blank)
				{
					Process.Start(url);
				}
				else
				{
					Process proc = new Process();

					// 从注册表读取默认浏览器位置
					RegistryKey reg = Registry.ClassesRoot.OpenSubKey(@"HTTP\shell\open\command", false);
					string f = reg.GetValue("").ToString();
					f = f.Replace("\"", "");
					f = f.Substring(0, f.IndexOf("exe", StringComparison.OrdinalIgnoreCase) + 3);
					reg.Close();

					// 从新窗口打开url
					proc.StartInfo.FileName = f;
					proc.StartInfo.Arguments = url;
					proc.Start();
					proc.Close();
				}
			}
			catch (System.ComponentModel.Win32Exception noBrowser)
			{
				if (noBrowser.ErrorCode == -2147467259)
				{
					MessageBox.Show(noBrowser.Message);
				}
			}
			catch (System.Exception other)
			{
				MessageBox.Show(other.Message);
			}
		}

		/// <summary>
		/// 打开 URL。
		/// </summary>
		/// <param name="url">要打开的 URL 地址，必须是遵循 http(s) 协议的 URL。</param>
		public static void OpenUrl(string url)
		{
			OpenUrl(url, false);
		}

		/// <summary>
		/// 计算指定文件的MD5码
		/// </summary>
		/// <param name="path">文件的完整物理路径</param>
		/// <returns>文件MD5码</returns>
		public static string GetFileMD5(string path)
		{
			try
			{
				FileStream f = new FileStream(path, FileMode.Open, FileAccess.Read, FileShare.Read);
				MD5CryptoServiceProvider g = new MD5CryptoServiceProvider();
				byte[] b = g.ComputeHash(f);
				f.Close();
				string s = System.BitConverter.ToString(b);
				s = s.Replace("-", "");
				return s;
			}
			catch (Exception e)
			{
				return e.Message;
			}
		}

		/// <summary>
		/// 生成随机字符串。
		/// </summary>
		/// <param name="length">目标字符串的长度。</param>
		/// <param name="useNum">是否包含数字，1=包含，默认为包含。</param>
		/// <param name="useLow">是否包含小写字母，1=包含，默认为包含。</param>
		/// <param name="useUpp">是否包含大写字母，1=包含，默认为包含。</param>
		/// <param name="useSpe">是否包含特殊字符，1=包含，默认为不包含<。/param>
		/// <param name="custom">要包含的自定义字符，直接输入要包含的字符列表。</param>
		/// <returns>指定长度的随机字符串。</returns>
		public static string GetRnd(int length, int useNum, int useLow, int useUpp, int useSpe, string custom)
		{
			byte[] b = new byte[4];
			RNGCryptoServiceProvider rng = new RNGCryptoServiceProvider();
			rng.GetBytes(b);

			Random r = new Random(BitConverter.ToInt32(b, 0));
			string s = null, str = custom;
			if (useNum == 1) str += "0123456789";
			if (useLow == 1) str += "abcdefghijklmnopqrstuvwxyz";
			if (useUpp == 1) str += "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
			if (useSpe == 1) str += "!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~";

			for (int i = 0; i < length; i++) { s += str.Substring(r.Next(0, str.Length - 1), 1); }

			return s;
		}
	}
}
