﻿/* 请提高版权意识，不要删除这些版权声明。
 * --------------------------------------------------------------------------------------
 * 产品名称：问沫聚合门户管理系统
 * 产品作者：Guidy
 * 版权所有：问沫工作室 [VMoom Studio]
 * --------------------------------------------------------------------------------------
 * 官方网站：http://www.vmoom.net/
 * 技术论坛：http://bbs.vmoom.net/
 * ------------------------------------------------------------------------------------*/

using System;

namespace LiveUpdate
{
	public sealed class LiveUpdateEventArgs : EventArgs
	{
		private long _CurrentFileSize;
		private string _CurrentFileName;
		private string _CurrentUrl;
		private double _CurrProgress;
		private bool _IsCompleted;
		private string _CurrentStatus;

		public LiveUpdateEventArgs()
		{
			_CurrentFileSize = 0;
			_CurrentUrl = "";
			_IsCompleted = false;
		}

		public long CurrentFileSize
		{
			get { return _CurrentFileSize; }
			set { _CurrentFileSize = value; }
		}

		public string CurrentFileName
		{
			get { return _CurrentFileName; }
			set { _CurrentFileName = value; }
		}

		public string CurrentUrl
		{
			get { return _CurrentUrl; }
			set { _CurrentUrl = value; }
		}

		public double CurrProgress
		{
			get { return _CurrProgress; }
			set { _CurrProgress = value; }
		}

		public bool IsCompleted
		{
			get { return _IsCompleted; }
			set { _IsCompleted = value; }
		}

		public string CurrentStatus
		{
			get { return _CurrentStatus; }
			set { _CurrentStatus = value; }
		}
	}
}
