﻿/* 请提高版权意识，不要删除这些版权声明。
 * --------------------------------------------------------------------------------------
 * 产品名称：问沫聚合门户管理系统
 * 产品作者：Guidy
 * 版权所有：问沫工作室 [VMoom Studio]
 * --------------------------------------------------------------------------------------
 * 官方网站：http://www.vmoom.net/
 * 技术论坛：http://bbs.vmoom.net/
 * ------------------------------------------------------------------------------------*/

using System;
using System.Data;
using System.IO;
using System.Net;
using System.Text.RegularExpressions;
using System.Threading;
using System.Windows.Forms;
using System.Xml;
using LiveUpdate.Framework;

namespace LiveUpdate
{
	public sealed class LiveUpdateProvider
	{
		public const string UpdateFilesDirectory = "http://www.vmoom.net/qqlm/update/updatefiles/";
		public const string DeletedFilesDirectory = "http://www.vmoom.net/qqlm/update/deletefiles/";
		public const string ExecuteFilesDirectory = "http://www.vmoom.net/qqlm/update/executefiles/";

		public event LiveUpdateProgressChanged ProgressChanged;
		public static object SyncObject = new Object();

		public static DataTable FileList = new DataTable();
		private XmlDocument _UpdateDocument = null;

		private string _UpdateInfo = "";

		static LiveUpdateProvider()
		{
			FileList.Columns.Add("FileSN", typeof(string));
			FileList.Columns.Add("FileName", typeof(string));
			FileList.Columns.Add("FileSize", typeof(string));
			FileList.Columns.Add("FileVersion", typeof(string));
			FileList.Columns.Add("FileUpdateTime", typeof(string));
			FileList.Columns.Add("UpdateMethod", typeof(string));

			// 修改并发连接数
			ServicePointManager.DefaultConnectionLimit = 100; 
		}

		public bool HaveUpdate
		{
			get
			{
				if (this.UpdateDocument == null) return false;

				int i = 0;
				XmlNodeList xnl = this.UpdateDocument.SelectNodes("/QQLoginManager/UpdateFileList/File");

				foreach (XmlNode node in xnl)
				{
					string filename = node.InnerText;
					int filesize = int.Parse(node.Attributes["FileSize"].Value);
					string fileversion = node.Attributes["FileVersion"].Value;
					DateTime updatetime = DateTime.Parse(node.Attributes["FileUpdateTime"].Value);
					string method = node.Attributes["UpdateMethod"].Value;

					FileInfo f = null;
					string localfile = ".\\" + filename;
					if (File.Exists(localfile)) f = new FileInfo(localfile);

					// 如果本地不存在需要删除的文件，则跳过
					if (f == null && method == "删除") continue;

					// 只对文件的最后更新日期执行比对即可
					if (f == null || method == "删除" || updatetime.CompareTo(f.LastWriteTime) > 0)
					{
						i++;

						LiveUpdateProvider.FileList.Rows.Add(new object[] { i, filename, filesize, fileversion, updatetime.ToString("yyyy-MM-dd HH:mm:ss"), method });
					}
				}

				_UpdateInfo = this.UpdateDocument.SelectSingleNode("/QQLoginManager/UpdateInfo").InnerText;

				return LiveUpdateProvider.FileList.Rows.Count > 0;
			}
		}

		private LiveUpdateEventArgs _LiveUpdateEventArgs = new LiveUpdateEventArgs();

		public bool Download()
		{
			bool b = false;

			try
			{
				foreach (DataRow file in LiveUpdateProvider.FileList.Rows)
				{
					string filename = file["FileName"].ToString();
					string fileurl = "";

					if (file["UpdateMethod"].ToString() == "删除")
					{
						int filesize = int.Parse(file["FileSize"].ToString());
						fileurl = String.Format("{0}{1}", LiveUpdateProvider.DeletedFilesDirectory, filename);
						_DoEvent(fileurl, filename, filesize, 100, true, "无需下载");
						continue;
					}
					else if (file["UpdateMethod"].ToString() == "更新")
						fileurl = String.Format("{0}{1}", LiveUpdateProvider.UpdateFilesDirectory, filename);
					else if (file["UpdateMethod"].ToString() == "执行")
						fileurl = String.Format("{0}{1}", LiveUpdateProvider.ExecuteFilesDirectory, filename);

					Thread thread = new Thread(new ThreadStart(_Download));
					thread.Name = fileurl;
					thread.IsBackground = true;
					thread.Start();
				}

				b = true;
			}
			catch
			{
				b = false;
			}

			return b;
		}

		private void _Download()
		{
			string fileurl = Thread.CurrentThread.Name;
			string filename = Regex.Replace(fileurl, @"^.+/", "");
			int retry = 0;

		retryits:
			try
			{
				HttpWebRequest request = (HttpWebRequest)HttpWebRequest.Create(fileurl);
				HttpWebResponse response = (HttpWebResponse)request.GetResponse();

				long totalBytes = response.ContentLength;
				Stream st = response.GetResponseStream();
				Stream so = new FileStream(this.TempDirectory + filename, FileMode.OpenOrCreate, FileAccess.ReadWrite, FileShare.ReadWrite);

				_DoEvent(fileurl, filename, totalBytes, 0, false, "开始下载....");

				long totalDownloadedByte = 0;
				byte[] by = new byte[4096];

				int osize = st.Read(by, 0, (int)by.Length);
				while (osize > 0)
				{
					totalDownloadedByte = osize + totalDownloadedByte;
					so.Write(by, 0, osize);
					osize = st.Read(by, 0, (int)by.Length);

					double p = totalDownloadedByte * 100.0 / totalBytes;
					if (p >= 100.0) p = 100.0;

					_DoEvent(fileurl, filename, totalBytes, p, false, String.Format("正在下载：{0}", Utils.FormatFileSize(totalDownloadedByte)));
				}

				so.Close();
				st.Close();

				_DoEvent(fileurl, filename, totalBytes, 100, true, "下载完成");
			}
			catch (Exception ex)
			{
				retry++;
				if (retry < 5)
				{
					_DoEvent(fileurl, filename, 0, 0, false, String.Format("下载失败，第 {0} 次重试", retry));

					// 休息 5 秒钟然后重试
					Thread.Sleep(5000);
					goto retryits;
				}
				else
				{
					_DoEvent(fileurl, filename, 0, 0, false, "下载失败，原因是：" + ex.Message);
				}
			}
			finally
			{
				Thread.Sleep(100);
			}
		}

		private void _DoEvent(string url, string filename, long filesize, double progress, bool iscompleted, string currentstatus)
		{
			if (ProgressChanged != null)
			{
				_LiveUpdateEventArgs.CurrentFileName = filename;
				_LiveUpdateEventArgs.CurrentFileSize = filesize;
				_LiveUpdateEventArgs.CurrentUrl = url;
				_LiveUpdateEventArgs.CurrProgress = progress;
				_LiveUpdateEventArgs.IsCompleted = iscompleted;
				_LiveUpdateEventArgs.CurrentStatus = currentstatus;

				this.ProgressChanged(this, _LiveUpdateEventArgs);

				Application.DoEvents();
			}
		}

		public string GetFileUrl(string filename)
		{
			foreach (DataRow dr in LiveUpdateProvider.FileList.Rows)
			{
				string file = dr["FileName"].ToString();

				if (filename.IndexOf(file, StringComparison.OrdinalIgnoreCase) > -1)
				{
					string fileurl = "";

					if (dr["UpdateMethod"].ToString() == "删除")
						fileurl = String.Format("{0}{1}", LiveUpdateProvider.DeletedFilesDirectory, file);
					else if (dr["UpdateMethod"].ToString() == "更新")
						fileurl = String.Format("{0}{1}", LiveUpdateProvider.UpdateFilesDirectory, file);
					else if (dr["UpdateMethod"].ToString() == "执行")
						fileurl = String.Format("{0}{1}", LiveUpdateProvider.ExecuteFilesDirectory, file);

					return fileurl;
				}
			}

			return "";
		}

		#region 公有属性

		public string TempDirectory
		{
			get
			{
				string temp = ".\\Update\\";
				if (!Directory.Exists(temp)) Directory.CreateDirectory(temp);

				return temp;
			}
		}

		public string UserAgent
		{
			get
			{
				return String.Format("LiveUpdate ({0}; QQLoginManager; http://www.vmoom.net/)", Application.ProductVersion);
			}
		}

		/// <summary>
		/// 获取更新文档，以备版本比对。
		/// </summary>
		public XmlDocument UpdateDocument
		{
			get
			{
				if (_UpdateDocument == null)
				{
					try
					{
						_UpdateDocument = new XmlDocument();
						_UpdateDocument.Load("http://www.vmoom.net/qqlm/update/?t=" + DateTime.Now.Ticks);
					}
					catch
					{
						_UpdateDocument = null;
					}
				}

				return _UpdateDocument;
			}
		}

		/// <summary>
		/// 更新内容。
		/// </summary>
		public string UpdateInfo
		{
			get { return _UpdateInfo; }
		}

		#endregion
	}
}
