﻿/* 请提高版权意识，不要删除这些版权声明。
 * --------------------------------------------------------------------------------------
 * 产品名称：问沫聚合门户管理系统
 * 产品作者：Guidy
 * 版权所有：问沫工作室 [VMoom Studio]
 * --------------------------------------------------------------------------------------
 * 官方网站：http://www.vmoom.net/
 * 技术论坛：http://bbs.vmoom.net/
 * ------------------------------------------------------------------------------------*/

using System;
using System.Diagnostics;
using System.IO;
using System.Windows.Forms;

namespace LiveUpdate
{
	static class Program
	{
		/// <summary>
		/// 应用程序的主入口点。
		/// </summary>
		[STAThread]
		static void Main(string[] args)
		{
			ToolStripManager.VisualStylesEnabled = false;
			Application.EnableVisualStyles();
			Application.SetCompatibleTextRenderingDefault(false);

			// /su:{0}

			string su = "";

			UpdateForm uf = null;

			if (args != null && args.Length > 0)
			{
				int l = args.Length;

				for (int i = 0; i < l; i++)
				{
					if (args[i].StartsWith("/su:", StringComparison.OrdinalIgnoreCase)) su = args[i].Substring(4);
				}

				if (su == "1")
				{
					// 删除临时文件
					if (Directory.Exists(".\\Update\\"))
						Directory.Delete(".\\Update\\", true);

					MessageBox.Show("恭喜您！您的 QQ 登录助手已经更新到最新版本！", "QQ 登录助手 - 在线升级", MessageBoxButtons.OK, MessageBoxIcon.Information);

					// 启动程序
					Process pro = new Process();
					pro.StartInfo.FileName = ".\\QQLoginManager.exe";
					pro.Start();

					return;
				}
			}

			if (uf == null) uf = new UpdateForm();
			
			Application.Run(uf);
		}
	}
}
