﻿/* 请提高版权意识，不要删除这些版权声明。
 * --------------------------------------------------------------------------------------
 * 产品名称：问沫聚合门户管理系统
 * 产品作者：Guidy
 * 版权所有：问沫工作室 [VMoom Studio]
 * --------------------------------------------------------------------------------------
 * 官方网站：http://www.vmoom.net/
 * 技术论坛：http://bbs.vmoom.net/
 * ------------------------------------------------------------------------------------*/

using System;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading;
using System.Windows.Forms;
using LiveUpdate.Framework;
using LiveUpdate.Framework.Forms;

namespace LiveUpdate
{
	public partial class UpdateForm : Form
	{
		private LiveUpdateProvider _LiveUpdateProvider;
		private ImageList _ImageList;
		TextBox _UpdateInfoTextBox = new TextBox();

		private Thread _AutoUpdateThread;

		public UpdateForm()
		{
			InitializeComponent();

			_ImageList = new ImageList();
			_ImageList.ImageSize = new Size(1, 18);
			this.UpdateFileList.SmallImageList = _ImageList;
			this.UpdateFileList.DrawColumnHeader += new DrawListViewColumnHeaderEventHandler(UpdateFileList_DrawColumnHeader);
			this.UpdateFileList.DrawSubItem += new DrawListViewSubItemEventHandler(UpdateFileList_DrawSubItem);
			new ListViewSortManager(this.UpdateFileList, new Type[] { typeof(ListViewInt32Sort), typeof(ListViewTextCaseInsensitiveSort), typeof(ListViewTextCaseInsensitiveSort), typeof(ListViewDoubleSort), typeof(ListViewTextCaseInsensitiveSort) }, 0, SortOrder.Ascending);

			_LiveUpdateProvider = new LiveUpdateProvider();

			this.MainPannel.Controls.Add(_UpdateInfoTextBox);

			_UpdateInfoTextBox.Multiline = true;
			_UpdateInfoTextBox.ScrollBars = ScrollBars.Vertical;
			_UpdateInfoTextBox.Dock = DockStyle.Fill;
			_UpdateInfoTextBox.ReadOnly = true;
			_UpdateInfoTextBox.BackColor = Color.White;
			_UpdateInfoTextBox.Text = "正在检查更新....";
		}

		private void _InitFileList()
		{
			int i = 0;
			foreach (DataRow file in LiveUpdateProvider.FileList.Rows)
			{
				string fileurl = "";
				string filename = file["FileName"].ToString();
				int filesize = int.Parse(file["FileSize"].ToString());
				string fileversion = file["FileVersion"].ToString();
				DateTime updatetime = DateTime.Parse(file["FileUpdateTime"].ToString());
				string method = file["UpdateMethod"].ToString();
				FileInfo f = new FileInfo(".\\" + filename);

				fileversion = fileversion == "0" ? "无" : fileversion;

				if (file["UpdateMethod"].ToString() == "删除")
					fileurl = String.Format("{0}{1}", LiveUpdateProvider.DeletedFilesDirectory, filename);
				else if (file["UpdateMethod"].ToString() == "更新")
					fileurl = String.Format("{0}{1}", LiveUpdateProvider.UpdateFilesDirectory, filename);
				else if (file["UpdateMethod"].ToString() == "执行")
					fileurl = String.Format("{0}{1}", LiveUpdateProvider.ExecuteFilesDirectory, filename);

				i++;
				ListViewItem lvi = new ListViewItem(i.ToString());

				lvi.ToolTipText = String.Format("此文件的最后修改日期：{0}", updatetime);
				lvi.Name = fileurl;
				lvi.SubItems.Add(filename);
				lvi.SubItems.Add(fileversion);
				lvi.SubItems.Add("0");
				lvi.SubItems.Add(String.Format("操作：{0};{1}", method, Utils.FormatFileSize(filesize)));

				_AddListViewItem(lvi);
			}
		}

		private void UpdateFileList_DrawSubItem(object sender, DrawListViewSubItemEventArgs e)
		{
			int left = e.SubItem.Bounds.Left + 3;
			int top = e.SubItem.Bounds.Top + 2;
			int width = e.SubItem.Bounds.Width - 6;
			int height = e.SubItem.Bounds.Height - 6;

			Brush bb = SystemBrushes.Window;
			Brush hb = SystemBrushes.Highlight;

			Rectangle rec1 = new Rectangle(left, top, width, height);

			string text = e.SubItem.Text;

			if (e.ColumnIndex == 3)
			{
				e.DrawDefault = false;

				double p = 0;

				if (double.TryParse(text, out p) == false) p = 0;
				if (p > 100) p = 100;

				text = String.Format("{0:F2}%", p);

				Rectangle rec2 = new Rectangle(left + 2, top + 2, (int)Math.Ceiling((width - 3) * p / 100.0), height - 3);
				if (rec2.Width == 0) rec2.Width = 1;

				// 焦点处理
				if (!this.UpdateFileList.Focused)
				{
					hb = SystemBrushes.Control;
				}

				// 如果行被选中的时候绘制高亮背景
				if (e.Item.Selected)
				{
					e.Graphics.FillRectangle(hb, e.Bounds);
				}

				// 绘制总体背景
				e.Graphics.FillRectangle(Brushes.White, rec1);

				// 绘制边框
				e.Graphics.DrawRectangle(Pens.DarkGray, rec1);

				LinearGradientBrush brush = new LinearGradientBrush(rec2, Color.LightGreen, Color.YellowGreen, LinearGradientMode.BackwardDiagonal);

				// 绘制文本
				StringFormat format = new StringFormat();
				format.FormatFlags = StringFormatFlags.NoWrap;

				Font f = new Font(this.Font.FontFamily, 9, FontStyle.Regular);
				SizeF fsize = e.Graphics.MeasureString(text, f);
				int fleft = rec1.Left + (rec1.Width - (int)fsize.Width) / 2;
				int ftop = rec1.Top + (rec1.Height - (int)fsize.Height) / 2 + 1;

				e.Graphics.DrawString(text, f, Brushes.Black, fleft, ftop, format);

				// 绘制进度
				if (p > 0)
				{
					GraphicsPath gp = new GraphicsPath(FillMode.Alternate);

					gp.AddRectangle(rec2);
					e.Graphics.SetClip(gp, CombineMode.Intersect);

					e.Graphics.FillRectangle(brush, gp.GetBounds());
					
					// 遮蔽效果
					brush.LinearColors = new Color[] { Color.YellowGreen, Color.LightGreen };
					e.Graphics.DrawString(text, f, SystemBrushes.HighlightText, fleft, ftop, format);

					e.Graphics.ResetClip();
				}

				e.Graphics.Flush();
			}
			else
			{
				e.DrawDefault = true;
			}
		}

		private void UpdateFileList_DrawColumnHeader(object sender, DrawListViewColumnHeaderEventArgs e)
		{
			e.DrawDefault = true;
		}

		private void UpdateForm_Load(object sender, EventArgs e)
		{
			_AutoUpdateThread = new Thread(new ThreadStart(_InitAutoUpdate));
			_AutoUpdateThread.IsBackground = true;
			_AutoUpdateThread.Start();
		}

		private void _InitAutoUpdate()
		{
			if (_LiveUpdateProvider.HaveUpdate)
			{
				_InitFileList();
				_SetButtonEnabled(this.NextButton, true, "");

				_SetTextBox(_UpdateInfoTextBox, _LiveUpdateProvider.UpdateInfo);
			}
			else
			{
				_SetTextBox(_UpdateInfoTextBox, "暂时没有可用的更新。");

				_SetButtonEnabled(this.CannelUpdate, true, "完成");
				_SetButtonEnabled(this.NextButton, false, "下一步");

				_Step = -1;
			}
		}

		private void panel1_Paint(object sender, PaintEventArgs e)
		{
			e.Graphics.DrawLine(Pens.Gray, e.ClipRectangle.Left, e.ClipRectangle.Bottom - 2, e.ClipRectangle.Right, e.ClipRectangle.Bottom - 2);
			e.Graphics.DrawLine(Pens.White, e.ClipRectangle.Left, e.ClipRectangle.Bottom - 1, e.ClipRectangle.Right, e.ClipRectangle.Bottom - 1);

			e.Graphics.Flush();
		}

		private void CannelUpdate_Click(object sender, EventArgs e)
		{
			if (this.CannelUpdate.Text == "完成" && _Step != -1)
			{
				// 删除临时文件
				if (Directory.Exists(".\\Update\\"))
					Directory.Delete(".\\Update\\", true);

				// 启动程序
				Process pro = new Process();
				pro.StartInfo.FileName = ".\\QQLoginManager.exe";
				pro.Start();
			}

			_Exit();
		}

		private void _Exit()
		{
			Application.ExitThread();
			Application.Exit();
		}

		private int _Step = 0;
		private void NextButton_Click(object sender, EventArgs e)
		{
			switch (_Step)
			{
				case -1:
					_Exit();

					break;
				case 0:
					_UpdateInfoTextBox.Visible = false;
					this.UpdateFileList.Visible = true;
					this.NextButton.Focus();

					_Step++;

					break;
				case 1:
					
					this.MinAsIcon.Enabled = true;
					this.NextButton.Enabled = false;
					
					_LiveUpdateProvider.ProgressChanged += new LiveUpdateProgressChanged(_LiveUpdateProvider_ProgressChanged);
					_LiveUpdateProvider.Download();

					_Step++;

					break;
				default:
					// 关闭主程序
					Process[] process = Process.GetProcessesByName("QQLoginManager");

					foreach (Process p in process)
					{
						for (int i = 0; i < p.Threads.Count; i++)
							p.Threads[i].Dispose();

						p.Kill();
						p.WaitForExit();
					}

					bool updateself = false;
					if (Directory.Exists(".\\Update\\"))
					{
						foreach (string file in Directory.GetFiles(".\\Update\\"))
						{
							bool isexec = false;
							string filename = ".\\" + Regex.Replace(file, @"^.+\\", "");
							string url = _LiveUpdateProvider.GetFileUrl(filename.Replace(".\\", "/"));

							foreach (DataRow dr in LiveUpdateProvider.FileList.Rows)
							{
								string rf = dr["FileName"].ToString();

								if (url.IndexOf(rf, StringComparison.OrdinalIgnoreCase) > -1)
									if (dr["UpdateMethod"].ToString() == "执行") isexec = true;
							}

							if (isexec)
								_SetProgressValue(url, 0, "正在执行....");
							else
								_SetProgressValue(url, 0, "正在更新....");

							if (Application.ExecutablePath.IndexOf(filename.Replace(".\\", ""), StringComparison.OrdinalIgnoreCase) > -1)
							{
								updateself = true;
								continue;
							}

							try
							{
								if (File.Exists(filename))
									File.Delete(filename);

								File.Copy(file, filename, true);

								_SetProgressValue(url, 0, "更新成功！");

								_SetButtonEnabled(this.CannelUpdate, true, "完成");
								_SetButtonEnabled(this.NextButton, false, "下一步");
							}
							catch (Exception ex)
							{
								_SetProgressValue(url, 0, "更新失败，原因是：" + ex.Message);

								_SetButtonEnabled(this.CannelUpdate, true, "重试");
							}
						}
					}

					// 需要删除或执行的文件
					try
					{
						foreach (DataRow file in LiveUpdateProvider.FileList.Rows)
						{
							string filename = file["FileName"].ToString();
							string url = _LiveUpdateProvider.GetFileUrl("/" + filename);

							if (file["UpdateMethod"].ToString() == "删除")
							{
								File.Delete(".\\" + filename);

								_SetProgressValue(url, 0, "删除成功！");
							}

							if (file["UpdateMethod"].ToString() == "执行")
							{
								Process pro = new Process();
								pro.StartInfo.FileName = ".\\Update\\" + filename;
								pro.Start();

								_SetProgressValue(url, 0, "已经执行！");
							}
						}

						_SetButtonEnabled(this.CannelUpdate, true, "完成");
						_SetButtonEnabled(this.NextButton, false, "下一步");
					}
					catch
					{
					}

					// 自更新
					if (updateself) _UpdateSelf();
					break;
			}
		}

		/// <summary>
		/// 以命令行的形式实现 LiveUpdate.exe 自更新。
		/// </summary>
		private void _UpdateSelf()
		{
			string filename = Path.Combine(Environment.CurrentDirectory, "Update.bat");

			StringBuilder s = new StringBuilder();
			s.AppendLine("@ECHO OFF");
			s.AppendLine();
			s.AppendLine(":Selfkill");
			s.AppendLine("ATTRIB -a -r -s -h \"{0}\"");
			s.AppendLine("DEL \"{0}\"");
			s.AppendLine("IF EXIST \"{0}\" GOTO Selfkill");
			s.AppendLine();
			s.AppendLine("COPY /y \"{1}\" \"{0}\"");
			s.AppendLine();
			s.AppendLine("TIMEOUT /t 3");
			s.AppendLine("\"{0}\" /su:1");
			s.AppendLine();
			s.AppendLine("DEL %0");

			using (StreamWriter bat = File.CreateText(filename))
			{
				string t = Regex.Replace(Application.ExecutablePath, @"^.+\\([^\\\\]+?)$", @".\$1");
				string f = t.Replace(@".\", @".\Update\");

				bat.WriteLine(String.Format(s.ToString(), t, f));
			}

			ProcessStartInfo process = new ProcessStartInfo(filename);
			process.WindowStyle = ProcessWindowStyle.Hidden;
			Process.Start(process);

			Environment.Exit(0);
		}

		private bool _IsDownloaded = false;
		private void _LiveUpdateProvider_ProgressChanged(object sender, LiveUpdateEventArgs e)
		{
			_SetProgressValue(e.CurrentUrl, e.CurrProgress, e.CurrentStatus);
		}

		public delegate void _SetTextBoxValueCallBack(TextBox box, string text);
		private void _SetTextBox(TextBox box, string text)
		{
			if (box.InvokeRequired)
			{
				_SetTextBoxValueCallBack d = new _SetTextBoxValueCallBack(_SetTextBox);
				box.Invoke(d, new object[] { box, text });
			}
			else
			{
				if (text != null && text.Length > 0)
					box.Text = text;
			}
		}

		public delegate void _ShowBalloonTipCallBack(int timeout, string tipTitle, string tipText, ToolTipIcon tipIcon);
		private void _ShowBalloonTip(int timeout, string tipTitle, string tipText, ToolTipIcon tipIcon)
		{
			if (this.InvokeRequired)
			{
				_ShowBalloonTipCallBack d = new _ShowBalloonTipCallBack(_ShowBalloonTip);
				this.Invoke(d, new object[] { timeout, tipTitle, tipText, tipIcon });
			}
			else
			{
				if (this.UpdateNotifyIcon.Visible)
					this.UpdateNotifyIcon.ShowBalloonTip(timeout, tipTitle, tipText, tipIcon);
			}
		}

		public delegate void SetButtonEnabledCallBack(Button b, bool enabled, string text);
		private void _SetButtonEnabled(Button b, bool enabled, string text)
		{
			if (b.InvokeRequired)
			{
				SetButtonEnabledCallBack d = new SetButtonEnabledCallBack(_SetButtonEnabled);
				b.Invoke(d, new object[] { b, enabled, text });
			}
			else
			{
				if (b != null)
				{
					b.Enabled = enabled;
					if (text != null && text.Length > 0) b.Text = text;
				}
			}
		}

		public delegate void AddListViewItemCallBack(ListViewItem lvi);
		private void _AddListViewItem(ListViewItem lvi)
		{
			if (this.UpdateFileList.InvokeRequired)
			{
				AddListViewItemCallBack d = new AddListViewItemCallBack(_AddListViewItem);
				this.UpdateFileList.Invoke(d, new object[] { lvi });
			}
			else
			{
				if (lvi != null)
				{
					this.UpdateFileList.Items.Add(lvi);
				}

				//if (!this.UpdateFileList.Visible) this.UpdateFileList.Visible = true;
			}
		}

		public delegate void SetProgressValueCallBack(string key, double value, string status);
		private void _SetProgressValue(string key, double value, string status)
		{
			if (this.UpdateFileList.InvokeRequired)
			{
				SetProgressValueCallBack d = new SetProgressValueCallBack(_SetProgressValue);
				this.UpdateFileList.Invoke(d, new object[] { key, value, status });
			}
			else
			{
				ListViewItem lvic = this.UpdateFileList.Items[key];

				if (lvic != null && lvic.SubItems.Count > 0)
				{
					if (value > 0) lvic.SubItems[3].Text = value.ToString();
					if (status.Length > 0) lvic.SubItems[4].Text = status;
				}

				if (value == 100)
				{
					foreach (ListViewItem item in this.UpdateFileList.Items)
					{
						if (item.SubItems[4].Text != "下载完成" && item.SubItems[4].Text != "无需下载")
							return;
					}

					_IsDownloaded = true;
					_SetButtonEnabled(this.NextButton, true, "下一步");
					_ShowBalloonTip(5000, this.Text, "文件已经下载完毕，点击此处开始更新！", ToolTipIcon.Info);
				}

				Application.DoEvents();
			}
		}

		private void MinAsIcon_CheckedChanged(object sender, EventArgs e)
		{
			if (this.MinAsIcon.Checked)
				_MinAsIcon();
			else
				_MaxFromIcon();
		}

		private bool _IsTipsShown = false;
		private void _MinAsIcon()
		{
			this.ShowInTaskbar = false;
			this.Visible = false;
			this.UpdateNotifyIcon.Visible = true;

			if (!_IsTipsShown)
			{
				_IsTipsShown = true;
				if (!_IsDownloaded) _ShowBalloonTip(5000, this.Text, "程序正在下载更新文件，下载完毕时会提示您安装！", ToolTipIcon.Info);
			}
		}

		private void _MaxFromIcon()
		{
			if (!this.Visible)
			{
				this.MinAsIcon.Enabled = !_IsDownloaded;
				this.MinAsIcon.Checked = false;
				this.ShowInTaskbar = true;
				this.Visible = true;
				this.UpdateNotifyIcon.Visible = false;
			}
		}

		private void tsmi_ShowMain_Click(object sender, EventArgs e)
		{
			_MaxFromIcon();
		}

		private void tsmi_Exit_Click(object sender, EventArgs e)
		{
			_Exit();
		}

		private void UpdateNotifyIcon_BalloonTipClicked(object sender, EventArgs e)
		{
			if (this.UpdateNotifyIcon.Visible && _IsDownloaded)
				_MaxFromIcon();
		}
	}
}
