﻿/* 请提高版权意识，不要删除这些版权声明。
 * --------------------------------------------------------------------------------------
 * 产品名称：问沫聚合门户管理系统
 * 产品作者：Guidy
 * 版权所有：问沫工作室 [VMoom Studio]
 * --------------------------------------------------------------------------------------
 * 官方网站：http://www.vmoom.net/
 * 技术论坛：http://bbs.vmoom.net/
 * ------------------------------------------------------------------------------------*/

using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing.Design;
using System.IO;
using System.Windows.Forms.Design;
using Microsoft.Win32;
using QQLoginManager.Framework;

namespace QQLoginManager.Configuration
{
	public sealed class ConfigProvider
	{
		private string _QQPath;
		private string _DataFileName;
		private bool _AutoClose;
		private bool _AutoSelectAll;
		private bool _AutoCheck;
		private int _CheckTimeSpan;
		private INI _ini;

		public ConfigProvider()
		{
			_ini = new INI(Environment.CurrentDirectory + @".\Config.ini");
			_Init();
		}

		private void _Init()
		{
			_QQPath = _ini.Read("General", "QQPath");
			_DataFileName = _ini.Read("General", "DataFileName");
			if (_DataFileName == null || _DataFileName.Length == 0) _DataFileName = @".\Data.xml";
			if (Boolean.TryParse(_ini.Read("Advanced", "AutoClose"), out _AutoClose) == false) _AutoClose = false;
			if (Boolean.TryParse(_ini.Read("Advanced", "AutoSelectAll"), out _AutoSelectAll) == false) _AutoSelectAll = true;
			if (Boolean.TryParse(_ini.Read("AutoCheck", "AutoCheck"), out _AutoCheck) == false) _AutoCheck = true;
			if (int.TryParse(_ini.Read("AutoCheck", "CheckTimeSpan"), out _CheckTimeSpan) == false) _CheckTimeSpan = 5000;

			// 默认从注册表读取 QQ 安装目录的路径
			if (_QQPath == null || _QQPath.Length == 0)
			{
				// HKEY_LOCAL_MACHINE\SOFTWARE\TENCENT\QQ
				// HKEY_LOCAL_MACHINE\SOFTWARE\Tencent\QQ
				// Install = E:\Program Files\Tencent\QQ\

				// HKEY_LOCAL_MACHINE\SOFTWARE\Tencent\PlatForm_Type_List\1
				// TypePath = E:\Program Files\Tencent\QQ\QQ.exe

				try
				{
					RegistryKey qq = Registry.LocalMachine.OpenSubKey(@"SOFTWARE\TENCENT\QQ");

					if (qq == null)
					{
						qq = Registry.LocalMachine.OpenSubKey(@"SOFTWARE\TENCENT\PlatForm_Type_List\1");
						
						_QQPath = qq.GetValue("TypePath", "") as string;
					}
					else
					{
						_QQPath = qq.GetValue("Install", "") as string;
						_QQPath = _QQPath == null ? "" : _QQPath + "QQ.exe";
					}
				}
				catch { }
			}
		}

		/// <summary>
		/// 保存配置。
		/// </summary>
		public void Save()
		{
			_ini.Write("General", "QQPath", _QQPath);
			_ini.Write("General", "DataFileName", _DataFileName);
			_ini.Write("Advanced", "AutoClose", _AutoClose.ToString());
			_ini.Write("Advanced", "AutoSelectAll", _AutoSelectAll.ToString());
			_ini.Write("AutoCheck", "AutoCheck", _AutoCheck.ToString());
			_ini.Write("AutoCheck", "CheckTimeSpan", _CheckTimeSpan.ToString());
		}

		/// <summary>
		/// 获取当前设定的 QQ 路径指向的是否为 QQ 2009。
		/// </summary>
		[Browsable(false)]
		public bool IsQQ2009
		{
			get
			{
				bool b = false;

				if (File.Exists(this.QQPath))
				{
					FileVersionInfo fi = FileVersionInfo.GetVersionInfo(this.QQPath);
					string s = fi.ProductName;
					if (s == null) return false;
					s = s.Trim();
					b = (s == "QQ2009");
				}

				return b;
			}
		}

		/// <summary>
		/// 设置或获取 QQ 应用程序路径。
		/// </summary>
		[Browsable(true), Category("常规"), DisplayName("QQ 路径"), Description("QQ 应用程序路径（也可以直接设定为外挂的程序路径）。"), Editor(typeof(FileNameEditor), typeof(UITypeEditor))]
		public string QQPath
		{
			get { return _QQPath; }
			set { _QQPath = value; }
		}

		/// <summary>
		/// 设置或获取 QQ 号码信息数据文件所在的路径。
		/// </summary>
		[Browsable(true), Category("常规"), DisplayName("数据库路径"), Description("QQ 号码数据库路径，不允许修改此项。"), Editor(typeof(FileNameEditor), typeof(UITypeEditor)), DefaultValue(@".\Data.xml")]
		public string DataFileName
		{
			get { return _DataFileName; }
			set { _DataFileName = value; }
		}

		/// <summary>
		/// 设置或获取 QQ 登录完成之后是否自动关闭本登录助手。
		/// </summary>
		[TypeConverter(typeof(BoolValueConverter))]
		[Browsable(true), Category("高级"), DisplayName("自动关闭"), Description("QQ 登录完成之后是否自动关闭本登录助手，默认为 False。"), DefaultValue(false)]
		public bool AutoClose
		{
			get { return _AutoClose; }
			set { _AutoClose = value; }
		}

		/// <summary>
		/// 设置或获取是否在程序初始化完毕时自动全选所有 QQ 号码。
		/// </summary>
		[TypeConverter(typeof(BoolValueConverter))]
		[Browsable(true), Category("高级"), DisplayName("自动全选"), Description("是否在程序初始化完毕时自动全选所有 QQ 号码，默认为 True。"), DefaultValue(true)]
		public bool AutoSelectAll
		{
			get { return _AutoSelectAll; }
			set { _AutoSelectAll = value; }
		}

		/// <summary>
		/// 设置或获取是否自动检测 QQ 在线状态。
		/// </summary>
		[TypeConverter(typeof(BoolValueConverter))]
		[Browsable(true), Category("状态检测"), DisplayName("自动检测"), Description("是否自动检测 QQ 在线状态，默认为 True。"), DefaultValue(true)]
		public bool AutoCheck
		{
			get { return _AutoCheck; }
			set { _AutoCheck = value; }
		}

		/// <summary>
		/// 设置或获取 QQ 状态检测的时间间隔。
		/// </summary>
		[Browsable(true), Category("状态检测"), DisplayName("检测周期"), Description("QQ 状态检测的时间间隔，默认为 5000 毫秒(1秒=1000毫秒)。"), DefaultValue(5000)]
		public int CheckTimeSpan
		{
			get { return _CheckTimeSpan; }
			set { _CheckTimeSpan = value; }
		}
	}
}
