﻿/* 请提高版权意识，不要删除这些版权声明。
 * --------------------------------------------------------------------------------------
 * 产品名称：问沫聚合门户管理系统
 * 产品作者：Guidy
 * 版权所有：问沫工作室 [VMoom Studio]
 * --------------------------------------------------------------------------------------
 * 官方网站：http://www.vmoom.net/
 * 技术论坛：http://bbs.vmoom.net/
 * ------------------------------------------------------------------------------------*/

using System.Runtime.InteropServices;
using System.Text;

namespace QQLoginManager.Framework
{
	/// <summary>
	/// .INI文件操作类
	/// </summary>
	public class INI
	{
		private string _Path;

		[DllImport("kernel32")]
		private static extern long WritePrivateProfileString(string section, string key, string val, string filePath);

		[DllImport("kernel32")]
		private static extern int GetPrivateProfileString(string section, string key, string def, StringBuilder retVal, int size, string filePath);

		public INI(string path)
		{
			_Path = path;
		}

		/// <summary>
		/// 为 INI 文件指定小节写入一个项和值
		/// </summary>
		/// <param name="Section">小节名，不区分大小写</param>
		/// <param name="Key">项名，不区分大小写</param>
		/// <param name="value">值，如果取值为null该项会被删除</param>
		public void Write(string Section, string Key, string value)
		{
			WritePrivateProfileString(Section, Key, value, _Path);
		}

		/// <summary>
		/// 读取 INI 文件指定小节的项值
		/// </summary>
		/// <param name="Section">小节名，不区分大小写</param>
		/// <param name="Key">项名，不区分大小写</param>
		/// <returns>值</returns>
		public string Read(string Section, string Key)
		{
			StringBuilder temp = new StringBuilder(255);

			int i = GetPrivateProfileString(Section, Key, "", temp, 255, _Path);
			return temp.ToString();
		}

		/// <summary>
		/// 设置或获取 INI 文件的路径
		/// </summary>
		public string Path
		{
			get { return _Path; }
			set { _Path = value; }
		}
	}
}
