﻿/* 请提高版权意识，不要删除这些版权声明。
 * --------------------------------------------------------------------------------------
 * 产品名称：问沫聚合门户管理系统
 * 产品作者：Guidy
 * 版权所有：问沫工作室 [VMoom Studio]
 * --------------------------------------------------------------------------------------
 * 官方网站：http://www.vmoom.net/
 * 技术论坛：http://bbs.vmoom.net/
 * ------------------------------------------------------------------------------------*/

using System;
using System.Diagnostics;

namespace QQLoginManager.Framework
{
	/// <summary>
	/// QQ 帐号。
	/// </summary>
	public class QQAccount
	{
		#region 私有字段
		
		private string _UserName;
		private string _UserPass;
		private string _UserPassHash;
		private QQLoginState _InitState;
		private QQLoginState _CurrState;

		#endregion

		#region 构造函数

		/// <summary>
		/// 初始化 QQ 帐号。
		/// </summary>
		/// <param name="username">包含 QQ 帐号名称的字符串。</param>
		/// <param name="userpasshash">包含 QQ 帐号 Hash 形式密码的字符串。</param>
		/// <param name="state">包含 QQ 登录状态的字符串。</param>
		public QQAccount(string username, string userpasshash, string state)
		{
			if (String.IsNullOrEmpty(username) == true) { throw new ArgumentException("用户名不能为空！"); }
			if (String.IsNullOrEmpty(userpasshash) == true) { throw new ArgumentException("密码不能为空！"); }

			_UserName = username;
			_UserPass = "";
			_InitState = (QQLoginState)int.Parse(state);
			_CurrState = QQLoginState.Offline;

			_UserPassHash = userpasshash;
		}

		/// <summary>
		/// 初始化 QQ 帐号。
		/// </summary>
		/// <param name="username">包含 QQ 帐号名称的字符串。</param>
		/// <param name="userpass">包含 QQ 帐号密码的字符串。</param>
		/// <param name="state">包含 QQ 登录状态的枚举。</param>
		public QQAccount(string username, string userpass, QQLoginState state)
		{
			if (String.IsNullOrEmpty(username) == true) { throw new ArgumentException("用户名不能为空！"); }
			if (String.IsNullOrEmpty(userpass) == true) { throw new ArgumentException("密码不能为空！"); }

			_UserName = username;
			_UserPass = userpass;
			_InitState = state;
			_CurrState = QQLoginState.Offline;

			_UserPassHash = QQPasswordHash.GetHash(_UserPass);
		}

		#endregion

		#region 公有方法

		/// <summary>
		/// 登录帐号。
		/// </summary>
		public bool Login(string qqpath)
		{
			string f = String.Format("/START QQUIN:{0} PWDHASH:{1}== /STAT:{2}", _UserName, _UserPassHash, (int)_InitState);
			Process pro = new Process();
			pro.StartInfo.FileName = qqpath;
			pro.StartInfo.Arguments = f;
			return pro.Start();
		}

		#endregion

		#region 公有属性
		
		/// <summary>
		/// 设置或获取 QQ 帐号（数字型帐号或绑定的电子邮件均可）。
		/// </summary>
		public string UserName
		{
			get { return _UserName; }
			set { _UserName = value; }
		}

		/// <summary>
		/// 设置或获取 QQ 密码。
		/// </summary>
		public string UserPass
		{
			get { return _UserPass; }
			set { _UserPass = value; }
		}

		/// <summary>
		/// 获取 QQ 密码的 Hash 形式，用于登录。
		/// </summary>
		public string UserPassHash
		{
			get { return _UserPassHash; }
		}

		/// <summary>
		/// 设置或获取 QQ 的初始登录状态。
		/// </summary>
		public QQLoginState InitState
		{
			get { return _InitState; }
			set { _InitState = value; }
		}

		/// <summary>
		/// 设置或获取 QQ 的当前登录状态。
		/// </summary>
		public QQLoginState CurrState
		{
			get { return _CurrState; }
			set { _CurrState = value; }
		}

		#endregion
	}
}
