﻿/* 请提高版权意识，不要删除这些版权声明。
 * --------------------------------------------------------------------------------------
 * 产品名称：问沫聚合门户管理系统
 * 产品作者：Guidy
 * 版权所有：问沫工作室 [VMoom Studio]
 * --------------------------------------------------------------------------------------
 * 官方网站：http://www.vmoom.net/
 * 技术论坛：http://bbs.vmoom.net/
 * ------------------------------------------------------------------------------------*/

using System;
using System.Collections;
using System.Data;

namespace QQLoginManager.Framework
{
	/// <summary>
	/// 包含 QQ 帐号信息的集合。
	/// </summary>
	public class QQAccountCollection : InternalDataCollectionBase
	{
		#region 私有字段
		
		private ArrayList _QQAccounts;

		#endregion

		#region 构造函数

		/// <summary>
		/// 初始化 QQ 帐号信息集合。
		/// </summary>
		public QQAccountCollection()
		{

		}
		
		#endregion

		#region 公有方法

		/// <summary>
		/// 添加 QQ 帐号。
		/// </summary>
		/// <param name="username">包含 QQ 帐号名称的字符串。</param>
		/// <param name="userpass">包含 QQ 帐号密码的字符串。</param>
		/// <param name="state">包含 QQ 登录状态的枚举。</param>
		public void Add(string username, string userpass, QQLoginState state)
		{
			if (this[username] != null)
				throw new ArgumentException("帐号已经存在！");

			QQAccount qq = new QQAccount(username, userpass, state);
			this.List.Add(qq);
		}

		/// <summary>
		/// 删除 QQ 帐号。
		/// </summary>
		/// <param name="username">包含 QQ 帐号名称的字符串。</param>
		public void Remove(string username)
		{
			this.List.Remove(this[username]);
		}

		/// <summary>
		/// 添加 QQ 帐号。
		/// </summary>
		/// <param name="username">包含 QQ 帐号名称的字符串。</param>
		/// <param name="userpasshash">包含 QQ 帐号 Hash 形式密码的字符串。</param>
		/// <param name="state">包含 QQ 登录状态的字符串。</param>
		public void Add(string username, string userpasshash, string state)
		{
			if (this[username] != null)
				throw new ArgumentException("帐号已经存在！");

			QQAccount qq = new QQAccount(username, userpasshash, state);
			this.List.Add(qq);
		}

		#endregion

		#region 公有属性

		/// <summary>
		/// 获取位于指定索引位置的 QQLoginManager.Framework.QQAccount 对象
		/// </summary>
		/// <param name="index">要查找的 QQLoginManager.Framework.QQAccount 的从零开始的索引。</param>
		/// <returns>QQLoginManager.Framework.QQAccount</returns>
		public QQAccount this[int index]
		{
			get { return (QQAccount)this.List[index]; }
		}

		/// <summary>
		/// 获取指定名称的 QQLoginManager.Framework.QQAccount 对象。
		/// </summary>
		/// <param name="name">要查找的 QQLoginManager.Framework.QQAccount 的名称。</param>
		/// <returns>QQLoginManager.Framework.QQAccount</returns>
		public QQAccount this[string name]
		{
			get
			{
				QQAccount q = null;

				foreach (QQAccount qq in this.List)
				{
					if (qq.UserName.Equals(name, StringComparison.OrdinalIgnoreCase) == true)
					{
						q = qq;
						break;
					}
				}

				return q;
			}
		}

		/// <summary>
		/// 作为列表获取集合的项。
		/// </summary>
		protected override ArrayList List
		{
			get
			{
				if (_QQAccounts == null) { _QQAccounts = new ArrayList(); }
				return _QQAccounts;
			}
		}

		/// <summary>
		/// 获取当前 QQ 帐号信息集合所包含的 QQ 帐号的数量。
		/// </summary>
		public override int Count
		{
			get { return this.List.Count; }
		}

		#endregion
	}
}
