﻿/* 请提高版权意识，不要删除这些版权声明。
 * --------------------------------------------------------------------------------------
 * 产品名称：问沫聚合门户管理系统
 * 产品作者：Guidy
 * 版权所有：问沫工作室 [VMoom Studio]
 * --------------------------------------------------------------------------------------
 * 官方网站：http://www.vmoom.net/
 * 技术论坛：http://bbs.vmoom.net/
 * ------------------------------------------------------------------------------------*/

using System;
using System.Security.Cryptography;
using System.Text;

namespace QQLoginManager.Framework
{
	/// <summary>
	/// QQ 密码哈希计算。
	/// </summary>
	public sealed class QQPasswordHash
	{
		/// <summary>
		/// 获取 QQ 密码的哈希值。
		/// </summary>
		/// <param name="password">QQ密码。</param>
		/// <returns>string</returns>
		public static string GetHash(string password)
		{
			byte[] b = new MD5CryptoServiceProvider().ComputeHash(Encoding.Default.GetBytes(password));
			return Convert.ToBase64String(b);
		}
	}
}
