﻿/* 请提高版权意识，不要删除这些版权声明。
 * --------------------------------------------------------------------------------------
 * 产品名称：问沫聚合门户管理系统
 * 产品作者：Guidy
 * 版权所有：问沫工作室 [VMoom Studio]
 * --------------------------------------------------------------------------------------
 * 官方网站：http://www.vmoom.net/
 * 技术论坛：http://bbs.vmoom.net/
 * ------------------------------------------------------------------------------------*/

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading;
using System.Windows.Forms;
using IWshRuntimeLibrary;
using LiveUpdate;
using QQLoginManager.Configuration;
using QQLoginManager.Framework;
using VMoom.Framework;
using VMoom.Framework.Forms;
using VMoom.Framework.WindowsAPI;

namespace QQLoginManager
{
	public partial class MainForm : Form
	{
		#region 私有字段

		private List<QQAccount> _LoginList;
		private QQLoginProvider _QQLP;
		private ConfigProvider _Config;
		private bool _IsAccountInfoUpdate;
		private bool _CannelSelfClose;
		private System.Windows.Forms.Timer _Timer;
		private System.Threading.Timer _SelfCloseTimer;
		private int i = 0;
		private ImageList _ImageList;

		private string _Version;
		private string _StatusOldText;
		private const string AdsUrl = "http://www.vmoom.net/qqlm/ads/";
		private LiveUpdateProvider _LiveUpdateProvider;

		private Thread _AutoUpdateThread;

		#endregion

		#region 构造函数

		public MainForm()
		{
			InitializeComponent();

			_Version = Application.ProductVersion;
			_CannelSelfClose = false;

			_Config = new ConfigProvider();

			if (_Config.IsQQ2009) MessageBox.Show("本 QQ 登录助手暂时不支持 QQ2009，您可以通过选项对话框修改 QQ 安装路径。", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);

			_QQLP = QQLoginProvider.FromFile(_Config.DataFileName);

			if (_Config.AutoCheck == true) _AutoCheck_Init();

			_IsAccountInfoUpdate = false;
			_ImageList = new ImageList();
			_ImageList.ImageSize = new Size(1, 18);
			this.AccountList.SmallImageList = _ImageList;
			this.AccountList.DrawColumnHeader += new DrawListViewColumnHeaderEventHandler(AccountList_DrawColumnHeader);
			this.AccountList.DrawSubItem += new DrawListViewSubItemEventHandler(AccountList_DrawSubItem);
			new ListViewSortManager(this.AccountList, new Type[] { typeof(ListViewInt32Sort), typeof(ListViewTextCaseInsensitiveSort), typeof(ListViewTextCaseInsensitiveSort), typeof(ListViewTextCaseInsensitiveSort) }, 0, SortOrder.Ascending);

			// 自定义系统菜单
			int systemMenu = Win32API.GetSystemMenu(this.Handle.ToInt32(), 0);
			// 添加分割线
			Win32API.AppendMenu(systemMenu, 0xA00, 0, null);
			// 添加菜单项
			Win32API.AppendMenu(systemMenu, 0, 101, "检查更新(&U)...");
			Win32API.AppendMenu(systemMenu, 0, 100, "关于(&A)...");
		}

		protected override void WndProc(ref Message m)
		{
			base.WndProc(ref m);

			if (m.Msg == 0x112)
			{
				switch (m.WParam.ToInt32())
				{
					case 100:
						AboutForm f = new AboutForm();
						f.ShowDialog(this);
						break;
					case 101:
						_StartUpdate();
						break;
				}
			}
		}

		private void AccountList_DrawColumnHeader(object sender, DrawListViewColumnHeaderEventArgs e)
		{
			e.DrawDefault = true;
		}

		private void AccountList_DrawSubItem(object sender, DrawListViewSubItemEventArgs e)
		{
			e.DrawDefault = true;
		}

		#endregion

		#region 析构函数

		~MainForm()
		{
			Application.ExitThread();
			if (_Timer.Enabled == true) _Timer.Stop();
			_Config.Save();
		}

		#endregion

		#region 私有方法

		private void MainForm_Load(object sender, EventArgs e)
		{
			this.Text += String.Format(" - 当前版本：{0}", _Version);

			_AutoUpdateThread = new Thread(new ThreadStart(_InitAutoUpdate));
			_AutoUpdateThread.IsBackground = true;
			_AutoUpdateThread.Start();

			_InitList();
			_UpdateList();
		}

		private void _InitAutoUpdate()
		{
			_LiveUpdateProvider = new LiveUpdateProvider();

			Thread.Sleep(2000);

			_SetLabelValue(this.LiveUpdateLabel, _LiveUpdateProvider.HaveUpdate, "");
		}

		private void MainFormOptions_Click(object sender, EventArgs e)
		{
			ShowOptionsDialog();
		}

		private void CheckUpdate_Click(object sender, EventArgs e)
		{
			_StartUpdate();
		}

		private void MainFormHomePage_Click(object sender, EventArgs e)
		{
			Utils.OpenUrl("http://www.vmoom.net/", true);
		}

		private void MainFormBbs_Click(object sender, EventArgs e)
		{
			Utils.OpenUrl("http://bbs.htmlbird.com/", true);
		}

		private void MainFormAbout_Click(object sender, EventArgs e)
		{
			AboutForm f = new AboutForm();
			f.ShowDialog(this);
		}

		public delegate void SetLabelValueCallBack(ToolStripStatusLabel label, bool visible, string text);
		private void _SetLabelValue(ToolStripStatusLabel label, bool visible, string text)
		{
			if (this.InvokeRequired)
			{
				SetLabelValueCallBack d = new SetLabelValueCallBack(_SetLabelValue);
				this.Invoke(d, new object[] { label, visible, text });
			}
			else
			{
				label.Visible = visible;
				if (text != null && text.Length > 0) label.Text = text;
			}
		}

		public delegate void SetButtonEnabledCallBack(Button b, bool enabled, string text);
		private void _SetButtonEnabled(Button b, bool enabled, string text)
		{
			if (b.InvokeRequired)
			{
				SetButtonEnabledCallBack d = new SetButtonEnabledCallBack(_SetButtonEnabled);
				b.Invoke(d, new object[] { b, enabled, text });
			}
			else
			{
				if (b != null)
				{
					b.Enabled = enabled;
					if (text != null && text.Length > 0) b.Text = text;
				}
			}
		}

		private void _AutoCheck_Init()
		{
			_Timer = new System.Windows.Forms.Timer();
			_Timer.Interval = _Config.CheckTimeSpan;
			_Timer.Tick += new EventHandler(_Timer_Tick);
			_Timer.Start();
		}

		private void _Timer_Tick(object sender, EventArgs e)
		{
			i++;

			_UpdateList();
		}

		private void AddAccountButton_Click(object sender, EventArgs e)
		{
			try
			{
				if (Regex.IsMatch(this.UserNameTextBox.Text, @"\d+") == false)
				{
					MessageBox.Show("您输入的帐号格式不正确！\r\n本助手当前不支持以电子邮件的形式登录。", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
					return;
				}

				if (this.UserPassTextBox.Text == "")
				{
					MessageBox.Show("帐号密码不能为空！", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
					return;
				}

				if (_IsAccountInfoUpdate == true)
				{
					_QQLP.RemoveQQ(this.UserNameTextBox.Text);
					this.AddAccountButton.Text = "添加帐号";
				}

				_QQLP.AddQQ(this.UserNameTextBox.Text, this.UserPassTextBox.Text, this.UserStateCheckBox.Checked == true ? QQLoginState.Hidden : QQLoginState.Online);
				this.UserNameTextBox.Text = "";
				this.UserPassTextBox.Text = "";

				_QQLP.SaveToFile(_Config.DataFileName);
				_InitList();
			}
			catch (ArgumentException AE)
			{
				MessageBox.Show(AE.Message, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
			}
			finally
			{
				this.UserNameTextBox.Focus();
			}
		}

		private void LoginButton_Click(object sender, EventArgs e)
		{
			_QQLP.Refresh();
			this.LoginList.Clear();

			foreach (ListViewItem item in this.AccountList.CheckedItems)
			{
				if (item.SubItems[3].Text == "在线") continue;

				string qq = item.SubItems[1].Text;
				this.LoginList.Add(_QQLP.QQAccounts[qq]);
			}

			if (this.LoginList.Count == 0) return;

			this.DoLogin();
		}

		private void _DoLogin()
		{
			_SetButtonEnabled(this.LoginButton, false, "");

			if (_StartLogin() == true)
			{
				if (_Config.AutoClose == true)
					_DelayExit();
			}

			_SetButtonEnabled(this.LoginButton, true, "");
		}

		public void DoLogin()
		{
			Thread th = new Thread(new ThreadStart(_DoLogin));
			th.IsBackground = true;
			th.Start();
		}

		private int _DelayCount;
		private bool _DelayExiting;
		private void _DelayExit()
		{
			_DelayCount = 0;
			_DelayExiting = true;
			_CannelSelfClose = false;

			AutoResetEvent autoEvent = new AutoResetEvent(false);
			_SelfCloseTimer = new System.Threading.Timer(new TimerCallback(_SelfCloseTimer_Tick), autoEvent, 0, 1000);
			_SelfCloseTimer.Change(0, 1000);
		}

		private void _SelfCloseTimer_Tick(Object stateInfo)
		{
			_DelayCount++;
			AutoResetEvent autoEvent = (AutoResetEvent)stateInfo;

			this.StatusLabel.Text = String.Format("QQ 登录助手将在 {0} 秒后自动关闭，按 ESC 键即可取消。", 10 - _DelayCount);

			if (_CannelSelfClose)
			{
				autoEvent.WaitOne(1000, false);
				_SelfCloseTimer.Dispose();
				_DelayExiting = false;
				this.StatusLabel.Text = "就绪";
				this.LoginButton.Enabled = true;
			}
			else if (_DelayCount == 10)
			{
				autoEvent.Set();
				autoEvent.WaitOne(1000, false);
				_SelfCloseTimer.Dispose();
				Application.ExitThread();
				Application.Exit();
			}
		}

		private bool _StartLogin()
		{
			if (_Config.QQPath == null || _Config.QQPath.Length == 0 || System.IO.File.Exists(_Config.QQPath) == false)
			{
				ShowOptionsDialog(Options.Messages[0]);

				return false;
			}

			foreach (QQAccount qq in this.LoginList)
			{
				if (qq.CurrState == QQLoginState.Offline)
					qq.Login(_Config.QQPath);

				Thread.Sleep(2000);
			}

			bool b = false;

			while (!b && !_Config.IsQQ2009)
			{
				if (this.LoginList.Count == 0)
					b = true;
				else
					for (int i = 0; i < this.LoginList.Count; i++)
					{
						this._QQLP.Refresh();

						QQAccount qq = this.LoginList[i];

						if ((qq.CurrState == QQLoginState.Hidden) ||
							(qq.CurrState == QQLoginState.Online))
							if (this.LoginList.Contains(qq))
								this.LoginList.Remove(qq);
					}
			}

			_UpdateList();

			return true;
		}

		/// <summary>
		/// 设置或获取待登录的 QQ 号码列表
		/// </summary>
		public List<QQAccount> LoginList
		{
			get
			{
				if (_LoginList == null)
					_LoginList = new List<QQAccount>();

				return _LoginList;
			}
		}

		public delegate void UpdateListCallBack();
		private void _UpdateList()
		{
			if (this.AccountList.InvokeRequired)
			{
				UpdateListCallBack d = new UpdateListCallBack(_UpdateList);
				this.AccountList.Invoke(d);
			}
			else
			{

				_QQLP.Refresh();

				foreach (QQAccount qq in _QQLP.QQAccounts)
				{
					ListViewItem[] lvis = this.AccountList.Items.Find(qq.UserName, true);

					foreach (ListViewItem lvi in lvis)
					{
						ListViewItem.ListViewSubItem sv = lvi.SubItems[3];

						sv.Text = qq.CurrState == QQLoginState.Online ? "在线" : "离线";

						if (sv.Text == "在线")
							sv.ForeColor = Color.Red;
						else
							sv.ForeColor = Color.Blue;

						this.AccountList.RedrawItems(lvi.Index, lvi.Index, false);
					}
				}

				this.AccountList.Update();
			}
		}

		private void _InitList()
		{
			_QQLP.Refresh();
			this.AccountList.Items.Clear();
			int i = 0;
			foreach (QQAccount qq in _QQLP.QQAccounts)
			{
				i++;

				ListViewItem lvi = new ListViewItem(i.ToString());
				lvi.Name = qq.UserName;

				lvi.SubItems.Add(qq.UserName);
				lvi.SubItems.Add(_FormatState(qq.InitState));
				lvi.SubItems.Add(_FormatState(qq.CurrState));

				if (_Config.AutoSelectAll) lvi.Checked = true;

				this.AccountList.Items.Add(lvi);
			}
		}

		private string _FormatState(QQLoginState state)
		{
			string s = "";

			switch (state)
			{
				case QQLoginState.Hidden:
					s = "隐身";
					break;
				case QQLoginState.Offline:
					s = "离线";
					break;
				case QQLoginState.Online:
					s = "在线";
					break;
			}

			return s;
		}

		private QQLoginState _GetStateFromString(string state)
		{
			QQLoginState s = QQLoginState.Hidden;

			switch (state)
			{
				case "隐身":
					s = QQLoginState.Hidden;
					break;
				case "离线":
					s = QQLoginState.Offline;
					break;
				case "在线":
					s = QQLoginState.Online;
					break;
			}

			return s;
		}

		private void toolStripMenuItem2_Click(object sender, EventArgs e)
		{
			foreach (ListViewItem lvi in this.AccountList.SelectedItems)
			{
				// 删除确认
				string username = lvi.SubItems[1].Text;
				string f = String.Format("确定要删除帐号 [{0}] 的配置信息吗？\r\n本操作是无法撤销的，删除之后必须手工重新添加。", username);
				if (MessageBox.Show(f, this.Text, MessageBoxButtons.YesNoCancel, MessageBoxIcon.Question) == DialogResult.Yes)
					_QQLP.RemoveQQ(username);
			}

			_QQLP.SaveToFile(_Config.DataFileName);
			_InitList();
		}

		private void UserPassTextBox_Enter(object sender, EventArgs e)
		{
			this.UserPassTextBox.SelectAll();
		}

		private void AccountListContextMenuStrip_Opening(object sender, CancelEventArgs e)
		{
			foreach (ToolStripItem item in this.AccountListContextMenuStrip.Items) item.Enabled = false;

			switch (this.AccountList.SelectedItems.Count)
			{
				case 0:
					e.Cancel = true;
					break;
				case 1:
					this.AccountInfoUpdate.Enabled = true;
					goto default;
				default:
					this.AccountInfoLoginThese.Enabled = true;
					this.AccountInfoCreateShortcut.Enabled = true;
					this.AccountInfoCopy.Enabled = true;
					this.AccountInfoDelete.Enabled = true;
					break;
			}
		}

		private void AccountInfoLoginThese_Click(object sender, EventArgs e)
		{
			_LoginThese();
		}

		private void AccountList_MouseDoubleClick(object sender, MouseEventArgs e)
		{
			_LoginThese();
		}

		private void _LoginThese()
		{
			this.LoginList.Clear();

			foreach (ListViewItem l in this.AccountList.SelectedItems)
			{
				if (l.SubItems[3].Text == "离线")
				{
					string qq = l.SubItems[1].Text;
					this.LoginList.Add(_QQLP.QQAccounts[qq]);
					this.DoLogin();
				}

				break;
			}
		}

		private void AccountInfoCopy_Click(object sender, EventArgs e)
		{
			StringBuilder s = new StringBuilder();

			s.Append("编号  帐号          初始状态  当前状态\r\n");
			foreach (ListViewItem l in this.AccountList.SelectedItems)
			{
				s.Append(String.Format("{0}  {1}  {2}  {3}\r\n", l.Text.PadRight(4, ' '), l.SubItems[1].Text.PadRight(12, ' '), l.SubItems[2].Text.PadRight(6, ' '), l.SubItems[3].Text));
			}

			Clipboard.SetData(DataFormats.Text, s.ToString());

			MessageBox.Show("以下信息已经被复制到剪切板：\r\n\r\n" + s.ToString(), "复制成功！ - QQ登录助手", MessageBoxButtons.OK, MessageBoxIcon.Information);
		}

		private void AccountInfoUpdate_Click(object sender, EventArgs e)
		{
			_AccountInfoUpdate();
		}

		private void ShortcutToCurrUser_Click(object sender, EventArgs e)
		{
			string folder = Environment.GetFolderPath(Environment.SpecialFolder.DesktopDirectory).TrimEnd('\\') + "\\";

			_CreateShortcut(folder);
		}

		private void ShortcutToAllUser_Click(object sender, EventArgs e)
		{
			object allUsersDesktop = "AllUsersDesktop";
			WshShell shell = new WshShell();
			string folder = shell.SpecialFolders.Item(ref allUsersDesktop) as string;
			if (folder == null || folder.Length == 0) return;
			folder = folder.TrimEnd('\\') + "\\";

			_CreateShortcut(folder);
		}

		private void ShortcutToQuickLaunch_Click(object sender, EventArgs e)
		{
			string folder = Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData).TrimEnd('\\') + "\\Microsoft\\Internet Explorer\\Quick Launch\\";

			_CreateShortcut(folder);
		}

		private void ShortcutToRunMenu_Click(object sender, EventArgs e)
		{
			string folder = Environment.GetFolderPath(Environment.SpecialFolder.Startup).TrimEnd('\\') + "\\";

			_CreateShortcut(folder);
		}

		private void _CreateShortcut(string folder)
		{
			foreach (ListViewItem l in this.AccountList.SelectedItems)
			{
				QQAccount qq = _QQLP.QQAccounts[l.SubItems[1].Text];

				string filename = String.Format("{0}QQ {1}.lnk", folder, qq.UserName);
				string args = String.Format("/START QQUIN:{0} PWDHASH:{1}== /STAT:{2}", qq.UserName, qq.UserPassHash, (int)qq.InitState);
				string des = String.Format("QQ 登录助手为 {0} 创建的快捷登录图标", qq.UserName);

				_CreateShortcut(filename, args, des);
			}
		}

		private void _CreateShortcut(string filename, string args, string des)
		{
			WshShell shell = new WshShell();
			IWshShortcut shortcut = (IWshShortcut)shell.CreateShortcut(filename);
			shortcut.TargetPath = _Config.QQPath;
			shortcut.WorkingDirectory = Regex.Replace(_Config.QQPath, @"\\[^\\]+?$", @"\", RegexOptions.IgnoreCase | RegexOptions.Singleline);
			shortcut.Arguments = args;
			shortcut.WindowStyle = 1;
			shortcut.Description = des;
			shortcut.IconLocation = _Config.QQPath + ", 0";
			shortcut.Save();
		}

		private void _AccountInfoUpdate()
		{
			if (this.AccountList.SelectedItems.Count != 1)
			{
				_IsAccountInfoUpdate = false;
				return;
			}
			else
			{
				ListViewItem l = this.AccountList.SelectedItems[0];
				this.AddAccountButton.Text = "更新信息";
				this.UserNameTextBox.Text = l.SubItems[1].Text;
				this.UserStateCheckBox.Checked = _GetStateFromString(l.SubItems[2].Text) == QQLoginState.Hidden;
				_IsAccountInfoUpdate = true;
			}
		}

		private void RefreshLabel_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
		{
			_UpdateList();
		}

		private void SelectAllLabel_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
		{
			foreach (ListViewItem item in this.AccountList.Items)
				item.Checked = true;
		}

		private void SelectOtherLabel_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
		{
			foreach (ListViewItem item in this.AccountList.Items)
				item.Checked = !item.Checked;
		}

		private void OptionsLabel_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
		{
			ShowOptionsDialog();
		}

		private void ShowOptionsDialog()
		{
			Options options = new Options(_Config);

			options.ShowDialog(this);
		}

		private void ShowOptionsDialog(string tipstext)
		{
			Options options = new Options(_Config, tipstext);

			options.ShowDialog(this);
		}

		private void MainFormExit_Click(object sender, EventArgs e)
		{
			Application.Exit();
		}

		private void _CreateDesktopIcon(string filename)
		{
			if (!System.IO.File.Exists(filename))
			{
				WshShell shell = new WshShell();
				IWshShortcut shortcut = (IWshShortcut)shell.CreateShortcut(filename);
				shortcut.TargetPath = Application.ExecutablePath;
				shortcut.WorkingDirectory = Application.StartupPath;
				shortcut.WindowStyle = 1;
				shortcut.Description = "QQ登录助手";
				shortcut.IconLocation = Application.ExecutablePath + ", 0";
				shortcut.Save();
			}
		}

		private void IconToCurrUser_Click(object sender, EventArgs e)
		{
			string icon = Environment.GetFolderPath(Environment.SpecialFolder.DesktopDirectory).TrimEnd('\\') + "\\QQ登录助手.lnk";

			_CreateDesktopIcon(icon);
		}

		private void IconToAllUser_Click(object sender, EventArgs e)
		{
			object allUsersDesktop = "AllUsersDesktop";
			WshShell shell = new WshShell();
			string folder = shell.SpecialFolders.Item(ref allUsersDesktop) as string;
			if (folder == null || folder.Length == 0) return;

			string icon = folder.TrimEnd('\\') + "\\QQ登录助手.lnk";

			_CreateDesktopIcon(icon);
		}

		private void IconToQuickLaunch_Click(object sender, EventArgs e)
		{
			string icon = Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData).TrimEnd('\\') + "\\Microsoft\\Internet Explorer\\Quick Launch\\QQ登录助手.lnk";

			_CreateDesktopIcon(icon);
		}

		private void IconToStartMenu_Click(object sender, EventArgs e)
		{
			string icon = Environment.GetFolderPath(Environment.SpecialFolder.Programs).TrimEnd('\\') + "\\QQ登录助手.lnk";

			_CreateDesktopIcon(icon);
		}

		private void MainForm_KeyUp(object sender, KeyEventArgs e)
		{
			if ((e.KeyData == Keys.Escape) && _DelayExiting)
			{
				_CannelSelfClose = true;
				this.StatusLabel.Text = "用户取消了 QQ 登录助手的退出";
			}
		}

		private void LiveUpdateLabel_Click(object sender, EventArgs e)
		{
			_StartUpdate();
		}

		private void _StartUpdate()
		{
			Process pro = new Process();
			pro.StartInfo.FileName = ".\\LiveUpdate.exe";
			pro.Start();
		}

		#endregion

		#region 提示信息

		private void UserNameTextBox_MouseEnter(object sender, EventArgs e)
		{
			_StatusOldText = this.StatusLabel.Text;
			this.StatusLabel.Text = "QQ 帐号";
		}

		private void UserNameTextBox_MouseLeave(object sender, EventArgs e)
		{
			this.StatusLabel.Text = _StatusOldText;
		}

		private void UserPassTextBox_MouseEnter(object sender, EventArgs e)
		{
			_StatusOldText = this.StatusLabel.Text;
			this.StatusLabel.Text = "QQ 密码";
		}

		private void UserPassTextBox_MouseLeave(object sender, EventArgs e)
		{
			this.StatusLabel.Text = _StatusOldText;
		}

		private void UserStateCheckBox_MouseEnter(object sender, EventArgs e)
		{
			_StatusOldText = this.StatusLabel.Text;
			this.StatusLabel.Text = "是否以隐身形式登录 QQ";
		}

		private void UserStateCheckBox_MouseLeave(object sender, EventArgs e)
		{
			this.StatusLabel.Text = _StatusOldText;
		}

		private void AddAccountButton_MouseEnter(object sender, EventArgs e)
		{
			_StatusOldText = this.StatusLabel.Text;
			this.StatusLabel.Text = "添加或更新 QQ 帐号";
		}

		private void AddAccountButton_MouseLeave(object sender, EventArgs e)
		{
			this.StatusLabel.Text = _StatusOldText;
		}

		private void LoginButton_MouseEnter(object sender, EventArgs e)
		{
			_StatusOldText = this.StatusLabel.Text;
			this.StatusLabel.Text = "登录选中的 QQ 帐号";
		}

		private void LoginButton_MouseLeave(object sender, EventArgs e)
		{
			this.StatusLabel.Text = _StatusOldText;
		}

		private void OptionsLabel_MouseEnter(object sender, EventArgs e)
		{
			_StatusOldText = this.StatusLabel.Text;
			this.StatusLabel.Text = "点击可以查看或修改 QQ 登录助手的配置信息";
		}

		private void OptionsLabel_MouseLeave(object sender, EventArgs e)
		{
			this.StatusLabel.Text = _StatusOldText;
		}

		private void RefreshLabel_MouseEnter(object sender, EventArgs e)
		{
			_StatusOldText = this.StatusLabel.Text;
			this.StatusLabel.Text = "刷新 QQ 登录状态（仅表示对应的 QQ 是否已经打开）";
		}

		private void RefreshLabel_MouseLeave(object sender, EventArgs e)
		{
			this.StatusLabel.Text = _StatusOldText;
		}

		private void SelectAllLabel_MouseEnter(object sender, EventArgs e)
		{
			_StatusOldText = this.StatusLabel.Text;
			this.StatusLabel.Text = "全选 QQ 帐号";
		}

		private void SelectAllLabel_MouseLeave(object sender, EventArgs e)
		{
			this.StatusLabel.Text = _StatusOldText;
		}

		private void SelectOtherLabel_MouseEnter(object sender, EventArgs e)
		{
			_StatusOldText = this.StatusLabel.Text;
			this.StatusLabel.Text = "反选 QQ 帐号";
		}

		private void SelectOtherLabel_MouseLeave(object sender, EventArgs e)
		{
			this.StatusLabel.Text = _StatusOldText;
		}

		private void AccountList_MouseEnter(object sender, EventArgs e)
		{
			_StatusOldText = this.StatusLabel.Text;
			this.StatusLabel.Text = "双击即可登录选定的 QQ 号码。";
		}

		private void AccountList_MouseLeave(object sender, EventArgs e)
		{
			this.StatusLabel.Text = _StatusOldText;
		}

		private void toolStripStatusLabel1_MouseEnter(object sender, EventArgs e)
		{
			_StatusOldText = this.StatusLabel.Text;
			this.StatusLabel.Text = "检测到新版本，点击此处立即升级！";
		}

		private void toolStripStatusLabel1_MouseLeave(object sender, EventArgs e)
		{
			this.StatusLabel.Text = _StatusOldText;
		}

		#endregion

		#region 友情链接

		private void LinkLabel01_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
		{
			Utils.OpenUrl("http://www.sa-ye.cn/", true);
		}

		private void LinkLabel02_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
		{
			Utils.OpenUrl("http://www.114xp.net/", true);
		}

		private void linkLabel03_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
		{
			Utils.OpenUrl("http://www.xlfw.cn/", true);
		}

		#endregion
	}
}
