﻿/* 请提高版权意识，不要删除这些版权声明。
 * --------------------------------------------------------------------------------------
 * 产品名称：问沫聚合门户管理系统
 * 产品作者：Guidy
 * 版权所有：问沫工作室 [VMoom Studio]
 * --------------------------------------------------------------------------------------
 * 官方网站：http://www.vmoom.net/
 * 技术论坛：http://bbs.vmoom.net/
 * ------------------------------------------------------------------------------------*/

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Windows.Forms;
using QQLoginManager.Configuration;

namespace QQLoginManager
{
	public partial class Options : Form
	{
		private ConfigProvider _Config;
		private string _TipsText;
		private int _ResizeType;

		/// <summary>
		/// 包含窗口提示文字的预定义消息。
		/// </summary>
		public static List<string> Messages;


		static Options()
		{
			Messages = new List<string>();

			Options.Messages.Add("在继续操作之前，您必须设置有效的 QQ 安装路径！");
			Options.Messages.Add("您设置的 QQ 程序路径不正确，请确定它是有效的可执行文件（以 .exe 结尾）。");
			Options.Messages.Add("本软件暂时不支持 QQ2009，请重新设置有效的 QQ 安装路径。");
		}

		public Options()
		{
			InitializeComponent();
		}

		public Options(ConfigProvider config)
		{
			if (config == null) throw new ArgumentNullException("config");

			_Config = config;
			_ResizeType = 1;

			InitializeComponent();
		}

		public Options(ConfigProvider config, string tipstext)
		{
			if (config == null) throw new ArgumentNullException("config");
			if (config == null) throw new ArgumentNullException("tipstext");

			_Config = config;
			_TipsText = tipstext;
			_ResizeType = 2;

			InitializeComponent();
		}

		private void Options_Load(object sender, EventArgs e)
		{
			this.OptionsPropertyGrid.SelectedObject = _Config;
			UpdateTips();
		}

		private void UpdateTips()
		{
			if (_TipsText == null || _TipsText.Length == 0)
			{
				this.TipsLabel.Visible = false;
				this.TipsLabel.Enabled = false;
				this.OptionsPropertyGrid.Top = 12;
				this.OptionsPropertyGrid.Height += 16;
			}
			else
			{
				this.TipsLabel.Text = _TipsText;
				this.TipsLabel.Enabled = true;
				this.TipsLabel.Visible = true;
				this.OptionsPropertyGrid.Top = 28;
				if (_ResizeType == 3)
				{
					this.OptionsPropertyGrid.Height -= 16;
					_ResizeType = 4;
				}
			}

			this.OptionsPropertyGrid.Select();
		}

		private void Options_FormClosing(object sender, FormClosingEventArgs e)
		{
			if (_Config.QQPath == null) _Config.QQPath = "";
			bool b = !_Config.QQPath.EndsWith(".exe", StringComparison.OrdinalIgnoreCase);

			if (!System.IO.File.Exists(_Config.QQPath) || b)
			{
				e.Cancel = true;

				if (b)
					_TipsText = Options.Messages[0];
				else
					_TipsText = Options.Messages[1];

				MessageBox.Show(_TipsText, "QQ 登录助手", MessageBoxButtons.OK, MessageBoxIcon.Information);

				if (_ResizeType == 1) _ResizeType = 3;

				UpdateTips();
			}
			else
			{
				if (_Config.IsQQ2009)
				{
					e.Cancel = true;

					_TipsText = Options.Messages[2];

					MessageBox.Show(_TipsText, "QQ 登录助手", MessageBoxButtons.OK, MessageBoxIcon.Information);

					if (_ResizeType == 1) _ResizeType = 3;

					UpdateTips();
				}
				else
				{
					_Config.Save();
					e.Cancel = false;
				}
			}
		}

		private void OptionsPropertyGridContextMenuStrip_Opening(object sender, CancelEventArgs e)
		{
			this.OptionsPropertyDescription.Checked = this.OptionsPropertyGrid.HelpVisible;
			if (this.OptionsPropertyGrid.SelectedGridItem.GridItemType == GridItemType.Property)
				this.OptionsPropertyReset.Enabled = this.OptionsPropertyGrid.SelectedGridItem.PropertyDescriptor.CanResetValue(this.OptionsPropertyGrid.SelectedObject);
		}

		private void OptionsPropertyDescription_Click(object sender, EventArgs e)
		{
			this.OptionsPropertyGrid.HelpVisible = !this.OptionsPropertyDescription.Checked;
		}

		private void OptionsPropertyReset_Click(object sender, EventArgs e)
		{
			this.OptionsPropertyGrid.SelectedGridItem.PropertyDescriptor.ResetValue(this.OptionsPropertyGrid.SelectedObject);
			this.OptionsPropertyGrid.Refresh();

			_Config.Save();
		}

		private void OptionsPropertyGrid_PropertyValueChanged(object s, PropertyValueChangedEventArgs e)
		{
			_Config.Save();
		}

		private void ExitButton_Click(object sender, EventArgs e)
		{
			this.Close();
		}
	}
}
