﻿/* 请提高版权意识，不要删除这些版权声明。
 * --------------------------------------------------------------------------------------
 * 产品名称：问沫聚合门户管理系统
 * 产品作者：Guidy
 * 版权所有：问沫工作室 [VMoom Studio]
 * --------------------------------------------------------------------------------------
 * 官方网站：http://www.vmoom.net/
 * 技术论坛：http://bbs.vmoom.net/
 * ------------------------------------------------------------------------------------*/

using System;
using System.Diagnostics;
using System.Reflection;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace QQLoginManager
{
	static class Program
	{
		/// <summary>
		/// 应用程序的主入口点。
		/// </summary>
		[STAThread]
		static void Main(string[] args)
		{
			string MyFullName = Assembly.GetExecutingAssembly().Location.Replace("/", "\\");

			// 同时只能有一个进程运行
			Process instance = RunningInstance(MyFullName);

			if (instance == null)
			{
				ToolStripManager.VisualStylesEnabled = false;
				Application.EnableVisualStyles();
				Application.SetCompatibleTextRenderingDefault(false);
				Application.Run(new MainForm());
			}
			else
				HandleRunningInstance(instance);
		}

		/// <summary>
		/// 与ShowWindow相似，只是这时的ShowWindow命令会投递到指定的窗口，然后进行异步处理。
		/// 这样一来，就可控制从属于另一个进程的窗口的可视情况。
		/// 同时无须担心另一个进程挂起的时候，自己的应用程序也会牵连其中
		/// </summary>
		/// <param name="hWnd">窗体handle</param>
		/// <param name="cmdShow">要设置的窗体状态</param>
		/// <returns>如窗口之前是可见的，则返回TRUE，否则返回FALSE</returns>
		[DllImport("User32.dll", EntryPoint = "ShowWindowAsync")]
		public static extern bool ShowWindowAsync(IntPtr hWnd, int nCmdShow);

		/// <summary>
		/// 将窗口设为系统的前台窗口。这个函数可用于改变用户目前正在操作的应用程序
		/// </summary>
		/// <param name="hWnd">窗体handle</param>
		/// <returns>bool</returns>
		[DllImport("User32.dll", EntryPoint = "SetForegroundWindow")]
		public static extern bool SetForegroundWindow(IntPtr hWnd);

		/// <summary>
		/// 设定指定Process为当前进程
		/// </summary>
		/// <param name="instance">已经存在的Process</param>
		public static void HandleRunningInstance(Process instance)
		{
			ShowWindowAsync(instance.MainWindowHandle, (int)nCmdShow.SW_SHOWNORMAL);
			SetForegroundWindow(instance.MainWindowHandle);
		}

		/// <summary>
		/// 获取当前已经运行的实例
		/// </summary>
		/// <param name="FileName">需要验证的程序集的加载的文件路径</param>
		/// <returns>先前已经存在的实例</returns>
		public static Process RunningInstance(string filename)
		{
			Process current = Process.GetCurrentProcess();
			Process[] processes = Process.GetProcessesByName(current.ProcessName);

			foreach (Process process in processes)
			{
				if (process.Id != current.Id)
				{
					if (filename == current.MainModule.FileName)
						return process;
				}
			}

			return null;
		}

		/// <summary>
		/// 获取系统中已经存在的包含指定文件名的进程
		/// </summary>
		/// <param name="FileName">需要验证的文件名称，可包含路径</param>
		/// <returns>可能从该文件加载的进程实例</returns>
		public static Process GetInstance(string FileName)
		{
			Process[] processes = Process.GetProcesses();

			foreach (Process process in processes)
			{
				string f = "";

				try
				{
					f = process.MainModule.FileName;
				}
				catch
				{
					f = "失败：" + process.ProcessName;
				}

				if (f.ToLower().EndsWith(FileName.ToLower()) == true)
					return process;
			}

			return null;
		}

		/// <summary>
		/// 要设置的窗体状态
		/// </summary>
		public enum nCmdShow
		{
			/// <summary>
			/// 隐藏窗口，活动状态给令一个窗口
			/// </summary>
			SW_HIDE = 0,

			/// <summary>
			/// 最小化窗口，活动状态给令一个窗口
			/// </summary>
			SW_MINIMIZE = 6,

			/// <summary>
			/// 用原来的大小和位置显示一个窗口，同时令其进入活动状态
			/// </summary>
			SW_RESTORE = 9,

			/// <summary>
			/// 用当前的大小和位置显示一个窗口，同时令其进入活动状态
			/// </summary>
			SW_SHOW = 1,

			/// <summary>
			/// 最大化窗口，并将其激活
			/// </summary>
			SW_SHOWMAXIMIZED = 3,

			/// <summary>
			/// 最小化窗口，并将其激活
			/// </summary>
			SW_SHOWMINIMIZED = 6,

			/// <summary>
			/// 最小化一个窗口，同时不改变活动窗口
			/// </summary>
			SW_SHOWMINNOACTIVE = 7,

			/// <summary>
			/// 用当前的大小和位置显示一个窗口，不改变活动窗口
			/// </summary>
			SW_SHOWNA = 8,

			/// <summary>
			/// 用最近的大小和位置显示一个窗口，同时不改变活动窗口
			/// </summary>
			SW_SHOWNOACTIVATE = 4,

			/// <summary>
			/// 与SW_RESTORE相同
			/// </summary>
			SW_SHOWNORMAL = 1
		}
	}
}
