﻿/* 请提高版权意识，不要删除这些版权声明。
 * --------------------------------------------------------------------------------------
 * 产品名称：问沫聚合门户管理系统
 * 产品作者：Guidy
 * 版权所有：问沫工作室 [VMoom Studio]
 * --------------------------------------------------------------------------------------
 * 官方网站：http://www.vmoom.net/
 * 技术论坛：http://bbs.vmoom.net/
 * ------------------------------------------------------------------------------------*/

using System;
using System.Data;
using System.Diagnostics;
using System.IO;
using System.Text;
using System.Windows.Forms;
using System.Xml;

namespace UpdateServiceTools
{
	public partial class ServiceTools : Form
	{
		public readonly string UpdateFilesDirectory = "./UpdateFiles/";
		public readonly string DeletedFilesDirectory = "./DeleteFiles/";
		public readonly string ExecuteFilesDirectory = "./ExecuteFiles/";
		public readonly string ChangelogFilePath = "./Changelog.txt";

		private DataTable _FileList = new DataTable();

		public ServiceTools()
		{
			InitializeComponent();

			if (!Directory.Exists(this.UpdateFilesDirectory)) Directory.CreateDirectory(this.UpdateFilesDirectory);
			if (!Directory.Exists(this.DeletedFilesDirectory)) Directory.CreateDirectory(this.DeletedFilesDirectory);
			if (!Directory.Exists(this.ExecuteFilesDirectory)) Directory.CreateDirectory(this.ExecuteFilesDirectory);
			if (!File.Exists(this.ChangelogFilePath)) File.WriteAllText(this.ChangelogFilePath, "", Encoding.UTF8);

			_FileList.Columns.Add("FileSN", typeof(string));
			_FileList.Columns.Add("FileName", typeof(string));
			_FileList.Columns.Add("FileSize", typeof(string));
			_FileList.Columns.Add("FileVersion", typeof(string));
			_FileList.Columns.Add("FileUpdateTime", typeof(string));
			_FileList.Columns.Add("UpdateMethod", typeof(string));
		}

		private void ServiceTools_Load(object sender, EventArgs e)
		{
			_ReadFileList();
		}

		private void _ReadFileList()
		{
			int i = 0;
			DirectoryInfo di = new DirectoryInfo(this.UpdateFilesDirectory);
			
			// 常规更新
			foreach(FileInfo f in di.GetFiles())
			{
				i++;
				_FileList.Rows.Add(new object[] { i, f.Name, f.Length, this.GetFileVersion(f.FullName), f.LastWriteTime.ToString("yyyy-MM-dd HH:mm:ss"), "更新" });
			}

			// 需要删除的文件
			di = new DirectoryInfo(this.DeletedFilesDirectory);
			foreach (FileInfo f in di.GetFiles())
			{
				i++;
				_FileList.Rows.Add(new object[] { i, f.Name, f.Length, this.GetFileVersion(f.FullName), f.LastWriteTime.ToString("yyyy-MM-dd HH:mm:ss"), "删除" });
			}

			// 需要执行的文件
			di = new DirectoryInfo(this.ExecuteFilesDirectory);
			foreach (FileInfo f in di.GetFiles())
			{
				i++;
				_FileList.Rows.Add(new object[] { i, f.Name, f.Length, this.GetFileVersion(f.FullName), f.LastWriteTime.ToString("yyyy-MM-dd HH:mm:ss"), "执行" });
			}

			i = 0;
			foreach (DataRow dr in _FileList.Select("FileSize > 0", "FileName"))
			{
				i++;
				this.UpdateFilesDataGrid.Rows.Add(new object[] { i, dr[1], dr[2], dr[3], dr[4], dr[5] });
			}
		}

		/// <summary>
		/// 获取指定文件的文件版本号，仅读取FileVersion
		/// </summary>
		/// <param name="FileName">要获取文件版本号的文件地址</param>
		/// <returns>如果存在则返回完整的文件版本号，否则将返回错误信息</returns>
		public string GetFileVersion(string FileName)
		{
			try
			{
				FileVersionInfo fi = FileVersionInfo.GetVersionInfo(FileName);
				string ver = String.IsNullOrEmpty(fi.FileVersion) ? "0" : fi.FileVersion;
				return ver.Trim();
			}
			catch
			{
				return "0";
			}
		}

		private void OverviewSource_Click(object sender, EventArgs e)
		{
			this.ToolsTab.SelectedIndex = 1;
		}

		private void ToolsTab_SelectedIndexChanged(object sender, EventArgs e)
		{
			if (this.ToolsTab.SelectedIndex == 1)
				_ViewSource();
		}

		private void SaveSource_Click(object sender, EventArgs e)
		{
			SaveFileDialog s = new SaveFileDialog();
			s.AddExtension = true;
			s.DefaultExt = ".xml";
			s.Filter = "Xml文档(*.xml)|*.xml";
			s.InitialDirectory = ".\\";
			s.FileName = "Update.xml";
			s.Title = "请选择更新文件配置文档要保存的位置";

			if (s.ShowDialog(this) == DialogResult.OK)
			{
				this.SourceDocument.Save(s.FileName);
			}
		}

		private void _ViewSource()
		{
			string temp = ".\\temp.xml";
			this.SourceDocument.Save(temp);

			this.SourceBrowser.Url = new Uri(new FileInfo(temp).FullName);
		}

		private XmlDocument SourceDocument
		{
			get
			{
				XmlDocument doc = new XmlDocument();

				doc.AppendChild(doc.CreateXmlDeclaration("1.0", "UTF-8", null));

				XmlElement root = doc.CreateElement("QQLoginManager");
				XmlElement list = doc.CreateElement("UpdateFileList");

				foreach (DataGridViewRow r in this.UpdateFilesDataGrid.Rows)
				{
					if (r.IsNewRow) continue;

					XmlElement file = doc.CreateElement("File");

					file.InnerText = r.Cells["FileName"].Value.ToString();
					file.SetAttribute("FileSize", r.Cells["FileSize"].Value.ToString());
					file.SetAttribute("FileVersion", r.Cells["FileVersion"].Value.ToString());
					file.SetAttribute("FileUpdateTime", r.Cells["FileUpdateTime"].Value.ToString());
					file.SetAttribute("UpdateMethod", r.Cells["UpdateMethod"].Value.ToString());

					list.AppendChild(file);
				}

				root.AppendChild(list);

				// 更新简介
				string data = File.ReadAllText(this.ChangelogFilePath);
				XmlElement cdata = doc.CreateElement("UpdateInfo");
				cdata.AppendChild(doc.CreateCDataSection(data));

				root.AppendChild(cdata);
				doc.AppendChild(root);

				return doc;
			}
		}
	}
}
