﻿/* 请提高版权意识，不要删除这些版权声明。
 * --------------------------------------------------------------------------------------
 * 产品名称：问沫聚合门户管理系统
 * 产品作者：Guidy
 * 版权所有：问沫工作室 [VMoom Studio]
 * --------------------------------------------------------------------------------------
 * 官方网站：http://www.vmoom.net/
 * 技术论坛：http://bbs.vmoom.net/
 * ------------------------------------------------------------------------------------*/


namespace VMoom.Framework.WindowsAPI
{
	public enum AnimateFlags
	{
		/// <summary>
		/// 使用滑动类型。缺省则为滚动动画类型。当使用AW_CENTER标志时，这个标志就被忽略。
		/// </summary>
		AW_SLIDE = 0x00040000,
		
		/// <summary>
		/// 激活窗口。在使用了AW_HIDE标志后不要使用这个标志。
		/// </summary>
		AW_ACTIVE = 0x00020000,
		
		/// <summary>
		/// 使用淡出效果。只有当hWnd为顶层窗口的时候才可以使用此标志。
		/// </summary>
		AW_BLEND = 0x00080000,
		
		/// <summary>
		/// 隐藏窗口，缺省则显示窗口。
		/// </summary>
		AW_HIDE = 0x00010000,
		
		/// <summary>
		/// 若使用了AW_HIDE标志，则使窗口向内重叠；若未使用AW_HIDE标志，则使窗口向外扩展。
		/// </summary>
		AW_CENTER = 0x00000010,
		
		/// <summary>
		/// 自左向右显示窗口。该标志可以在滚动动画和滑动动画中使用。当使用AW_CENTER标志时，该标志将被忽略。
		/// </summary>
		AW_HOR_POSITIVE = 0x00000001,
		
		/// <summary>
		/// 自顶向下显示窗口。该标志可以在滚动动画和滑动动画中使用。当使用AW_CENTER标志时，该标志将被忽略。
		/// </summary>
		AW_VER_POSITIVE = 0x00000004,
		
		/// <summary>
		/// 自下向上显示窗口。该标志可以在滚动动画和滑动动画中使用。当使用AW_CENTER标志时，该标志将被忽略。
		/// </summary>
		AW_VER_NEGATIVE = 0x00000008,
		
		/// <summary>
		/// 自右向左显示窗口。该标志可以在滚动动画和滑动动画中使用。当使用AW_CENTER标志时，该标志将被忽略。
		/// </summary>
		AW_HOR_NEGATIVE = 0x00000002
	}
}
