﻿<%@ Page Language="C#" AutoEventWireup="true" EnableViewState="false" EnableSessionState="False" %>
<%@ Import Namespace="System.Xml" %>
<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Data" %>
<%@ Import Namespace="System.Diagnostics" %>

<script runat="server">

	public readonly string UpdateFilesDirectory = "./UpdateFiles/";
	public readonly string DeletedFilesDirectory = "./DeleteFiles/";
	public readonly string ExecuteFilesDirectory = "./ExecuteFiles/";
	public readonly string ChangelogFilePath = "./Changelog.txt";

	private DataTable _FileList = new DataTable();
	
	protected override void OnInit(EventArgs e)
	{
		if (!Directory.Exists(Server.MapPath(this.UpdateFilesDirectory))) Directory.CreateDirectory(Server.MapPath(this.UpdateFilesDirectory));
		if (!Directory.Exists(Server.MapPath(this.DeletedFilesDirectory))) Directory.CreateDirectory(Server.MapPath(this.DeletedFilesDirectory));
		if (!Directory.Exists(Server.MapPath(this.ExecuteFilesDirectory))) Directory.CreateDirectory(Server.MapPath(this.ExecuteFilesDirectory));
		if (!File.Exists(Server.MapPath(this.ChangelogFilePath))) File.WriteAllText(Server.MapPath(this.ChangelogFilePath), "", Encoding.UTF8);
		
		_FileList.Columns.Add("FileSN", typeof(string));
		_FileList.Columns.Add("FileName", typeof(string));
		_FileList.Columns.Add("FileSize", typeof(string));
		_FileList.Columns.Add("FileVersion", typeof(string));
		_FileList.Columns.Add("FileUpdateTime", typeof(string));
		_FileList.Columns.Add("UpdateMethod", typeof(string));
		
		base.OnInit(e);

		_ReadFileList();
		
		Response.ContentType = "text/xml";

		this.SourceDocument.Save(Response.Output);
		//Response.Write(this.SourceDocument);
	}

	private void _ReadFileList()
	{
		int i = 0;
		DirectoryInfo di = new DirectoryInfo(Server.MapPath(this.UpdateFilesDirectory));

		// 常规更新
		foreach (FileInfo f in di.GetFiles())
		{
			i++;
			_FileList.Rows.Add(new object[] { i, f.Name, f.Length, this.GetFileVersion(f.FullName), f.LastWriteTime.ToString("yyyy-MM-dd HH:mm:ss"), "更新" });
		}

		// 需要删除的文件
		di = new DirectoryInfo(Server.MapPath(this.DeletedFilesDirectory));
		foreach (FileInfo f in di.GetFiles())
		{
			i++;
			_FileList.Rows.Add(new object[] { i, f.Name, f.Length, this.GetFileVersion(f.FullName), f.LastWriteTime.ToString("yyyy-MM-dd HH:mm:ss"), "删除" });
		}

		// 需要执行的文件
		di = new DirectoryInfo(Server.MapPath(this.ExecuteFilesDirectory));
		foreach (FileInfo f in di.GetFiles())
		{
			i++;
			_FileList.Rows.Add(new object[] { i, f.Name, f.Length, this.GetFileVersion(f.FullName), f.LastWriteTime.ToString("yyyy-MM-dd HH:mm:ss"), "执行" });
		}
	}

	/// <summary>
	/// 获取指定文件的文件版本号，仅读取FileVersion
	/// </summary>
	/// <param name="FileName">要获取文件版本号的文件地址</param>
	/// <returns>如果存在则返回完整的文件版本号，否则将返回错误信息</returns>
	public string GetFileVersion(string FileName)
	{
		try
		{
			FileVersionInfo fi = FileVersionInfo.GetVersionInfo(FileName);
			string ver = String.IsNullOrEmpty(fi.FileVersion) ? "0" : fi.FileVersion;
			return ver.Trim();
		}
		catch
		{
			return "0";
		}
	}
	
	private XmlDocument SourceDocument
	{
		get
		{
			XmlDocument doc = new XmlDocument();

			doc.AppendChild(doc.CreateXmlDeclaration("1.0", "UTF-8", null));

			XmlElement root = doc.CreateElement("QQLoginManager");
			XmlElement list = doc.CreateElement("UpdateFileList");

			DataRow[] Rows = _FileList.Select("FileSize > 0", "FileName");

			foreach (DataRow dr in Rows)
			{
				XmlElement file = doc.CreateElement("File");

				file.InnerText = dr["FileName"].ToString();
				file.SetAttribute("FileSize", dr["FileSize"].ToString());
				file.SetAttribute("FileVersion", dr["FileVersion"].ToString());
				file.SetAttribute("FileUpdateTime", dr["FileUpdateTime"].ToString());
				file.SetAttribute("UpdateMethod", dr["UpdateMethod"].ToString());

				list.AppendChild(file);
			}

			root.AppendChild(list);
			
			// 更新简介
			string data = File.ReadAllText(Server.MapPath(this.ChangelogFilePath));
			XmlElement cdata = doc.CreateElement("UpdateInfo");
			cdata.AppendChild(doc.CreateCDataSection(data));
			
			root.AppendChild(cdata);
			doc.AppendChild(root);

			return doc;
		}
	}

</script>