import sys
import os
from qtpy.QtCore import QDir#, QT_VERSION

from pmtoolbox.system.platforminfo import isWindowsPlatform


def get_python_version():
    """
    View the current python version
    """
    ver = sys.version.split(' ')[0]
    if sys.version.find('64 bit') > 0:
        ver = 'Python ' + ver + ' 64-bit'
    else:
        ver = 'Python ' + ver + ' 32-bit'
    return ver


def get_python_modules_directory():
    """
    Function to determine the path to Python's modules directory.

    @return path to the Python modules directory (string)
    """
    import distutils.sysconfig
    return distutils.sysconfig.get_python_lib(True)


def getPyQt5ModulesDirectory():
    """
    Function to determine the path to PyQt5 modules directory.

    @return path to the PyQt5 modules directory (string)
    """
    import distutils.sysconfig

    pyqtPath = os.path.join(distutils.sysconfig.get_python_lib(True), "PyQt5")
    if os.path.exists(pyqtPath):
        return pyqtPath

    return ""


def getPyQtToolsPath(version=5):
    """
    Module function to get the path of the PyQt tools.

    @param version PyQt major version
    @type int
    @return path to the PyQt tools
    @rtype str
    """

    path = ""

    program = "pyrcc{0}".format(version)
    if isWindowsPlatform():
        program += ".exe"
        dirName = os.path.dirname(sys.executable)
        if os.path.exists(os.path.join(dirName, program)):
            path = dirName
        elif os.path.exists(os.path.join(dirName, "Scripts", program)):
            path = os.path.join(dirName, "Scripts")
    else:
        dirName = os.path.dirname(sys.executable)
        if os.path.exists(os.path.join(dirName, program)):
            path = dirName

    return path


def getQtBinariesPath():
    """
    Module function to get the path of the Qt binaries.

    @return path of the Qt binaries
    @rtype str
    """

    path = ""

    program = "designer"
    if isWindowsPlatform():
        program += ".exe"
        dirName = os.path.dirname(sys.executable)
        if os.path.exists(os.path.join(dirName, program)):
            path = dirName
        elif os.path.exists(os.path.join(dirName, "Scripts", program)):
            path = os.path.join(dirName, "Scripts")
    else:
        dirName = os.path.dirname(sys.executable)
        if os.path.exists(os.path.join(dirName, program)):
            path = dirName

    return QDir.toNativeSeparators(path)


def qVersionTuple():
    """
    Module function to get the Qt version as a tuple.

    @return Qt version as a tuple
    @rtype tuple of int
    """
    return (
        (QT_VERSION & 0xff0000) >> 16,
        (QT_VERSION & 0xff00) >> 8,
        QT_VERSION & 0xff,
    )
