def is_version_satisfied(current_version: str, required_version: str) -> bool:
    """
    判断版本号是否满足要求
    current_version>=required_version:返回True
    否则返回False
    Args:
        current_version:当前版本
        required_version:

    Returns:

    """
    app_version_l = current_version.split('.')
    remote_version_l = required_version.split('.')
    assert len(app_version_l) == len(remote_version_l)
    for velemapp, velemremote in zip(app_version_l, remote_version_l):
        if int(velemapp) < int(velemremote):
            return False
        elif int(velemapp) > int(velemremote):
            print("warning:app version %s is newer than version on server %s." % (current_version, required_version))
    return True
