# -*- coding:utf-8 -*-
# @Time: 2021/2/7 21:00
# @Author: Zhanyi Hou
# @Email: 1295752786@qq.com
# @File: datamerge.py
from typing import List

from pmgwidgets import PMGPanelDialog, PMGPanel
from pyminer_comm.base import is_pyminer_service_started
from pyminer_comm import get_var_names, get_var, set_var, run_command
from pmtoolbox import VariableSelect, input_identifier
from qtpy.QtWidgets import QDialog, QDialogButtonBox, QVBoxLayout, QSpinBox, QApplication, QMessageBox, QPushButton

if not __name__ == '__main__':
    from .base import BaseDFOperationDialog
else:
    from base import BaseDFOperationDialog


class DropNADialog(BaseDFOperationDialog):
    def __init__(self, ):
        super(DropNADialog, self).__init__()
        views = [
            ('combo_ctrl', 'axis', self.tr('Position'), 0, [0, 1], [self.tr('行'), self.tr('列')]),
            ('combo_ctrl', 'how', self.tr('How to drop'), 'any', ['all', 'any'], [self.tr('All'), self.tr('Any')]),
            ('numberspin_ctrl', 'thresh', '保留非空值多于等于此的行/列', 1, '', (0, 1000), 1),
            ('check_ctrl', 'use_subset', self.tr('Drop by subset'), False),
            ('list_ctrl', 'subset', self.tr('Subset'), [[], [], ], lambda: None),
            ('check_ctrl', 'inplace', self.tr('In Place'), False)
        ]
        self.panel.set_items(views)
        self.panel.set_as_controller('how', ['thresh'], 'all', 'enable')
        self.panel.set_as_controller('use_subset', ['subset'], True, 'enable')

    def get_prompt_template(self) -> str:
        return self.tr('Drop NA:')

    def get_code(self) -> str:
        values = self.panel.get_value_with_filter()
        varname = self.combo_box.currentText()
        use_subset = values.pop('use_subset')

        code = self.get_value_code()

        if not values['inplace']:
            identifier = input_identifier(parent=self, default_name=varname)
            if identifier != '':
                code = identifier + ' = ' + code
            else:
                return ''
        return code

    def get_value_code(self) -> str:
        values = self.panel.get_value_with_filter()
        varname = self.combo_box.currentText()
        use_subset = values.pop('use_subset')

        code = '{varname}.dropna({args_str})'. \
            format(varname=varname, args_str=self.kwargs_to_str(values))
        return code


if __name__ == '__main__':
    app = QApplication([])
    md = DropNADialog()
    md.show()
    app.exec_()
