from typing import List

from pmgwidgets import PMGPanelDialog, PMGPanel
from pyminer_comm.base import is_pyminer_service_started
from pyminer_comm import get_var_names, get_var, set_var, run_command
from pmtoolbox import VariableSelect, input_identifier
from qtpy.QtWidgets import QDialog, QDialogButtonBox, QVBoxLayout, QSpinBox, QApplication, QMessageBox, QPushButton, \
    QComboBox

if not __name__ == '__main__':
    from .base import BaseDFOperationDialog
else:
    from base import BaseDFOperationDialog


class TransposeDialog(BaseDFOperationDialog):
    def __init__(self, ):
        super(TransposeDialog, self).__init__()

        views = [
            ('check_ctrl', 'copy', self.tr('Copy'), False),
            # ('check_ctrl', 'inplace', self.tr('In Place'), False),  # 直接覆盖之前的变量。注意，并没有这个参数。
        ]
        self.panel.set_items(views)

    def get_prompt_template(self) -> str:
        return self.tr('Transpose, command: ')

    def get_value_code(self) -> str:
        values = self.panel.get_value_with_filter()  # 只获取使能并且可见的控件的值
        varname = self.combo_box.currentText()
        args_str = ''
        for k, v in values.items():
            args_str += '{k}={v},'.format(k=k, v=repr(v))
        code = '{varname}.transpose({args})'.format(varname=varname, args=args_str)
        return code

    def get_code(self) -> str:
        values = self.panel.get_value_with_filter()  # 只获取使能并且可见的控件的值
        varname = self.combo_box.currentText()

        code = self.get_value_code()

        if values['copy']:
            identifier = input_identifier(parent=self, default_name=varname)
            if identifier != '':
                code = identifier + ' = ' + code
            else:
                return ''
        return code


if __name__ == '__main__':
    app = QApplication([])
    md = TransposeDialog()
    md.show()
    app.exec_()
