import datetime
import webbrowser
import numpy as np
import pandas as pd

# 导入PyQt5模块
from qtpy.QtCore import QSize, Qt, Signal
from qtpy.QtGui import QPixmap
from qtpy.QtWidgets import QHBoxLayout, QWidget, QSpacerItem, QToolButton, QSizePolicy, QWizard, QMessageBox, \
    QFileDialog, QFrame, QDesktopWidget, QDialog, QTableWidgetItem, QInputDialog, QAbstractItemView, QLineEdit, \
    QApplication

# 导入数据相关操作模块
from pyminer2.extensions.packages.pm_statistics.ui.stat_base import Ui_Form as StatDesc_Ui_Form  # # 数据筛选

class StatDescForm(QDialog, StatDesc_Ui_Form):
    """
    打开"统计-描述统计"窗口
    """
    signal_data_change = Signal(str, dict)  # 自定义信号，用于修改数据 变量名，数据集

    def __init__(self, parent=None):
        super().__init__(parent)
        self.setupUi(self)
        self.center()


        # 变量初始化
        self.current_dataset = pd.DataFrame()
        self.current_dataset_name = ''
        self.current_dataset_columns = []
        self.data_type = []
        self.var_widget_name='stats_var'  # 默认输入控件为统计变量选择框

        self.listWidget_var.addItems(list(self.current_dataset_columns))

        # 绑定事件
        self.radioButton_all.toggled.connect(self.stat_check_all)
        self.listWidget_var.itemDoubleClicked.connect(self.item_check)
        self.textEdit_var.focusInEvent.connect(self.test)
        self.textEdit_group.focusInEvent.connect(self.test_2)
        # self.comboBox_random.currentIndexChanged.connect(self.filter_random_label)  # 按比例随机抽样时，显示%，否则隐藏%
        # self.lineEdit_col_find.textChanged.connect(self.filter_column_partter)
        # self.pushButton_ok.clicked.connect(self.dataset_update)
        # self.pushButton_cancel.clicked.connect(self.close)
        # self.pushButton_help.clicked.connect(self.get_help)
        
    def test(self):
        print("当前已选stats_var")

    def test_2(self):
        print("当前已选group_var")

    def keyPressEvent(self, e):
        """
        按键盘Escape退出当前窗口
        @param e:
        """
        if e.key() == Qt.Key_Escape:
            reply = QMessageBox.question(self, '确认退出？', '是否退出当前窗口？', QMessageBox.Yes | QMessageBox.No, QMessageBox.No)
            if reply == QMessageBox.Yes:
                self.close()

    def center(self):
        screen = QDesktopWidget().screenGeometry()
        size = self.geometry()
        self.move(int((screen.width() - size.width()) / 2), int((screen.height() - size.height()) / 2))

    def get_help(self):
        """
        打开帮助页面
        """
        try:
            webbrowser.get('chrome').open_new_tab("http://www.pyminer.com")
        except Exception as e:
            webbrowser.open_new_tab("http://www.pyminer.com")

    def item_check(self):
        text=self.listWidget_var.currentItem().text()
        print("当前已选item的文本为{}".format(text))

    def stat_check_all(self):
        """
        选中全部统计项
        """
        for child in self.hbox_stat_option.findChildren(('QCheckBox')):
            print(child)
            child.setChecked(True)

    # def varStats(dataframe, round=2):
    #     format_str = "{" + "0:,." + str(round) + "f}"
    #     data = dataframe
    #     list_role = []
    #     list_dtype = []
    #     list_level = []
    #     list_use = []
    #     list_sum = []
    #     list_max = []
    #     list_min = []
    #     list_total_count = []
    #     list_null = []
    #     list_null_rate = []
    #     list_unique = []
    #     list_unique_rate = []
    #     list_mean = []
    #     list_median = []
    #     list_q1 = []
    #     list_q3 = []
    #     list_var = []
    #     list_std = []
    #     list_skew = []
    #     list_kurt = []
    #     list_notnull_count = []
    #     list_mode = []
    #     list_range = []
    #     list_qrange = []
    #     list_cov = []
    #     list_sum_of_squares = []
    #     list_se = []
    #     for i in data.columns:
    #         if i.lower() in ['y', 'target']:
    #             role = "目标"
    #         elif i.lower() in ['id', 'userid', 'user_id', 'order_no', 'order_id']:
    #             role = "ID"
    #         else:
    #             role = "输入"
    #         list_dtype.append(str(data[i].dtypes))
    #         list_role.append(role)
    #         if data[i].nunique() == 2:
    #             list_level.append("二值型")
    #         elif data[i].nunique() > 2 and str(data[i].dtypes) == "object":
    #             list_level.append("名义型")
    #         elif data[i].nunique() == 1:
    #             list_level.append("单一值")
    #         else:
    #             list_level.append("区间型")
    #         list_use.append("是")
    #         list_total_count.append(len(data))
    #         list_notnull_count.append(data[i].notnull().sum())
    #         list_null.append(data[i].isnull().sum())
    #         list_null_rate.append('{:,.2%}'.format(data[i].isnull().sum() / len(data)))
    #         list_unique.append(data[i].nunique())
    #         list_unique_rate.append('{:,.2%}'.format(data[i].nunique() / len(data)))
    #         list_mode.append(data[i].mode()[0])
    #         # 数值变量计算
    #         if str(data[i].dtypes) == "int64" or str(data[i].dtypes) == "float64":
    #             list_min.append(data[i].min())
    #             list_q1.append(format_str.format(data[i].quantile(0.25)))
    #             list_q3.append(format_str.format(data[i].quantile(0.75)))
    #             list_skew.append(format_str.format(data[i].skew()))
    #             list_kurt.append(format_str.format(data[i].kurt()))
    #             list_mean.append(format_str.format(data[i].mean()))
    #             list_var.append(format_str.format(data[i].var()))
    #             list_std.append(format_str.format(data[i].std()))
    #             list_median.append(format_str.format(data[i].median()))
    #             list_max.append(data[i].max())
    #             list_range.append(format_str.format(data[i].max() - data[i].min()))
    #             list_qrange.append(format_str.format(data[i].quantile(0.75) - data[i].quantile(0.25)))
    #             list_cov.append(format_str.format(data[i].std() / data[i].mean()))
    #             list_sum.append(format_str.format(data[i].sum()))
    #             list_sum_of_squares.append(format_str.format(sum([num * num for num in data[i]])))
    #             list_se.append(format_str.format(data[i].var() / math.sqrt(data[i].notnull().sum())))
    #         else:
    #             list_min.append("")
    #             list_q1.append("")
    #             list_q3.append("")
    #             list_skew.append("")
    #             list_kurt.append("")
    #             list_mean.append("")
    #             list_var.append("")
    #             list_std.append("")
    #             list_median.append("")
    #             list_max.append("")
    #             list_range.append("")
    #             list_qrange.append("")
    #             list_cov.append("")
    #             list_sum.append("")
    #             list_sum_of_squares.append("")
    #             list_se.append("")
    #     df = pd.DataFrame(
    #         {"变量名": data.columns, '数据类型': list_dtype, '角色': list_role, '水平': list_level, '是否使用': list_use,
    #          '总体计数': list_total_count, '非缺失值计数': list_notnull_count, '均值': list_mean, '均值标准误': list_se, '方差': list_var,
    #          '标准差': list_std, '变异系数': list_cov, '总和': list_sum, '平方和': list_sum_of_squares, '众数': list_mode,
    #          '最小值': list_min, 'Q1': list_q1, '中位数': list_median, 'Q3': list_q3, '最大值': list_max, '极差': list_range,
    #          '四分位间距': list_qrange, '峰度': list_kurt, '偏度': list_skew, '缺失值': list_null, '缺失值占比': list_null_rate,
    #          '唯一值': list_unique, '唯一值占比': list_unique_rate})
    #     df.to_csv("var_stats.csv")
    #     return df



