;(function($){
	$.bSlider = {
        version: '1.0.0'
    };
	$.fn.bSlider = function(options){
		var $target = $(this),ppTimer,isRunning = false;
		options = $.extend({
			autoPlay: false,
			easing: 'linear',
			interval: 3000,
        	showCaption: true
		}, options);
		var $navtab = $target.find('.bslider_nav'),$pptitle = $target.find('.bslider_title'),easing = options.easing || 'easeOutQuad',
		$wrapper = $target.find('.bslider_previewwrapper'),$content = $target.find('.wp-bslider_content'),maxheight = $content.height(),
		maxwidth = $content.width();
		// Define handler
		$.bSlider.doSize = function(dom){
			var $newrap = dom,nmspace = '.'+$target.attr("id"),$img = $newrap.find('img');
			dom = null;$newrap.find('div.loading').width(maxwidth).height(maxheight);
			$img.unbind(nmspace).bind('resizephoto'+nmspace, function(evt, width, height){
				if (!width || !height) return;
				var $img = $(this),ceil = Math.ceil,curdifw = curdifh = 0;
				$img.prev('div.loading').hide();
				var $tmpnode = $target.find('.wp-bslider_content'),maxheight = $tmpnode.height(),
				maxwidth = $tmpnode.width();
				if (width >= height) {
					$img.width(maxwidth).height("auto");
					// Auto fixed height
					curdifh = maxheight - $img.height();
					if (curdifh < 0) $img.css({"margin-top": ceil(curdifh / 2)+'px',"margin-left": '0px'});
					else if (curdifh > 0) {
						$img.height(maxheight).width("auto");
						curdifw = maxwidth - $img.width();
						$img.css({"margin-top": '0px',"margin-left": ceil(curdifw / 2)+'px'});
					} else $img.css({"margin-top": '',"margin-left": ''});
				} else {
					$img.height(maxheight).width("auto");
					// Auto fixed width
					curdifw = maxwidth - $img.width();
					if (curdifw < 0) $img.css({"margin-top": '0px',"margin-left": ceil(curdifw / 2)+'px'});
					else if (curdifw > 0) {
						$img.width(maxwidth).height('auto');
						curdifh = maxheight - $img.height();
						$img.css({"margin-top": ceil(curdifh / 2)+'px',"margin-left": '0px'});
					} else $img.css({"margin-top": '',"margin-left": ''});
				}
				$img = null;
			});
		};
		$.bSlider.setCaptionPosition = function(){
			var params = {opacity: '0'};
			if (options.showCaption) {
				var _top = $navtab.find('li.active').position().top + $navtab.position().top,
				maxtop = maxheight - $pptitle.height();
				_top = (_top > maxtop) ? maxtop : _top;
				_top = (_top < 0) ? 0 : _top;
				params = {top: _top,opacity: '1'};
			}
			$pptitle.stop().animate(params, 500, easing);
		};
		$.bSlider.play = function(){
			if (isRunning) return;
			clearInterval(ppTimer);
			var $active = $navtab.find('li.active'),reset = false;
			$active.removeClass('active');
			if (!$active.is(':last-child')) $active.next().addClass('active');
			else {
				reset = true;
				$active.parent().find('li:first-child').addClass('active');
			}
			// Nav-tab play
			var maxTop = maxheight - $navtab.height(),_navTop = 0;
			if (maxTop < 0) {
				var $newactive = $navtab.find('li.active'),curHeight = $newactive.height(),
				navTop = $navtab.position().top;
				if (($newactive.position().top + navTop + curHeight) > maxheight) {
					_navTop = navTop - curHeight;
					_navTop = Math.max(_navTop, maxTop);
				} else if (reset) {
					_navTop = 0;
				} else _navTop = navTop;
				$navtab.stop().animate({top: _navTop}, 300);
			}
			// Goto start
			$.bSlider.initialize();
		};
		$.bSlider.initialize = function(){
			$wrapper.find('.source').removeClass("new").addClass("old");
			var $curli = $navtab.find('li.active .source'),$cura = $curli.next('h3').find('a');
			$wrapper.prepend($curli.clone().addClass("new").css("opacity", '0'));
			isRunning = true;clearInterval(ppTimer);
			// Remove/Add img attriable
			var $newimg = $wrapper.find('div.new img');$newimg.removeAttr("title");
			if ($cura.size() != 0) {
				var href = $cura.attr("href"),target = $cura.attr("target");
				if (href && $.trim(href).length) $newimg.wrap('<a href="'+href+'"'+(target?' target="'+target+'"':'')+'></a>');
			}
			// Show caption
			$pptitle.find('h3,.subtext').stop().animate({opacity: '0'}, 300, function(){
				var $active = $navtab.find('li.active');
				$pptitle.find('h3').html($active.find('h3').html());
				$pptitle.find('.subtext').html($active.find('p').text());
				$(this).animate({opacity: '1'}, 1000, easing);
			});
			// Reset caption position
			$.bSlider.setCaptionPosition();
			// Nav-tab animate
			$navtab.find('li img').stop().animate({opacity: '.4'}, 500);
			$navtab.find('li.active img').stop().animate({opacity: '1'}, 500);
			var $oldwrap = $wrapper.find('.old');
			if ($oldwrap.length == 0) isRunning = false;
			else {
				var params = {opacity: '0'};
				if (easing != 'linear') params = $.extend({},params,{top: maxheight+'px',left: maxwidth+'px',width: 0,height: 0});
				$oldwrap.add($oldwrap.find('img')).stop(true).animate(params, 1500, easing, function(){
					$(this).remove();isRunning = false;
				});
				$oldwrap = null;
			}
			var $newrap = $wrapper.find('.new'),$newimg = $newrap.find('img');$newimg.css("opacity", '0');
			$newrap.add($newimg).stop(true).animate({opacity: '1'}, 1500, easing);
			// Photo adaptive
			$.bSlider.doSize($newrap);
			// Auto play
			var time = options.interval;
			if (options.autoPlay  && (time > 0)) ppTimer = setInterval($.bSlider.play, time);
		};
		// Mouse event
		$navtab.mousemove(function(e){
			var $nav = $(this),navh = $nav.height(),
			_top = intval((navh / maxheight) * (e.pageY - $target.offset().top)) * -1;
			if (_top > 0) _top = 0;
			if (_top <= maxheight - navh) _top = maxheight - navh;
			if (maxheight > navh) _top = 0;
			$nav.stop().animate({top: _top}, 300);
		}).find('li').hover(function(){
			$(this).find('img.thumb').stop().animate({opacity: '1'}, 500);
		}, function(){
			var $li = $(this);
			if (!$li.hasClass('active')) $li.find('img.thumb').stop().animate({opacity: '.4'}, 500);
		}).click(function(){
			var $li = $(this);
			if (!$li.hasClass('active') && !isRunning) {
				clearInterval(ppTimer);
				$li.addClass('active').siblings().removeClass('active');
				$.bSlider.initialize();
			}
		});
		// Initialize
		$navtab.find('li:first-child').addClass('active');
		$.bSlider.initialize();
		
		return $target;
	};
	function intval(str){
		var i = parseInt(str);
		return isNaN(i) ? 0 : i;
	}
})(jQuery);