﻿<%
'=========================================================
 'Class: AnUpLoad
 'Author: Anlige
 'Version:AienAspUpload V13.12.09
 'CreationDate: 2008-04-12
 'ModificationDate: 2013-12-09
 'homepage: http://dev.mo.cn
 'email: zhanghuiguoanlige@126.com
 'qq: 1034555083
'=========================================================
Dim StreamT
Class AnUpLoad
	Private Form, Fils
	Private vCharSet, vMaxSize, vSingleSize, vErr, vVersion, vTotalSize, vExe, vErrExe,vboundary, vLostTime, vMode, vFileCount,StreamOpened
	private vMuti,vServerVersion
	Public Property Let Mode(ByVal value)
		vMode = value
	end Property
	
	Public Property Let MaxSize(ByVal value)
		vMaxSize = value
	end Property
	
	Public Property Let SingleSize(ByVal value)
		vSingleSize = value
	end Property
	
	Public Property Let Exe(ByVal value)
		vExe = LCase(value)
		vExe = replace(vExe,"*.","")
		vExe = replace(vExe,";","|")
	end Property
	
	Public Property Let CharSet(ByVal value)
		vCharSet = value
	end Property
	
	Public Property Get Errorid()
		Errorid = vErr
	end Property
	
	Public Property Get FileCount()
		FileCount = Fils.count
	end Property
	
	Public Property Get Description()
		Description = GetErr(vErr)
	end Property
	
	Public Property Get Version()
		Version = vVersion
	end Property
	
	Public Property Get TotalSize()
		TotalSize = vTotalSize
	end Property
	
	Public Property Get LostTime()
		LostTime = vLostTime
	end Property
	
	Private Sub Class_Initialize()
		set Form = server.createobject("Scripting.Dictionary")
		set Fils = server.createobject("Scripting.Dictionary")
		Set StreamT = server.CreateObject("Adodb.stream")
		vVersion = "AienAspUpload V13.12.09"
		vMaxSize = -1
		vSingleSize = -1
		vErr = -1
		vExe = ""
		vTotalSize = 0
		vcharset=utf-8
		vMode = 0
		StreamOpened=false
		vMuti="_" & Getname() & "_"
		vServerVersion = 6.0
		Dim t_
		t_ = lcase(Request.ServerVariables("SERVER_SOFTWARE"))
		t_ = replace(t_,"microsoft-iis/","")
		if isnumeric(t_) then vServerVersion = cdbl(t_)
	end Sub
	
	Private Sub Class_Terminate()
		Dim f
		Form.RemoveAll()
		For each f in Fils 
			Fils(f).value=empty
			Set Fils(f) = Nothing
		Next
		Fils.RemoveAll()
		Set Form = Nothing
		Set Fils = Nothing
		if StreamOpened then StreamT.close()
		Set StreamT = Nothing
	end Sub
	
	Public Sub GetData()
		Dim time1
		time1 = timer()
		Dim value, str, bcrlf, fpos, sSplit, slen, istart,ef
		Dim TotalBytes,tempdata,BytesRead,ChunkReadSize,PartSize,DataPart,formend, formhead, startpos, endpos, formname, FileName, fileExe, valueend, NewName,localname,type_1,contentType
		TotalBytes = Request.TotalBytes
		ef = false
		If checkEntryType = false Then ef = true : vErr = 2
		If vServerVersion>=6 Then
			If Not ef Then
				If vMaxSize > 0 And TotalBytes > vMaxSize Then ef = true : vErr = 1
			end If
		end If
		If ef Then Exit Sub
		If vMode = 0 Then
			vTotalSize = 0 
			StreamT.Type = 1
			StreamT.Mode = 3
			StreamT.Open
			StreamOpened = true
			BytesRead = 0
			ChunkReadSize = 1024 * 16
			Do While BytesRead < TotalBytes
				PartSize = ChunkReadSize
				If PartSize + BytesRead > TotalBytes Then PartSize = TotalBytes - BytesRead
				DataPart = Request.BinaryRead(PartSize)
				StreamT.Write DataPart
				BytesRead = BytesRead + PartSize
			Loop
			StreamT.Position = 0
			tempdata = StreamT.Read
		Else
			tempdata = Request.BinaryRead(TotalBytes)
		end If
		bcrlf = ChrB(13) & ChrB(10)
		fpos = InStrB(1, tempdata, bcrlf)
        sSplit = MidB(tempdata, 1, fpos - 1)
		slen = LenB(sSplit)
		istart = slen + 2
        Do
            formend = InStrB(istart, tempdata, bcrlf & bcrlf)
            if formend<=0 then exit do
            formhead = MidB(tempdata, istart, formend - istart)
            str = Bytes2Str(formhead)
            startpos = InStr(str, "name=""") + 6
            if startpos<=0 then exit do
            endpos = InStr(startpos, str, """")
            if endpos<=0 then exit do
            formname = LCase(Mid(str, startpos, endpos - startpos))
            valueend = InStrB(formend + 3, tempdata, sSplit)
            if valueend<=0 then exit do
			If InStr(str, "filename=""") > 0 Then
				formname = formname & vMuti & "0"
				startpos = InStr(str, "filename=""") + 10
				endpos = InStr(startpos, str, """")
				type_1=instr(endpos,lcase(str),"Content-Type")
				contentType=trim(mid(str,type_1+13))
				FileName = Mid(str, startpos, endpos - startpos)
				If Trim(FileName) <> "" Then
					FileName = Replace(FileName, "/", "\")
					FileName = Replace(FileName, chr(0), "")
					Localname = FileName
					FileName = Mid(FileName, InStrRev(FileName, "\") + 1)
					If instr(FileName,".")>0 Then
						fileExe = Split(FileName, ".")(UBound(Split(FileName, ".")))
					else
						fileExe = ""
					end If
					If vExe <> "" Then
						If checkExe(fileExe) = True Then
							vErr = 3
							vErrExe = fileExe
							tempdata = empty
							Exit Sub
						end If
					end If
					NewName = Getname()
					NewName = NewName & "." & fileExe
					vTotalSize = vTotalSize + valueend - formend - 6
					If vSingleSize > 0 And (valueend - formend - 6) > vSingleSize Then
						vErr = 5
						tempdata = empty
						Exit Sub
					end If
					If vMaxSize > 0 And vTotalSize > vMaxSize Then
						vErr = 1
						tempdata = empty
						Exit Sub
					end If
					If Fils.Exists(formname) Then formname = GetNextFormName(formname)
					Dim fileCls:set fileCls= new UploadFileEx
					fileCls.contentType=contentType
					fileCls.Size = (valueend - formend - 6)
					fileCls.Position = (formend + 3)
					fileCls.FormName = formname
					fileCls.NewName = NewName
					fileCls.FileName = FileName
					fileCls.Localname = FileName
					fileCls.extend=split(NewName,".")(ubound(split(NewName,".")))
					Fils.Add formname, fileCls
					Set fileCls = Nothing
				end If
			Else
				value = MidB(tempdata, formend + 4, valueend - formend - 6)
				If Form.Exists(formname) Then
					Form(formname) = Form(formname) & "," & Bytes2Str(value)
				Else
					Form.Add formname, Bytes2Str(value)
				end If
			end If
            istart = valueend + 2 + slen
        Loop Until (istart + 2) >= LenB(tempdata)
		vErr = 0
		tempdata = empty
		vLostTime = FormatNumber((timer-time1)*1000,2)
	end Sub
	
	Private Function CheckExe(ByVal ex)
		Dim notIn: notIn = True
		If vExe="*" then
			notIn=false 
		elseIf InStr(1, vExe, "|") > 0 Then
			Dim tempExe: tempExe = Split(vExe, "|")
			Dim I: I = 0
			For I = 0 To UBound(tempExe)
				If LCase(ex) = tempExe(I) Then
					notIn = False
					Exit For
				end If
			Next
		Else
			If vExe = LCase(ex) Then
				notIn = False
			end If
		end If
		checkExe = notIn
	end Function
	
	Public Function GetSize(ByVal Size)
		If Size < 1024 Then
			GetSize = FormatNumber(Size, 2) & "B"
		ElseIf Size >= 1024 And Size < 1048576 Then
			GetSize = FormatNumber(Size / 1024, 2) & "KB"
		ElseIf Size >= 1048576 Then
			GetSize = FormatNumber((Size / 1024) / 1024, 2) & "MB"
		end If
	end Function
	
	Private Function Bytes2Str(ByVal byt)
		If LenB(byt) = 0 Then
			Bytes2Str = ""
			Exit Function
		end If
		Dim mystream, bstr
		Set mystream =server.createobject("ADODB.Stream")
		mystream.Type = 2
		mystream.Mode = 3
		mystream.Open
		mystream.WriteText byt
		mystream.Position = 0
		mystream.CharSet = vCharSet
		mystream.Position = 2
		bstr = mystream.ReadText()
		mystream.Close
		Set mystream = Nothing
		Bytes2Str = bstr
	end Function
	
	Private Function GetErr(ByVal Num)
		Select Case Num
			Case 0
				GetErr = "COMPLETE"
			Case 1
				GetErr = "ERROR_FILE_EXCEEDS_MAXSIZE_LIMIT"
			Case 2
				GetErr = "ERROR_INVALid_ENCTYPEOR_METHOD"
			Case 3
				GetErr = "ERROR_INVALid_FILETYPE(." & ucase(vErrExe) & ")"
			Case 5
				GetErr = "ERROR_FILE_EXCEEDS_SIZE_LIMIT"
		end Select
	end Function
	
	Private Function Getname()
		Dim y, m, d, h, mm, S, r
		Randomize
		y = Year(Now)
		m = right("0" & Month(Now),2)
		d = right("0" & Day(Now),2)
		h = right("0" & Hour(Now),2)
		mm =right("0" & Minute(Now),2)
		S = right("0" & Second(Now),2)
		r = CInt(Rnd() * 10000)
		r = right("0000" & r,4)
		Getname = y & m & d & h & mm & S & r
	end Function
	
	Private Function checkEntryType()
		Dim contentType, ctArray, bArray,RequestMethod
		RequestMethod=trim(LCase(Request.ServerVariables("REQUEST_METHOD")))
		if RequestMethod="" or RequestMethod<>"post" then
			checkEntryType = False
			exit function
		end if
		contentType = LCase(Request.ServerVariables("HTTP_CONTENT_TYPE"))
		ctArray = Split(contentType, ";")
		if ubound(ctarray)>=0 then
			If Trim(ctArray(0)) = "multipart/form-data" Then
			checkEntryType = True
			vboundary = Split(contentType,"boundary=")(1)
			Else
			checkEntryType = False
			end If
		else
			checkEntryType = False
		end if
	end Function
	
	Public Function Forms(ByVal formname)
		If trim(formname) = "-1" Then
			Set Forms = Form
		Else
			If Form.Exists(LCase(formname)) Then
				Forms = Form(LCase(formname))
			Else
				Forms = ""
			end If
		end If
	end Function
	
	Public Function Files(ByVal formname)
		If trim(formname) = "-1" Then
			Set Files = Fils
		Else
			dim vname
			vname = LCase(formname) & vMuti & "0"
			if instr(formname,vMuti)>0 then vname = formname
			If Fils.Exists(vname) Then
				Set Files = Fils(vname)
			Else
				Set Files = New UploadFileEmpty
			end If
		end If
	end Function
	
	Public Function Files_Muti(ByVal formname,byval index)
		If trim(formname) = "-1" Then
			Set Files_Muti = Fils
		Else
			If Fils.Exists(LCase(formname) & vMuti & index) Then
				Set Files_Muti = Fils(LCase(formname) & vMuti & index)
			Else
				Set Files_Muti = New UploadFileEmpty
			end If
		end If
	end Function
	
	
	Public Function Quicksave(ByVal formname,Byval savePath)
		Dim v, formstart,File,Result,SucceedCount
		SucceedCount = 0
		Dim TempFormName
		TempFormName = formname & vMuti
		For Each v In Fils
			If lcase(left(v,len(TempFormName))) = lcase(TempFormName) Then
				Set File = Fils(v)
				Result = File.saveToFile(savePath,0,True)
				If Result Then SucceedCount = SucceedCount + 1
				'Set File=Nothing
			end If
		Next
		Quicksave = SucceedCount
	end Function
	
	
	Private Function GetNextFormName(byval formname)
		Dim formstart,currentIndex
		formstart = left(formname,instr(formname,vMuti)+len(vMuti)-1)
		currentIndex = mid(formname,instr(formname,vMuti)+len(vMuti))
		currentIndex =cint(currentIndex)
		do while Fils.Exists(formname)
			currentIndex = currentIndex + 1
			formname = formstart & currentIndex
		loop
		GetNextFormName = formname
	end Function
end Class
Class UploadFileEmpty
	Public Property Get IsFile() 
		IsFile = false
	end Property
end Class
Class UploadFileEx
	Private mvarFormName , mvarNewName , mvarLocalname , mvarFileName , mvaruserSetName , mvarcontentType ,mException,mvarPosition
	Private mvarSize , mvarValue , mvarPath , mvarExtend
	
	Public Property Let Extend(ByVal vData )
		mvarExtend = vData
	end Property
	Public Property Get Extend() 
		Extend = mvarExtend
	end Property
	
	Public Property Get IsFile() 
		IsFile = true
	end Property
		
	Public Property Let Path(ByVal vData )
		mvarPath = vData
	end Property
	Public Property Get Path() 
		Path = mvarPath
	end Property
	
	Public Property Get Exception() 
		Exception = mException
	end Property
	
	Public Property Let Value(ByVal vData )
		mvarValue = vData
	end Property
	
	Public Property Get Value() 
		Value = mvarValue
	end Property
	
	Public Property Let Size(ByVal vData )
		mvarSize = vData
	end Property
	Public Property Get Size() 
		Size = mvarSize
	end Property

	Public Property Let Position(ByVal vData )
		mvarPosition = vData
	end Property
	Public Property Get Position() 
		Size = mvarPosition
	end Property
		
	Public Property Let contentType(ByVal vData )
		mvarcontentType = vData
	end Property
	Public Property Get contentType() 
		contentType = mvarcontentType
	end Property
	
	Public Property Let userSetName(ByVal vData )
		mvaruserSetName = vData
	end Property
	Public Property Get userSetName() 
		userSetName = mvaruserSetName
	end Property
	
	Public Property Let FileName(ByVal vData )
		mvarFileName = vData
	end Property
	Public Property Get FileName() 
		FileName = mvarFileName
	end Property
	
	Public Property Let Localname(ByVal vData )
		mvarLocalname = vData
	end Property
	Public Property Get Localname() 
		Localname = mvarLocalname
	end Property
	
	Public Property Let NewName(ByVal vData )
		mvarNewName = vData
	end Property
	Public Property Get NewName() 
		NewName = mvarNewName
	end Property
	
	Public Property Let FormName(ByVal vData )
		mvarFormName = vData
	end Property
	Public Property Get FormName() 
		FormName = mvarFormName
	end Property
	
	Private Sub Class_Initialize()
		mvarSize =0
		mvarFormName = ""
	end Sub

	'普通验证
	Public Function saveToFile(ByVal Path , byval tOption, byval OverWrite)
		on error resume next
		Dim IsP 
		IsP = (InStr(Path, ":") = 2)
		If Not IsP Then Path = Server.MapPath(Path)
		Path = Replace(Path, "/", "\")
		If Mid(Path, Len(Path) - 1) <> "\" Then Path = Path + "\"
		CreateFolder Path
		mvarPath = Path
		If tOption = 1 Then
			Path = Path & mvarLocalname: mvarFileName = mvarLocalname
		Else
			If tOption = -1 And mvaruserSetName <> "" Then
				Path = Path & mvaruserSetName & "." & mvarExtend: mvarFileName = mvaruserSetName & "." & mvarExtend
			Else
				Path = Path & mvarNewName: mvarFileName = mvarNewName
			end If
		end If
		If Not OverWrite Then
			Path = GetFilePath()
		end If
		Dim tmpStrm
		Set tmpStrm =server.CreateObject("ADODB.Stream")
		tmpStrm.Mode = 3
		tmpStrm.Type = 1
		tmpStrm.Open
		StreamT.Position = mvarPosition
		StreamT.copyto tmpStrm,mvarSize
		tmpStrm.saveToFile Path, 2
		tmpStrm.Close
		Set tmpStrm = Nothing
		
		userip = Request.ServerVariables("HTTP_X_FORWARDED_FOR")
		If userip = "" Then userip = Request.ServerVariables("REMOTE_ADDR")
		errnum=0

		no_allowtypes = "exe,dll,com,ocx,vxd,sys,vbs,js,php,asp,aspx,jsp,html,hta,hto,htm,apk,jar,java"
		if Instr(no_allowtypes,LCase(Extend))>0 then
			set filedel = server.CreateObject("Scripting.FileSystemObject")
			filedel.deletefile Path
			set filedel = nothing
			filename=Server.Mappath("uploads.log")
			Data="error:0x01 - "&userip&" - "&now()
			set L_fso=Server.Createobject("Scripting.FilesystemObject")
			IF L_fso.FileExists(filename) then
			   Set R_fso = L_fso.OpenTextFile(filename, 8)	'追加写入
			else
			   Set R_fso = L_fso.CreateTextFile(filename)
			end if
			if Data<>"" then R_fso.Write Data & vbcrlf
			R_fso.Close
			set R_fso = Nothing
			set L_fso = Nothing
			errnum=errnum+1
		end if
		
		set MyFile = server.CreateObject("Scripting.FileSystemObject")
		set MyText = MyFile.OpenTextFile(Path, 1)
		sTextAll = LCase(MyText.ReadAll)
		MyText.close
		set MyFile = nothing
		
		If Not Err Then
			if errnum>0 then
			saveToFile=false
			mException="error:0x00"
			else
			saveToFile=true
			end if
		Else
			saveToFile=false
			mException=Err.Description
		end If
	end Function
	
	'严格验证
	Public Function saveToFile2(ByVal Path , byval tOption, byval OverWrite)
		on error resume next
		Dim IsP 
		IsP = (InStr(Path, ":") = 2)
		If Not IsP Then Path = Server.MapPath(Path)
		Path = Replace(Path, "/", "\")
		If Mid(Path, Len(Path) - 1) <> "\" Then Path = Path + "\"
		CreateFolder Path
		mvarPath = Path
		If tOption = 1 Then
			Path = Path & mvarLocalname: mvarFileName = mvarLocalname
		Else
			If tOption = -1 And mvaruserSetName <> "" Then
				Path = Path & mvaruserSetName & "." & mvarExtend: mvarFileName = mvaruserSetName & "." & mvarExtend
			Else
				Path = Path & mvarNewName: mvarFileName = mvarNewName
			end If
		end If
		If Not OverWrite Then
			Path = GetFilePath()
		end If
		Dim tmpStrm
		Set tmpStrm =server.CreateObject("ADODB.Stream")
		tmpStrm.Mode = 3
		tmpStrm.Type = 1
		tmpStrm.Open
		StreamT.Position = mvarPosition
		StreamT.copyto tmpStrm,mvarSize
		tmpStrm.saveToFile Path, 2
		tmpStrm.Close
		Set tmpStrm = Nothing
		userip = Request.ServerVariables("HTTP_X_FORWARDED_FOR")
		If userip = "" Then userip = Request.ServerVariables("REMOTE_ADDR")
		errnum=0

		no_allowtypes = "exe,dll,com,ocx,vxd,sys,vbs,js,php,asp,aspx,jsp,html,hta,hto,htm,apk,jar,java"
		if Instr(no_allowtypes,LCase(Extend))>0 then
			set filedel = server.CreateObject("Scripting.FileSystemObject")
			filedel.deletefile Path
			set filedel = nothing
			filename=Server.Mappath("uploads.log")
			Data="error:0x01 - "&userip&" - "&now()
			set L_fso=Server.Createobject("Scripting.FilesystemObject")
			IF L_fso.FileExists(filename) then
			   Set R_fso = L_fso.OpenTextFile(filename, 8)	'追加写入
			else
			   Set R_fso = L_fso.CreateTextFile(filename)
			end if
			if Data<>"" then R_fso.Write Data & vbcrlf
			R_fso.Close
			set R_fso = Nothing
			set L_fso = Nothing
			errnum=errnum+1
		end if
		
		set MyFile = server.CreateObject("Scripting.FileSystemObject")
		set MyText = MyFile.OpenTextFile(Path, 1)
		sTextAll = LCase(MyText.ReadAll)
		MyText.close
		set MyFile = nothing
		
		'严格验证
		sStr="getfolder|createfolder|deletefolder|createdirectory|deletedirectory|createobject|wscript|shell|script.encode|encode|server|execute|language=|request|activexobject|#include|function|exec|update|value|master|truncate|declare|srcipt|<%execute|%eval|request(|shell.application|server.|saveas|scripttimeout|<?php|$_POST|$_GET"

		sNoString = split(sStr,"|") 
		for i=0 to ubound(sNoString)
		  if instr(sTextAll,sNoString(i)) then
			set filedel = server.CreateObject("Scripting.FileSystemObject")
			filedel.deletefile Path
			set filedel = nothing
			filename=Server.Mappath("uploads.log")
			Data="error:0x02 - "&userip&" - "&now()
			set L_fso=Server.Createobject("Scripting.FilesystemObject")
			IF L_fso.FileExists(filename) then
			   Set R_fso = L_fso.OpenTextFile(filename, 8)	'追加写入
			else
			   Set R_fso = L_fso.CreateTextFile(filename)
			end if
			if Data<>"" then R_fso.Write Data & vbcrlf
			R_fso.Close
			set R_fso = Nothing
			set L_fso = Nothing
			errnum=errnum+1
		  end if
		next
		
		If Not Err Then
			if errnum>0 then
			saveToFile2=false
			mException="error:0x00"
			else
			saveToFile2=true
			end if
		Else
			saveToFile2=false
			mException=Err.Description
		end If
	end Function


	Public Function GetBytes()
		StreamT.Position = mvarPosition
		GetBytes = StreamT.read(mvarSize)
	end Function
	Private Function CreateFolder(ByVal folderPath )
		Dim oFSO
		Set oFSO = server.CreateObject("Scripting.FileSystemObject")
		Dim sParent 
		sParent = oFSO.GetParentFolderName(folderPath)
		If sParent = "" Then Exit Function
		If Not oFSO.FolderExists(sParent) Then CreateFolder (sParent)
		If Not oFSO.FolderExists(folderPath) Then oFSO.CreateFolder (folderPath)
		Set oFSO = Nothing
	end Function
	
	Private Function GetFilePath() 
		Dim oFSO, Fname , FNameL , i 
		i = 0
		Set oFSO = server.CreateObject("Scripting.FileSystemObject")
		Fname = mvarPath & mvarFileName
		FNameL = Mid(mvarFileName, 1, InStr(mvarFileName, ".") - 1)
		Do While oFSO.FileExists(Fname)
			Fname = mvarPath & FNameL & "(" & i & ")." & mvarExtend
			mvarFileName = FNameL & "(" & i & ")." & mvarExtend
			i = i + 1
		Loop
		Set oFSO = Nothing
		GetFilePath = Fname
	end Function
	
	function CheckFileType(filename)
	on error resume next
	CheckFileType=false
	dim fstream,fileExt,stamp,i
	fileExt=mid(filename,InStrRev(filename,".")+1)
	set fstream=Server.createobject("ADODB.Stream")
	fstream.Open
	fstream.Type=adTypeBinary
	fstream.LoadFromFile filename
	fstream.position=0
	select case fileExt
	case "jpg","jpeg"
	stamp=fstream.read(2)
	for i=0 to 1
	if ascB(MidB(stamp,i+1,1))=jpg(i) then CheckFileType=true else CheckFileType=false
	next
	case "gif"
	stamp=fstream.read(6)
	for i=0 to 5
	if ascB(MidB(stamp,i+1,1))=gif(i) then CheckFileType=true else CheckFileType=false
	next
	case "png"
	stamp=fstream.read(4)
	for i=0 to 3
	if ascB(MidB(stamp,i+1,1))=png(i) then CheckFileType=true else CheckFileType=false
	next
	case "bmp"
	stamp=fstream.read(2)
	for i=0 to 1
	if ascB(MidB(stamp,i+1,1))=bmp(i) then CheckFileType=true else CheckFileType=false
	next
	end select
	fstream.Close
	set fseteam=nothing
	if err.number<>0 then CheckFileType=false
	end function
	
end Class
%>
