﻿var iosOverlay = function (params) {
    var overlayDOM;
    "use strict";
    var noop = function () { };
    var defaults = {
        onbeforeshow: noop,
        onshow: noop,
        onbeforehide: noop,
        onhide: noop,
        text: "",
        icon: null,
        spinner: null,
        duration: null,
        id: null,
        width: 180,
        height: 100,
        parentEl: null
    };

    // helper - merge two objects together, without using $.extend
    var merge = function (obj1, obj2) {
        var obj3 = {};
        for (var attrOne in obj1) { obj3[attrOne] = obj1[attrOne]; }
        for (var attrTwo in obj2) { obj3[attrTwo] = obj2[attrTwo]; }
        return obj3;
    };

    // helper - does it support CSS3 transitions/animation
    var doesTransitions = (function () {
        var b = document.body || document.documentElement;
        var s = b.style;
        var p = 'transition';
        if (typeof s[p] === 'string') { return true; }

        // Tests for vendor specific prop
        var v = ['Moz', 'Webkit', 'Khtml', 'O', 'ms'];
        p = p.charAt(0).toUpperCase() + p.substr(1);
        for (var i = 0; i < v.length; i++) {
            if (typeof s[v[i] + p] === 'string') { return true; }
        }
        return false;
    }());

    // setup overlay settings
    var settings = merge(defaults, params);

    // 
    var handleAnim = function (anim) {
        if (anim.animationName === "ios-overlay-show") {
            settings.onshow();
        }
        if (anim.animationName === "ios-overlay-hide") {
            destroy();
            settings.onhide();
        }
    };

    // IIFE
    var create = (function () {

        overlayDOM = document.createElement("div");
        overlayDOM.className = "ui-ios-overlay";
        overlayDOM.setAttribute("style", "width: " + settings.width + "px;height:" + settings.height + "px;");

        overlayDOM.innerHTML += '<span class="title">' + settings.text + '</span';
        if (params.icon) {
            overlayDOM.innerHTML += '<img src="' + params.icon + '">';
        } else if (params.spinner) {
            overlayDOM.appendChild(params.spinner.el);
        }
        if (doesTransitions) {
            overlayDOM.addEventListener("webkitAnimationEnd", handleAnim, false);
            overlayDOM.addEventListener("msAnimationEnd", handleAnim, false);
            overlayDOM.addEventListener("oAnimationEnd", handleAnim, false);
            overlayDOM.addEventListener("animationend", handleAnim, false);
        }
        if (params.parentEl) {
            document.getElementById(params.parentEl).appendChild(overlayDOM);
        } else {
            document.body.appendChild(overlayDOM);
        }

        settings.onbeforeshow();
        // begin fade in
        if (doesTransitions) {
            overlayDOM.className += " ios-overlay-show";
        } else if (typeof $ === "function") {
            $(overlayDOM).fadeIn({
                duration: 200
            }, function () {
                settings.onshow();
            });
        }

        if (settings.duration) {
            window.setTimeout(function () {
                hide();
            }, settings.duration);
        }

        var list = document.getElementsByClassName(overlayDOM.className);
        if (list && list.length > 0) {
            for (var i = 0; i < list.length; i++) {

            }
        }
    }());

    var hide = function () {
        // pre-callback
        settings.onbeforehide();
        // fade out
        if (doesTransitions) {
            // CSS animation bound to classes
            overlayDOM.className = overlayDOM.className.replace("show", "hide");
        } else if (typeof $ === "function") {
            // polyfill requires jQuery
            $(overlayDOM).fadeOut({
                duration: 200
            }, function () {
                destroy();
                settings.onhide();
            });
        }
    };

    var destroy = function () {
        if (params.parentEl) {
            document.getElementById(params.parentEl).removeChild(overlayDOM);
        } else {
            document.body.removeChild(overlayDOM);
        }
    };

    var update = function (params) {
        if (params.text) {
            overlayDOM.getElementsByTagName("span")[0].innerHTML = params.text;
        }
        if (params.icon) {
            if (settings.spinner) {
                settings.spinner.el.parentNode.removeChild(settings.spinner.el);
            }
            overlayDOM.innerHTML += '<img src="' + params.icon + '">';
        }
    };

    return {
        hide: hide,
        destroy: destroy,
        update: update
    };
};

(function () {
    var win_overlay;
    window.my_dialog = function (para) {
        if (win_overlay) {
            win_overlay.hide();
        }
        if (para.type == "success") {
            para.icon = "images/success.png";
        } else if (para.type == "error") {
            para.icon = "images/error.png";
        } else {
            para.icon = "images/loading.gif";
        }

        if (para.type == "wait") {
            para.duration = 5000;
        } else {
            para.duration = 2000;
        }

        win_overlay = iosOverlay(para);
    }

    window.my_dialog_conf = function (params) {
        var ops = {
            title: "Message?",
            callbackOK: function () {
                $('.ui-dialog').dialog('close');
            },
            callbackCancel: function () {
                $('.ui-dialog').dialog('close');
            }
        }

        ops = $.extend(true, ops, params);
        if ($("#openDialog_page_id").length <= 0) {
            $('body').append("<div data-role='dialog' id='openDialog_page_id' style=''><div data-role='header'><h6 style='margin-left: 20px;' id='title_name'>" + ops.title + "</h6></div><div data-role='content'><a id='t_btnOk' href='#' data-inline='true' data-role='button' data-theme='b'>确定</a><a id='t_btnCancel' href='#' data-role='button' data-inline='true'>取消</a></div></div>");

            $('body').append("<a id='openDialog_page_id_ele' href='#openDialog_page_id' data-rel=\"dialog\" style=''></a> ");
        }
        if ($("#openDialog_page_id").length <= 0) {
            alert("创建Dom错误！");
            return;
        }
        $("#openDialog_page_id_ele").trigger('click');
        $("#t_btnOk").unbind("click").bind("click", function () {
            ops.callbackOK();
            setTimeout(function () {
                $('.ui-dialog').dialog('close');
            }, 200);
        });
        $("#t_btnCancel").unbind("click").bind("click", ops.callbackCancel);
    }


})();
