﻿<script language="jscript" runat="server">
/*
oauth class,version 1.0
qq1034555083
http://dev.mo.cn
please keep this block,thank you
*/
function OAUTH(oauth_consumer_key,oauth_token){
	return new __OAUTH(oauth_consumer_key,oauth_token);
}
function __OAUTH(oauth_consumer_key,oauth_token){
	this.table=[];
	this.Set("oauth_consumer_key",oauth_consumer_key,true);
	this.Set("oauth_nonce",this._rndstr(32),true);
	this.Set("oauth_timestamp",this.GMT(),true);
	this.Set("oauth_version","1.0",true);
	this.Set("oauth_signature_method","HMAC-SHA1",true);
	this.Set("oauth_token",oauth_token,true);
	this.debug={};
}

__OAUTH.prototype.getToken = function(url,seckey,method,format){
	if(!format){format = "txt";}
	if(!method){method = "GET";}
	method = method.toUpperCase();
	this.Sort("asc","key");
	var order_string = this.APISTring("utf-8","%3D","%26",true);
	var needtosign = method + "&" + this.utf8(url) + "&" + order_string;
	var oauth_signature = b64_hmac_sha1(seckey,needtosign);
	this.Set("oauth_signature",oauth_signature);
	this.Sort("asc","key");
	var myhttp = new _SmartHttp(url,method,this.APISTring("utf-8"));
	myhttp.autoClearBuffer=false;
	myhttp.send();
	if(format=="json"){
		var result =myhttp.getjson("utf-8");
	}else if(format=="xml"){
		var result =myhttp.getxml("utf-8");
	}else{
		var result =myhttp.gettext("utf-8");	
	}
	this.debug["order_string"]=order_string;
	this.debug["needtosign"]=needtosign;
	this.debug["oauth_signature"]=oauth_signature;
	this.debug["senddata"]=myhttp.data;
	this.debug["url"]=myhttp.url;
	this.debug["response"]=myhttp.gettext("utf-8");
	
	myhttp = null;
	return result;
};

__OAUTH.prototype.Sort = function(order,key){
	if(this.Count()<=0){return ;}
	var isASC = true;
	if(order.toLowerCase()=="asc"){
		isASC=true;
	}else if(order.toLowerCase()=="desc"){
		isASC=false;
	}
	if(key!="key" && key !="value"){key="key";}
	var __temp = null;
	for(var i=0;i<this.Count()-1;i++){
		for(var j=i+1;j<this.Count();j++){
			if(this.table[i][key]>this.table[j][key] == isASC){
				var thevalue=this.table[i];
				this.table[i] = this.table[j];
				this.table[j] = thevalue;
			}
		}
	}
};


__OAUTH.prototype.APISTring = function(charset,split1,split2,forsign){
	charset ? charset : (charset="no");
	charset = charset.toLowerCase();
	if(!forsign){forsign = false;}
	if(!split1){split1="=";}
	if(!split2){split2="&";}
	if(this.Count()<=0){return "";}
	var str = "";
	for(var i=0;i< this.Count();i++){
		if(this.table[i]["value"]==""){continue;}
		var val = this.table[i]["value"];
		if(forsign && this.table[i]["isdefault"]==false){val=encodeURIComponent(val);}
		if(charset=="gb2312"){
			str += this.table[i]["key"] + split1 + escape(val) + split2;
		}else if(charset=="gbk"){
			str += this.table[i]["key"] + split1 + Server.URLEncode(val) + split2;
		}else if(charset=="no"){
			str += this.table[i]["key"] + split1 + val + split2;
		}else{
			str += this.table[i]["key"] + split1 + encodeURIComponent(val) + split2;
		}
	}
	if(str!=""){
		str = str.substr(0,str.length-split2.length);	
	}
	return str;	
};

__OAUTH.prototype.Set = function(key,value,isdefault){
	if(!value){value="";}
	if(!isdefault){isdefault=false;};
	if(this.table.length==0){
		this.table[0]={"key":key,"value":value,"isdefault":isdefault};
	}else{
		var isIn = false;
		for(var i=0;i<this.table.length;i++){
			if(this.table[i]["key"].toLowerCase()==key.toLowerCase()){
				this.table[i]["value"]= value;
				this.table[i]["isdefault"]= isdefault;
				isIn = true;
				break;
			}
		}	
		if(!isIn){
			this.table.push({"key":key,"value":value,"isdefault":isdefault});	
		}
	}
};

__OAUTH.prototype.Add = function(key,value){
	if(!value){value="";}
	if(this.table.length==0){
		this.table[0]={"key":key,"value":value};
	}else{
		var isIn = false;
		for(var i=0;i<this.table.length;i++){
			if(this.table[i]["key"].toLowerCase()==key.toLowerCase()){
				if(this.table[i]["value"]!=""){
					this.table[i]["value"]= this.table[i]["value"] + ", " + value;
				}else{
					this.table[i]["value"]= value;
				}
				isIn = true;
				break;
			}
		}	
		if(!isIn){
			this.table.push({"key":key,"value":value});	
		}
	}
};

__OAUTH.prototype.Count = function(){return this.table.length;};

__OAUTH.prototype.Parm = function(key){
	if(this.Count()<=0){return "";}
	for(var i=0;i<this.Count();i++){
		if(this.table[i]["key"].toLowerCase()==key.toLowerCase()){
			return this.table[i]["value"];
		}	
	}
	return "";
};

__OAUTH.prototype.Remove = function(key){
	if(this.Count()<=0){return}
	//key = key.toLowerCase();
	var ___temp=[];
	for(var i=0;i<this.Count();i++){
		if(this.table[i]["key"].toLowerCase()!=key.toLowerCase()){
			___temp.push(this.table[i]);
		}	
	}
	this.table=___temp;
};
__OAUTH.prototype._rndstr=function(len){
	var slen = "0123456789qwertyuioplkjhgfdsazxcvbnmQWERTYUIOPLKJHGFDSAZXCVBNM";
	var retstr="";
	for(var i=0;i<len;i++){
		retstr+=slen.substr(parseInt(Math.random()*slen.length),1);
	}
	return retstr;
};
__OAUTH.prototype.utf8 = function(str,lcase){
	if(lcase){return encodeURIComponent(str).toLowerCase();}else{
	return encodeURIComponent(str);}	
};

__OAUTH.prototype.utc = function(){
	var dat = new Date();
	return Date.UTC(dat.getFullYear(),dat.getMonth(),dat.getDate(),dat.getHours(),dat.getMinutes(),dat.getSeconds());
};
__OAUTH.prototype.GMT = function(){
/*	return utc()/1000 - 8 * 3600; */
	return utc()/1000;
};
</script>