IF  EXISTS (SELECT * FROM sysobjects WHERE object_id = OBJECT_ID(N'[dbo].[TitleOriginalRule]') AND type in (N'U'))
DROP TABLE [dbo].[TitleOriginalRule]
GO

CREATE TABLE [dbo].[TitleOriginalRule](
	[RuleId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Name] [nvarchar](60) NOT NULL,
	[RuleType] [int] NOT NULL,
	[Delimiter] [nvarchar](60) NULL,
	[Count] [int] NOT NULL,
	[CategoryId] [int] NOT NULL,
	[MatchUrl] [bit] NOT NULL,
	[Url] [nvarchar](2000) NULL,
	[ExactMatch] [bit] NOT NULL,
	[Priority] [int] NOT NULL,
	[IsEnable] [bit] NOT NULL,
	[IsDefault] [bit] NOT NULL,
	[CreatedOn] [datetime] NOT NULL,
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_TitleOriginalRule] PRIMARY KEY CLUSTERED 
(
	[RuleId] ASC
)--WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE object_id = OBJECT_ID(N'[dbo].[TitleOriginal]') AND type in (N'U'))
DROP TABLE [dbo].[TitleOriginal]
GO

CREATE TABLE [dbo].[TitleOriginal](
	[OriginalId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[CategoryId] [int] NOT NULL,
	[Vocabulary] [nvarchar](1000) NOT NULL,
	[IsDefault] [bit] NOT NULL CONSTRAINT [DF_TitleOriginal_IsDefault]  DEFAULT ((0)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_TitleOriginal_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_TitleOriginal] PRIMARY KEY CLUSTERED 
(
	[OriginalId] ASC
)--WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE object_id = OBJECT_ID(N'[dbo].[TitleCategory]') AND type in (N'U'))
DROP TABLE [dbo].[TitleCategory]
GO

CREATE TABLE [dbo].[TitleCategory](
	[CategoryId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[CategoryName] [nvarchar](100) NOT NULL,
	[IsDefault] [bit] NOT NULL CONSTRAINT [DF_TitleCategory_IsDefault]  DEFAULT ((0)),
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_TitleCategory_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_TitleCategory] PRIMARY KEY CLUSTERED 
(
	[CategoryId] ASC
)--WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE object_id = OBJECT_ID(N'[dbo].[PageTitle]') AND type in (N'U'))
DROP TABLE [dbo].[PageTitle]
GO

CREATE TABLE [dbo].[PageTitle](
	[PageId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[PageIdentity] [nvarchar](36) NOT NULL,
	[Title] [nvarchar](2000) NOT NULL,
	[OldTitle] [nvarchar](2000) NOT NULL,
	[TitleMainPart] [nvarchar](2000) NOT NULL,
	[CreatedOn] [datetime] NOT NULL CONSTRAINT [DF_PageTitle_CreatedOn]  DEFAULT (getdate()),
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_PageTitle] PRIMARY KEY CLUSTERED 
(
	[PageId] ASC
)--WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

IF  EXISTS (SELECT * FROM sysobjects WHERE object_id = OBJECT_ID(N'[dbo].[TranslateRule]') AND type in (N'U'))
DROP TABLE [dbo].[TranslateRule]
GO

CREATE TABLE [dbo].[TranslateRule](
	[RuleId] [int] IDENTITY(1,1) NOT NULL,
	[SiteId] [int] NOT NULL,
	[Name] [nvarchar](100) NOT NULL,
	[TranslateUrl] [nvarchar](4000) NOT NULL,
	[RawUrlExtractExpression] [nvarchar](4000) NULL,
	[RedirectExpression] [nvarchar](4000) NULL,
	[OperationExpression] [nvarchar](4000) NULL,
	[MatchUrl] [bit] NOT NULL,
	[Url] [nvarchar](2000) NULL,
	[ExactMatch] [bit] NOT NULL,
	[Priority] [int] NOT NULL,
	[IsEnable] [bit] NOT NULL,
	[IsDefault] [bit] NOT NULL,
	[CreatedOn] [datetime] NOT NULL,
	[UpdatedOn] [datetime] NULL,
 CONSTRAINT [PK_TranslateRule] PRIMARY KEY CLUSTERED 
(
	[RuleId] ASC
)--WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[OriginalVocabulary_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[OriginalVocabulary_ADD]
GO
------------------------------------
--;һ¼ 
--Ŀƣ
--˵
--ʱ䣺2012/12/20 20:56:56
------------------------------------
CREATE PROCEDURE OriginalVocabulary_ADD
@VocabularyId int output,
@SiteId int,
@Vocabulary nvarchar(1000),
@Synonyms nvarchar(100),
@CaseSensitive bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [OriginalVocabulary](
	[SiteId],[Vocabulary],[Synonyms],[CaseSensitive],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Vocabulary,@Synonyms,@CaseSensitive,@CreatedOn,@UpdatedOn
	)
	SET @VocabularyId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[OriginalVocabulary_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[OriginalVocabulary_Update]
GO
------------------------------------
--;޸һ¼ 
--Ŀƣ
--˵
--ʱ䣺2012/12/20 20:56:56
------------------------------------
CREATE PROCEDURE OriginalVocabulary_Update
@VocabularyId int,
@SiteId int,
@Vocabulary nvarchar(1000),
@Synonyms nvarchar(100),
@CaseSensitive bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [OriginalVocabulary] SET 
	[SiteId] = @SiteId,[Vocabulary] = @Vocabulary,[Synonyms] = @Synonyms,[CaseSensitive] = @CaseSensitive,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE VocabularyId=@VocabularyId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleCategory_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleCategory_GetMaxId]
GO
------------------------------------
--;õֵֶ 
--Ŀƣ
--˵
--ʱ䣺2013/4/27 21:47:28
------------------------------------
CREATE PROCEDURE TitleCategory_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([CategoryId])+1 FROM [TitleCategory]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleCategory_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleCategory_Exists]
GO
------------------------------------
--;ǷѾ 
--Ŀƣ
--˵
--ʱ䣺2013/4/27 21:47:28
------------------------------------
CREATE PROCEDURE TitleCategory_Exists
@CategoryId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [TitleCategory] WHERE CategoryId=@CategoryId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleCategory_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleCategory_ADD]
GO
------------------------------------
--;һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/27 21:47:28
------------------------------------
CREATE PROCEDURE TitleCategory_ADD
@CategoryId int output,
@SiteId int,
@CategoryName nvarchar(100),
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [TitleCategory](
	[SiteId],[CategoryName],[IsDefault],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@CategoryName,@IsDefault,@CreatedOn,@UpdatedOn
	)
	SET @CategoryId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleCategory_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleCategory_Update]
GO
------------------------------------
--;޸һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/27 21:47:28
------------------------------------
CREATE PROCEDURE TitleCategory_Update
@CategoryId int,
@SiteId int,
@CategoryName nvarchar(100),
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [TitleCategory] SET 
	[SiteId] = @SiteId,[CategoryName] = @CategoryName,[IsDefault] = @IsDefault,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE CategoryId=@CategoryId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleCategory_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleCategory_Delete]
GO
------------------------------------
--;ɾһ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/27 21:47:28
------------------------------------
CREATE PROCEDURE TitleCategory_Delete
@CategoryId int
 AS 
	DELETE [TitleCategory]
	 WHERE CategoryId=@CategoryId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleCategory_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleCategory_GetModel]
GO
------------------------------------
--;õʵϸϢ 
--Ŀƣ
--˵
--ʱ䣺2013/4/27 21:47:28
------------------------------------
CREATE PROCEDURE TitleCategory_GetModel
@CategoryId int
 AS 
	SELECT 
	CategoryId,SiteId,CategoryName,IsDefault,CreatedOn,UpdatedOn
	 FROM [TitleCategory]
	 WHERE CategoryId=@CategoryId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleCategory_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleCategory_GetList]
GO
------------------------------------
--;ѯ¼Ϣ 
--Ŀƣ
--˵
--ʱ䣺2013/4/27 21:47:28
------------------------------------
CREATE PROCEDURE TitleCategory_GetList
 AS 
	SELECT 
	CategoryId,SiteId,CategoryName,IsDefault,CreatedOn,UpdatedOn
	 FROM [TitleCategory]

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginal_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginal_GetMaxId]
GO
------------------------------------
--;õֵֶ 
--Ŀƣ
--˵
--ʱ䣺2013/4/27 21:47:38
------------------------------------
CREATE PROCEDURE TitleOriginal_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([OriginalId])+1 FROM [TitleOriginal]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginal_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginal_Exists]
GO
------------------------------------
--;ǷѾ 
--Ŀƣ
--˵
--ʱ䣺2013/4/27 21:47:38
------------------------------------
CREATE PROCEDURE TitleOriginal_Exists
@OriginalId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [TitleOriginal] WHERE OriginalId=@OriginalId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginal_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginal_ADD]
GO
------------------------------------
--;һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/27 21:47:38
------------------------------------
CREATE PROCEDURE TitleOriginal_ADD
@OriginalId int output,
@SiteId int,
@CategoryId int,
@Vocabulary nvarchar(1000),
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [TitleOriginal](
	[SiteId],[CategoryId],[Vocabulary],[IsDefault],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@CategoryId,@Vocabulary,@IsDefault,@CreatedOn,@UpdatedOn
	)
	SET @OriginalId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginal_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginal_Update]
GO
------------------------------------
--;޸һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/27 21:47:38
------------------------------------
CREATE PROCEDURE TitleOriginal_Update
@OriginalId int,
@SiteId int,
@CategoryId int,
@Vocabulary nvarchar(1000),
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [TitleOriginal] SET 
	[SiteId] = @SiteId,[CategoryId] = @CategoryId,[Vocabulary] = @Vocabulary,[IsDefault] = @IsDefault,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE OriginalId=@OriginalId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginal_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginal_Delete]
GO
------------------------------------
--;ɾһ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/27 21:47:38
------------------------------------
CREATE PROCEDURE TitleOriginal_Delete
@OriginalId int
 AS 
	DELETE [TitleOriginal]
	 WHERE OriginalId=@OriginalId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginal_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginal_GetModel]
GO
------------------------------------
--;õʵϸϢ 
--Ŀƣ
--˵
--ʱ䣺2013/4/27 21:47:38
------------------------------------
CREATE PROCEDURE TitleOriginal_GetModel
@OriginalId int
 AS 
	SELECT 
	OriginalId,SiteId,CategoryId,Vocabulary,IsDefault,CreatedOn,UpdatedOn
	 FROM [TitleOriginal]
	 WHERE OriginalId=@OriginalId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginal_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginal_GetList]
GO
------------------------------------
--;ѯ¼Ϣ 
--Ŀƣ
--˵
--ʱ䣺2013/4/27 21:47:38
------------------------------------
CREATE PROCEDURE TitleOriginal_GetList
 AS 
	SELECT 
	OriginalId,SiteId,CategoryId,Vocabulary,IsDefault,CreatedOn,UpdatedOn
	 FROM [TitleOriginal]

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginalRule_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginalRule_GetMaxId]
GO
------------------------------------
--;õֵֶ 
--Ŀƣ
--˵
--ʱ䣺2013/4/28 19:55:02
------------------------------------
CREATE PROCEDURE TitleOriginalRule_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([RuleId])+1 FROM [TitleOriginalRule]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginalRule_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginalRule_Exists]
GO
------------------------------------
--;ǷѾ 
--Ŀƣ
--˵
--ʱ䣺2013/4/28 19:55:02
------------------------------------
CREATE PROCEDURE TitleOriginalRule_Exists
@RuleId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [TitleOriginalRule] WHERE RuleId=@RuleId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginalRule_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginalRule_ADD]
GO
------------------------------------
--;һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/28 19:55:02
------------------------------------
CREATE PROCEDURE TitleOriginalRule_ADD
@RuleId int output,
@SiteId int,
@Name nvarchar(60),
@RuleType int,
@Delimiter nvarchar(60),
@Count int,
@CategoryId int,
@MatchUrl bit,
@Url nvarchar(2000),
@ExactMatch bit,
@Priority int,
@IsEnable bit,
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [TitleOriginalRule](
	[SiteId],[Name],[RuleType],[Delimiter],[Count],[CategoryId],[MatchUrl],[Url],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Name,@RuleType,@Delimiter,@Count,@CategoryId,@MatchUrl,@Url,@ExactMatch,@Priority,@IsEnable,@IsDefault,@CreatedOn,@UpdatedOn
	)
	SET @RuleId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginalRule_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginalRule_Update]
GO
------------------------------------
--;޸һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/28 19:55:02
------------------------------------
CREATE PROCEDURE TitleOriginalRule_Update
@RuleId int,
@SiteId int,
@Name nvarchar(60),
@RuleType int,
@Delimiter nvarchar(60),
@Count int,
@CategoryId int,
@MatchUrl bit,
@Url nvarchar(2000),
@ExactMatch bit,
@Priority int,
@IsEnable bit,
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [TitleOriginalRule] SET 
	[SiteId] = @SiteId,[Name] = @Name,[RuleType] = @RuleType,[Delimiter] = @Delimiter,[Count] = @Count,[CategoryId] = @CategoryId,[MatchUrl] = @MatchUrl,[Url] = @Url,[ExactMatch] = @ExactMatch,[Priority] = @Priority,[IsEnable] = @IsEnable,[IsDefault] = @IsDefault,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginalRule_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginalRule_Delete]
GO
------------------------------------
--;ɾһ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/28 19:55:02
------------------------------------
CREATE PROCEDURE TitleOriginalRule_Delete
@RuleId int
 AS 
	DELETE [TitleOriginalRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginalRule_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginalRule_GetModel]
GO
------------------------------------
--;õʵϸϢ 
--Ŀƣ
--˵
--ʱ䣺2013/4/28 19:55:02
------------------------------------
CREATE PROCEDURE TitleOriginalRule_GetModel
@RuleId int
 AS 
	SELECT 
	RuleId,SiteId,Name,RuleType,Delimiter,Count,CategoryId,MatchUrl,Url,ExactMatch,Priority,IsEnable,IsDefault,CreatedOn,UpdatedOn
	 FROM [TitleOriginalRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TitleOriginalRule_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TitleOriginalRule_GetList]
GO
------------------------------------
--;ѯ¼Ϣ 
--Ŀƣ
--˵
--ʱ䣺2013/4/28 19:55:02
------------------------------------
CREATE PROCEDURE TitleOriginalRule_GetList
 AS 
	SELECT 
	RuleId,SiteId,Name,RuleType,Delimiter,Count,CategoryId,MatchUrl,Url,ExactMatch,Priority,IsEnable,IsDefault,CreatedOn,UpdatedOn
	 FROM [TitleOriginalRule]

GO


if exists (select * from dbo.sysobjects where id = object_id(N'[PageTitle_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [PageTitle_GetMaxId]
GO
------------------------------------
--;õֵֶ 
--Ŀƣ
--˵
--ʱ䣺2013/4/29 11:20:00
------------------------------------
CREATE PROCEDURE PageTitle_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([PageId])+1 FROM [PageTitle]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[PageTitle_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [PageTitle_Exists]
GO
------------------------------------
--;ǷѾ 
--Ŀƣ
--˵
--ʱ䣺2013/4/29 11:20:00
------------------------------------
CREATE PROCEDURE PageTitle_Exists
@PageId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [PageTitle] WHERE PageId=@PageId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[PageTitle_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [PageTitle_ADD]
GO
------------------------------------
--;һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/29 11:20:00
------------------------------------
CREATE PROCEDURE PageTitle_ADD
@PageId int output,
@SiteId int,
@PageIdentity nvarchar(36),
@Title nvarchar(2000),
@OldTitle nvarchar(2000),
@TitleMainPart nvarchar(2000),
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [PageTitle](
	[SiteId],[PageIdentity],[Title],[OldTitle],[TitleMainPart],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@PageIdentity,@Title,@OldTitle,@TitleMainPart,@CreatedOn,@UpdatedOn
	)
	SET @PageId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[PageTitle_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [PageTitle_Update]
GO
------------------------------------
--;޸һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/29 11:20:00
------------------------------------
CREATE PROCEDURE PageTitle_Update
@PageId int,
@SiteId int,
@PageIdentity nvarchar(36),
@Title nvarchar(2000),
@OldTitle nvarchar(2000),
@TitleMainPart nvarchar(2000),
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [PageTitle] SET 
	[SiteId] = @SiteId,[PageIdentity] = @PageIdentity,[Title] = @Title,[OldTitle] = @OldTitle,[TitleMainPart] = @TitleMainPart,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE PageId=@PageId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[PageTitle_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [PageTitle_Delete]
GO
------------------------------------
--;ɾһ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/4/29 11:20:00
------------------------------------
CREATE PROCEDURE PageTitle_Delete
@PageId int
 AS 
	DELETE [PageTitle]
	 WHERE PageId=@PageId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[PageTitle_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [PageTitle_GetModel]
GO
------------------------------------
--;õʵϸϢ 
--Ŀƣ
--˵
--ʱ䣺2013/4/29 11:20:00
------------------------------------
CREATE PROCEDURE PageTitle_GetModel
@PageId int
 AS 
	SELECT 
	PageId,SiteId,PageIdentity,Title,OldTitle,TitleMainPart,CreatedOn,UpdatedOn
	 FROM [PageTitle]
	 WHERE PageId=@PageId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[PageTitle_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [PageTitle_GetList]
GO
------------------------------------
--;ѯ¼Ϣ 
--Ŀƣ
--˵
--ʱ䣺2013/4/29 11:20:00
------------------------------------
CREATE PROCEDURE PageTitle_GetList
 AS 
	SELECT 
	PageId,SiteId,PageIdentity,Title,OldTitle,TitleMainPart,CreatedOn,UpdatedOn
	 FROM [PageTitle]

GO


if exists (select * from dbo.sysobjects where id = object_id(N'[TranslateRule_GetMaxId]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TranslateRule_GetMaxId]
GO
------------------------------------
--;õֵֶ 
--Ŀƣ
--˵
--ʱ䣺2013/8/8 20:28:22
------------------------------------
CREATE PROCEDURE TranslateRule_GetMaxId
AS
	DECLARE @TempID int
	SELECT @TempID = max([RuleId])+1 FROM [TranslateRule]
	IF @TempID IS NULL
		RETURN 1
	ELSE
		RETURN @TempID

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TranslateRule_Exists]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TranslateRule_Exists]
GO
------------------------------------
--;ǷѾ 
--Ŀƣ
--˵
--ʱ䣺2013/8/8 20:28:22
------------------------------------
CREATE PROCEDURE TranslateRule_Exists
@RuleId int
AS
	DECLARE @TempID int
	SELECT @TempID = count(1) FROM [TranslateRule] WHERE RuleId=@RuleId 
	IF @TempID = 0
		RETURN 0
	ELSE
		RETURN 1

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TranslateRule_ADD]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TranslateRule_ADD]
GO
------------------------------------
--;һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/8/8 20:28:22
------------------------------------
CREATE PROCEDURE TranslateRule_ADD
@RuleId int output,
@SiteId int,
@Name nvarchar(100),
@TranslateUrl nvarchar(4000),
@RawUrlExtractExpression nvarchar(4000),
@RedirectExpression nvarchar(4000),
@OperationExpression nvarchar(4000),
@MatchUrl bit,
@Url nvarchar(2000),
@ExactMatch bit,
@Priority int,
@IsEnable bit,
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime

 AS 
	INSERT INTO [TranslateRule](
	[SiteId],[Name],[TranslateUrl],[RawUrlExtractExpression],[RedirectExpression],[OperationExpression],[MatchUrl],[Url],[ExactMatch],[Priority],[IsEnable],[IsDefault],[CreatedOn],[UpdatedOn]
	)VALUES(
	@SiteId,@Name,@TranslateUrl,@RawUrlExtractExpression,@RedirectExpression,@OperationExpression,@MatchUrl,@Url,@ExactMatch,@Priority,@IsEnable,@IsDefault,@CreatedOn,@UpdatedOn
	)
	SET @RuleId = @@IDENTITY

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TranslateRule_Update]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TranslateRule_Update]
GO
------------------------------------
--;޸һ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/8/8 20:28:22
------------------------------------
CREATE PROCEDURE TranslateRule_Update
@RuleId int,
@SiteId int,
@Name nvarchar(100),
@TranslateUrl nvarchar(4000),
@RawUrlExtractExpression nvarchar(4000),
@RedirectExpression nvarchar(4000),
@OperationExpression nvarchar(4000),
@MatchUrl bit,
@Url nvarchar(2000),
@ExactMatch bit,
@Priority int,
@IsEnable bit,
@IsDefault bit,
@CreatedOn datetime,
@UpdatedOn datetime
 AS 
	UPDATE [TranslateRule] SET 
	[SiteId] = @SiteId,[Name] = @Name,[TranslateUrl] = @TranslateUrl,[RawUrlExtractExpression] = @RawUrlExtractExpression,[RedirectExpression] = @RedirectExpression,[OperationExpression] = @OperationExpression,[MatchUrl] = @MatchUrl,[Url] = @Url,[ExactMatch] = @ExactMatch,[Priority] = @Priority,[IsEnable] = @IsEnable,[IsDefault] = @IsDefault,[CreatedOn] = @CreatedOn,[UpdatedOn] = @UpdatedOn
	WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TranslateRule_Delete]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TranslateRule_Delete]
GO
------------------------------------
--;ɾһ¼ 
--Ŀƣ
--˵
--ʱ䣺2013/8/8 20:28:22
------------------------------------
CREATE PROCEDURE TranslateRule_Delete
@RuleId int
 AS 
	DELETE [TranslateRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TranslateRule_GetModel]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TranslateRule_GetModel]
GO
------------------------------------
--;õʵϸϢ 
--Ŀƣ
--˵
--ʱ䣺2013/8/8 20:28:22
------------------------------------
CREATE PROCEDURE TranslateRule_GetModel
@RuleId int
 AS 
	SELECT 
	RuleId,SiteId,Name,TranslateUrl,RawUrlExtractExpression,RedirectExpression,OperationExpression,MatchUrl,Url,ExactMatch,Priority,IsEnable,IsDefault,CreatedOn,UpdatedOn
	 FROM [TranslateRule]
	 WHERE RuleId=@RuleId 

GO

if exists (select * from dbo.sysobjects where id = object_id(N'[TranslateRule_GetList]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [TranslateRule_GetList]
GO
------------------------------------
--;ѯ¼Ϣ 
--Ŀƣ
--˵
--ʱ䣺2013/8/8 20:28:22
------------------------------------
CREATE PROCEDURE TranslateRule_GetList
 AS 
	SELECT 
	RuleId,SiteId,Name,TranslateUrl,RawUrlExtractExpression,RedirectExpression,OperationExpression,MatchUrl,Url,ExactMatch,Priority,IsEnable,IsDefault,CreatedOn,UpdatedOn
	 FROM [TranslateRule]

GO