<% 
Class HiboClass
	private className
	Private Sub Class_Initialize
		className=""
	End Sub
	Public Function createObject(byval classStr)
		className=classStr:classname=replace(classname,".","_"):Execute("set createObject=new "&classname)
	End Function
	Private Sub Class_Terminate()
	End Sub
End Class

Function initializeAllObjects()
	dim errid,errdes
	on error resume next
	if not isobject(objFso) then set objFso=server.createobject(OBJ_FSO)
	    If Err Then errid=err.number:errdes=err.description:errline=err.Line:Err.Clear:ShowErr errline,Err_Msg(6),errid,errdes
	if not isobject(objStream) then Set objStream=Server.CreateObject(OBJ_Stream)
	    If Err Then errid=err.number:errdes=err.description:errline=err.Line:Err.Clear:ShowErr errline,Err_Msg(5),errid,errdes
End Function

Class HiboClass_Cache
	Public ReloadTime,CacheName:Private CacheData
Private Sub Class_Initialize()
    ReloadTime = Config(20):CacheName = "Hibocms_"
End Sub
Public Function SetCache(MyCacheName, vNewValue,ValueMakeFile)
    If MyCacheName <> ""  Then
        CacheData = Application(CacheName & MyCacheName)
        If Not IsArray(CacheData) Then  ReDim CacheData(2)
        'CacheData(0) = iif(ValueMakeFile,1,vNewValue):CacheData(1) = Now()
		'if ValueMakeFile Then Call MakeHtml (Config(0)&CacheDir&"/Application/"&md5(MyCacheName,16,False)&".html",vNewValue) 'ʱļ
		CacheData(0)=vNewValue:CacheData(1) = Now()
        Application.Lock
        Application(CacheName & MyCacheName) = CacheData
        Application.UnLock
        SetCache = True
    Else
        SetCache = False
    End If
End Function
Public Function GetCache(MyChacheName,ValueFormFile)
    If MyChacheName <> "" Then
        CacheData = Application(CacheName & MyChacheName)
        If IsArray(CacheData) Then
			'GetCache=iif(ValueFormFile,GetMoBan(Config(0)&CacheDir&"/Application/"&md5(MyChacheName,16,False)&".html",0),CacheData(0))
			GetCache=CacheData(0)
        Else
            GetCache = ""
        End If
    Else
        GetCache = ""
    End If
End Function
Public Function ChkCache(MyCacheName)
	ChkCache = False
    CacheData = Application(CacheName & MyCacheName)
    If Not IsArray(CacheData) Then Exit Function
    If Not IsDate(CacheData(1)) Then Exit Function
    If DateDiff("s", CDate(CacheData(1)), Now()) < 60 * ReloadTime Then ChkCache = True
End Function
Public Sub ClearCache(MyCacheName)
    Application.Lock:Application.Contents.Remove (CacheName & "_" & MyCacheName):Application.UnLock
End Sub
Public Sub ClearAll()
    Application.Lock():Application.Contents.RemoveAll():Application.UnLock()
End Sub
End Class

'************************************************************
Class HiboClass_DB
public dbConn,dbRs,isConnect,fetchCount,tablepre
private connStr,vqueryCount,vdbType
private errid,errdes

Private Sub Class_Initialize
	isConnect=false:vqueryCount=0:fetchCount=0
End Sub

Public Property Get queryCount
	queryCount=vqueryCount
End Property

Public Property Let dbType(byval pType)
	if pType="SQL" then vdbType=pType  else vdbType="ACCESS"
End Property

Private Sub getConnStr()
	if vdbType="SQL" then
        connStr=Provider_sql:connStr=Replace(connStr,"{SQL:File}",Config(6)):connStr=Replace(connStr,"{DB:Name}",Config(3)):connStr=Replace(connStr,"{DB:User}",Config(4)):connStr=Replace(connStr,"{DB:Pass}",Config(5))
	else
		connStr=Replace(Provider_acc,"{ACC:File}",server.mappath(Config(2)))
	end if
End Sub

Public Sub connect()
	getConnStr
	if isObject(dbConn)=false or isConnect=false then
		On Error Resume Next
		set dbConn=server.CreateObject(OBJ_Conn)
		dbConn.open connStr
		isConnect=true
		if Err then errid=Err.number:errdes=Err.description:errline=err.Line:Err.Clear:dbConn.close:set dbConn=nothing:isConnect=false:ShowErr errline,Err_Msg(1),errid,errdes
	end if
End Sub

Function db(byval sqlStr,byval sqlType)
  if not isConnect=true then connect
  On Error Resume Next
  sqlStr=replace(sqlStr,"{Pre}",Config(78))
  'echo sqlStr&"<br>"
  select case sqlType
  case "execute"
	  set db=dbConn.execute(sqlStr)
  case "records1"
	  set db=server.CreateObject(OBJ_Reco)
	  db.open sqlStr,dbConn,1,1
  case "records3"
	  set db=server.CreateObject(OBJ_Reco)
	  db.open sqlStr,dbConn,3,3
  case "array"
	  set dbRs=server.CreateObject(OBJ_Reco)
	  dbRs.open sqlStr,dbConn,1,1
	  if not dbRs.eof then
		  if fetchCount=0 then db=dbRs.getRows() else db=dbRs.getRows(fetchCount)
	  end if
	  dbRs.close:set dbRs=nothing
  end select
  vqueryCount=vqueryCount+1
  if Err then
	  errid=Err.number:errdes=Err.description:errline=err.Line:Err.Clear:dbConn.close:set dbConn=nothing:isConnect=false
	  ShowErr errline,Err_Msg(2),errid,errdes
  end if
End Function

Public Sub Class_Terminate()
	if isObject(dbRs) then set dbRs=nothing
	if isConnect then dbConn.close:set dbConn=nothing:isConnect=false
End Sub
End Class

Class HiboClass_Xml
	Public xmlDomObj,xmlstrm,CxmlFile
	Private xmlDomVer,xmlFileSavePath

Public Sub Class_Initialize()
	xmlDomVer=getXmlDomVer():createXmlDomObj
End Sub

Public Sub Class_Terminate()
	If IsObject(xmlDomObj) Then Set xmlDomObj=Nothing
End Sub

Public Function getXmlDomVer()
	dim i,xmldomVersions,xmlDomVersion,xmldomVersions_ls:xmldomVersions_ls=HiBoCache("xmldomVersions","","s","get")
	getXmlDomVer=false
	IF xmldomVersions_ls="" then 
		xmldomVersions=Array("Microsoft.2MLDOM","MSXML2.DOMDocument","MSXML2.DOMDocument.3.0","MSXML2.DOMDocument.4.0","MSXML2.DOMDocument.5.0")
		for i=0 to ubound(xmldomVersions)
			xmlDomVersion=xmldomVersions(i)
			if isInstallObj(xmlDomVersion) then 
				getXmlDomVer=xmlDomVersion:AiYa=HiBoCache("xmldomVersions",getXmlDomVer,"s","put"):Exit Function
			End if
		next
	Else
	getXmlDomVer=xmldomVersions_ls
	End if
End Function

Private Sub createXmlDomObj()
	set xmlDomObj=server.CreateObject(xmlDomVer)
	xmlDomObj.validateonparse=true 
	xmlDomObj.async=false 
End Sub

private sub savefile()
   xmlDomObj.save(CxmlFile)
end sub

Public Sub load(Byval xml,Byval xmlType)
  dim xmlstr,xmlUrl,xmlfilePath:CxmlFile=xml
  select case xmlType 
  case "xmlfile"
	xmlfilePath=server.mappath(xml)
	IF Not IsExists(xml) Then   Call MakeHtml(xml,"<?xml version=""1.0"" encoding=""GB2312"" ?>") 
	xmlDomObj.load(xmlfilePath)  
  case "xmlhttp"
	xmlstr=GetPage(xml,"")
	If left(xmlstr, 5) = "<?xml" then xmlDomObj.loadXML(xmlstr)
  case "transfer"
	xmlstr=xml
	If left(xmlstr, 5) = "<?xml" then  xmlDomObj.loadXML(xmlstr)
  end select
End Sub

Public Function isExistNode(nodename)
	dim node
	isExistNode=True
	set node=xmlDomObj.getElementsByTagName(nodename)
	If node.Length=0 Then isExistNode=False:set node=nothing
End Function

Public Function getNodeValue(nodename, itemId)
on error resume next
	if isNul(itemId) then itemId=0
	getNodeValue=xmlDomObj.getElementsByTagName(nodename).Item(itemId).Text
End Function

Public Function getNodeLen(nodename)
	getNodeLen=xmlDomObj.getElementsByTagName(nodename).Length
End Function

Public Function getNodes(nodename)
	Set getNodes=xmlDomObj.getElementsByTagName(nodename)
End Function

Public Function getNode(nodename, itemId)
	Set getNode=xmlDomObj.getElementsByTagName(nodename).Item(itemId)
End Function

Public Function getAttributes(nodeName, attrName, itemId)
dim xmlAttributes, i
	if isNul(itemId) then itemId=0
	err.clear:on error resume next
	getAttributes=xmlDomObj.getElementsByTagName(nodeName).Item(itemId).getAttributeNode(attrName).nodevalue
	if err then getAttributes="":err.clear
End Function

Public Function getAttributesByNode(node, attrName)
	err.clear:on error resume next
	getAttributesByNode=node.getAttributeNode(attrName).nodevalue
	if err then getAttributesByNode="":err.clear
End Function

Public Sub setXmlNodeValue(Byval nodename, Byval itemId, Byval str,Byval savePath)
dim node
on error resume next
	xmlFileSavePath=savePath
	IF xmlDomObj.getElementsByTagName(nodename).Length=0 Then 
		set   objheader   =   xmlDomObj.SelectSingleNode(Split(nodename,"/")(0)) 
        Set Node = xmlDomObj.createElement(Split(nodename,"/")(1))
        Node.Text = str
		objheader.appendChild   Node
	Else
		Set node=xmlDomObj.getElementsByTagName(nodename).Item(itemId)
		node.childNodes(0).text=str
	End if
		xmlDomObj.save Server.MapPath(xmlFileSavePath)
		set node=nothing
End Sub

End Class

Class HiboClass_Template
Public Content
Private CacheName,labelRule,regEx,Match,Matches,strDictionary,Mlistpagenums,Mlistpagecount,CMenuCount,DbFieldList

Public Sub Class_Initialize()
on error resume next  
	Set regEx = New RegExp:regEx.IgnoreCase = True:regEx.Global = True:set strDictionary=server.CreateObject("SCRIPTING.DICTIONARY")
	DbFieldList=" Movie_id,Movie_Source,class_id,Movie_Class_Expand,Movie_Name,Movie_Alias,Movie_Taglist,Movie_Actor,Movie_Director,Movie_Erea,Movie_Color,Movie_PicBig,Movie_PicSmall,Movie_Slide,Movie_ScoreNum,Movie_ScoreEr,Movie_subtitle,Movie_Intro,Movie_Extensible,Movie_LastTime,Movie_Play_Url,Movie_Play_Path,Movie_Hits,Movie_Elite,Movie_Year,Movie_Language,Movie_Reurl,Movie_Fav,Movie_PinYin,Movie_Order,Movie_Release,Movie_level,Movie_Md5	"

End Sub
	
Public Function OpenSkin(Byval MoBan_Path)
dim attr,includestr
  Content = GetSkinCache(MoBan_Path)
  IF Instr(Content,"{hibocms:include")>0 then
	regEx.Pattern =  "(<!--|){hibocms:include([\s\S]*?)}(-->|)"
	Set Matches = regEx.Execute(Content)
	For Each Match In Matches
		set attr=parseAttr(Match.SubMatches(1)):includestr=attr("filename")
		Content = ReplaceStr(Content,Match.value,GetSkinCache(Config(0)&"Skin/"&Config(12)&"/"&Config(11)&"/"&includestr))
	Next:Set matches = Nothing										
  End IF
End Function
	
Public Function OpenAll()
dim attr,ListAll(2)
  Content = ReplaceStr(Content,"{$site.author}",HB_SYS(1))
  Content = ReplaceStr(Content,"{$site.ver}",HB_SYS(2))
  Content = ReplaceStr(Content,"{$site.year}",year(now()))
  Content = ReplaceStr(Content,"{$site.install}",Config(0))
  Content = ReplaceStr(Content,"{$site.name}",Config(8))
  Content = ReplaceStr(Content,"{$site.domain}",Config(9))
  Content = ReplaceStr(Content,"{$site.email}",Config(18))	
  Content = ReplaceStr(Content,"{$site.keyword}",Config(15))
  Content = ReplaceStr(Content,"{$site.description}",Config(16))
  Content = ReplaceStr(Content,"{$site.copyright}",Config(13))
  Content = ReplaceStr(Content,"{$site.tong}",Config(14))
  Content = ReplaceStr(Content,"{$site.beian}",Config(10))
  Content = ReplaceStr(Content,"{$site.qvod.channel}","qvodcha://"&Config(8)&"|"&Config(9)&"/Channel.xml")
  Content = ReplaceStr(Content,"{$site.qvod.add}","qvodadd://"&Config(8)&"|http://"&Config(9)&"")
  Content = ReplaceStr(Content,"{$site.template}",Config(0)&"skin/"&Config(12)&"/")
  IF Instr(Content,"{$site.hibosite}")>0 THEN Content = ReplaceStr(Content,"{$site.hibosite}",Instrurl(HB_SYS(4)))
  IF Instr(Content,"{$site.advertere}")>0 THEN Content = ReplaceStr(Content,"{$site.advertere}",GetSiteUnionPath(54))
  IF Instr(Content,"{$site.special.url}")>0 THEN Content = ReplaceStr(Content,"{$site.special.url}",GetSpecial("U","index",1))
  IF Instr(Content,"{$site.special.list}")>0 THEN Content = ReplaceStr(Content,"{$site.special.list}",GetSpecial("U","lists",1))
  IF Instr(Content,"{$site.comment.url}")>0 THEN Content = ReplaceStr(Content,"{$site.comment.url}",GetCommentLink(1))
  IF Instr(Content,"{$site.news.url}")>0 THEN Content = ReplaceStr(Content,"{$site.news.url}",GetNews("U","index",0,1))
  IF Instr(Content,"{$site.backurl}")>0 THEN Content = ReplaceStr(Content,"{$site.backurl}",reurl)
  IF Instr(Content,"{$site.randomstr}")>0 THEN Content = ReplaceStr(Content,"{$site.randomstr}",GetRandomWord(16))

  M_MaxClass=M_Int(GetMaxClassID(List_Id),0)
  	Content = ReplaceStr(Content,"{$site.channel.movie(0)}",M_MaxClass)
  	Content = ReplaceStr(Content,"{$site.channel.movie(1)}",List_Id)
	
  IF Instr(Content,"{hibocms:mytag")>0 then
	regEx.Pattern =  "{hibocms:mytag(.*?)}"
	Set Matches = regEx.Execute(Content)
	For Each Match In Matches
	Set attr=parseAttr(Match.SubMatches(0)):ListAll(0)=attr("name")
		Content=ReplaceStr(Content,Match.value,IIF(ListAll(0)="","Զǩ",GetMoBan(Config(0)&CacheDir&"/label/"&md5(ListAll(0),16,False)&".html",0) ))
	Next:Set matches = Nothing										
  End IF

  IF Instr(Content,"{menucss.")>0 then
	regEx.Pattern = "\{menucss\.(.*?)\}(.*?){\/menucss\}"
	Set Matches = regEx.Execute(Content)
	For Each Match In Matches
		Content=ReplaceStr(Content,Match.value,iif(SiteChannel=Match.SubMatches(0),Match.SubMatches(1),""))
	Next:Set matches = Nothing
  End IF
  
  IF Instr(Content,"{hibocms:count(")>0 then
	regEx.Pattern = "\{hibocms:count\(([\s\S]*?)\)}"
	Set Matches = regEx.Execute(Content)
	For Each Match In Matches
		Content=ReplaceStr(Content,Match.value,GetTongJi(Cint(Match.SubMatches(0))))
	Next:Set matches = Nothing
  End IF
  
  IF Instr(Content,"{hibocms:link")>0 then
	regEx.Pattern =  "(<!--|){hibocms:link(.*?)\}(-->|)([\s\S]*?)(<!--|){\/hibocms:link}(-->|)"
	Set Matches = regEx.Execute(Content)
	For Each Match In Matches
		Content=ReplaceStr(Content,Match.value,GetLink(Match.SubMatches(1),Match.SubMatches(3)))
	Next:Set matches = Nothing
  End IF

'/////////////////////////////////////////////////////////////////////ȱǩ ɾ
  IF Instr(Content,"{hibocms:menu ")>0 then
	regEx.Pattern =  "\{hibocms:menu (.*?)\}([\s\S]*?){\/hibocms:menu}"
	Set Matches = regEx.Execute(Content)
	For Each Match In Matches
		Content=ReplaceStr(Content,Match.value,GetMenu(Match.SubMatches(0),Match.SubMatches(1)))
	Next:Set matches = Nothing										
  End IF
 
  IF Instr(Content,"{hibocms:menubig")>0 then
	regEx.Pattern =  "(<!--|){hibocms:menubig(.*?)\}(-->|)([\s\S]*?)(<!--|){\/hibocms:menubig}(-->|)"
	Set Matches = regEx.Execute(Content)
	For Each Match In Matches
		Content=ReplaceStr(Content,Match.value,GetMenuList(Match.SubMatches(1),Match.SubMatches(3),"big"))
	Next:Set matches = Nothing										
  End IF
 
  IF Instr(Content,"{hibocms:menusmall")>0 then
	regEx.Pattern =  "(<!--|){hibocms:menusmall(.*?)\}(-->|)([\s\S]*?)(<!--|){\/hibocms:menusmall}(-->|)"
	Set Matches = regEx.Execute(Content)
	For Each Match In Matches
		Content=ReplaceStr(Content,Match.value,GetMenuList(Match.SubMatches(1),Match.SubMatches(3),"small"))
	Next:Set matches = Nothing										
  End IF
 
 
  IF Instr(Content,"{hibocms:newschannel")>0 then
	regEx.Pattern =  "(<!--|){hibocms:newschannel(.*?)\}(-->|)([\s\S]*?)(<!--|){\/hibocms:newschannel}(-->|)"
	Set Matches = regEx.Execute(Content)
	For Each Match In Matches
		Content=ReplaceStr(Content,Match.value,GetNewsChannel(Match.SubMatches(1),Match.SubMatches(3)))
	Next:Set matches = Nothing										
  End IF
End Function

Public Function Gettaglist(ContentStr)
Dim attr,ListAll(3)
  IF Instr(Content,"{hibocms:taglist")>0 then
	regEx.Pattern ="(<!--|){hibocms:taglist(.*?)\}(-->|)([\s\S]*?)(<!--|){\/hibocms:taglist}(-->|)"
	Set Matches = regEx.Execute(Content)
	  For Each Match In Matches
		Set attr=parseAttr(Match.SubMatches(1)):ListAll(0)=M_int(attr("num"),0):ListAll(1)=attr("type"):ListAll(2)=attr("keywords"):ListAll(3)=attr("currentstyle")
		Select Case ListAll(1)
		Case "hotkey"     
			Content = ReplaceStr(Content,Match.value,GetSearchList(Match.SubMatches(3),"name",43,ListAll(2),ListAll(0),ListAll(3)))
		Case "tagkey"     
			Content = ReplaceStr(Content,Match.value,GetSearchList(Match.SubMatches(3),"tagkey",43,ListAll(2),ListAll(0),ListAll(3)))
		Case "year" 
			Content = ReplaceStr(Content,Match.value,GetSearchList(Match.SubMatches(3),"year",42,ListAll(2),ListAll(0),ListAll(3)))
		Case "letter" 
			Content = ReplaceStr(Content,Match.value,GetSearchList(Match.SubMatches(3),"letter",58,ListAll(2),ListAll(0),ListAll(3)))
		Case "language" 
			Content = ReplaceStr(Content,Match.value,GetSearchList(Match.SubMatches(3),"language",41,ListAll(2),ListAll(0),ListAll(3)))
		Case "area" 
			Content = ReplaceStr(Content,Match.value,GetSearchList(Match.SubMatches(3),"area",40,ListAll(2),ListAll(0),ListAll(3)))
		Case "actor" 
			Content = ReplaceStr(Content,Match.value,GetSearchList(Match.SubMatches(3),"actor",43,ListAll(2),ListAll(0),ListAll(3)))
		Case "director" 
			Content = ReplaceStr(Content,Match.value,GetSearchList(Match.SubMatches(3),"director",43,ListAll(2),ListAll(0),ListAll(3)))
		End Select 
	  Next:Set matches = Nothing
  End IF
End Function

Public Function GetMenuList(strtype,strlist,StrClass)
	    Dim attr,ListAll(4):CMenuCount=0
		Dim NumI,Menu_i_0,Menu_i_1,Menu_Html:Menu_Html="":NumI=0
		If Strtype="" Then GetMenuList=Err_Msg(19):Exit Function
     	Set attr=parseAttr(Strtype)
		ListAll(1)=attr("ids")
		ListAll(2)=attr("type")
		ListAll(3)=attr("currentstyle")
    M_MaxClass=M_Int(GetMaxClassID(List_Id),-1)'ǰ
	   For i=1 to  UBound(menu)
	        Menu_i_0=Split(Menu(i),"|")(0)
			Menu_i_1=Split(Menu(i),"|")(1)
			if StrClass="big" then
			    if ListAll(1)="" Then   
			      if Menu_i_1="0" then NumI=NumI+1:Menu_Html=Menu_Html&GetMenuHtml(NumI,StrClass,strlist,i,M_MaxClass,List_Id,ListAll(3))
			    else
			      if instr(","&ListAll(1)&",",","&Menu_i_0&",")>0 then NumI=NumI+1:Menu_Html=Menu_Html&GetMenuHtml(NumI,StrClass,strlist,i,M_MaxClass,List_Id,ListAll(3))
				end if
			else
			   if ListAll(1)="-1" then
			          if M_Int(Menu_i_1,0)=M_MaxClass then NumI=NumI+1:Menu_Html=Menu_Html&GetMenuHtml(NumI,StrClass,strlist,i,M_MaxClass,List_Id,ListAll(3))
			   elseif ListAll(1)="0" or ListAll(1)="" then
			          if Menu_i_1<>"0" then NumI=NumI+1:Menu_Html=Menu_Html&GetMenuHtml(NumI,StrClass,strlist,i,M_MaxClass,List_Id,ListAll(3))
			   elseif ListAll(2)="big" then
			          if Menu_i_1=ListAll(1) then NumI=NumI+1:Menu_Html=Menu_Html&GetMenuHtml(NumI,StrClass,strlist,i,M_MaxClass,List_Id,ListAll(3))
			   elseif ListAll(2)="" then
			          if instr(","&ListAll(1)&",",","&Menu_i_0&",")>0 then NumI=NumI+1:Menu_Html=Menu_Html&GetMenuHtml(NumI,StrClass,strlist,i,M_MaxClass,List_Id,ListAll(3))
			   end if
			end if
	   next
	Menu_Html=Replace(Menu_Html,"{$menu"&StrClass&".count}",CMenuCount)   
	GetMenuList=Menu_Html
End Function

'/////////////////////////////////////////////////////////////////////ȱǩ ɾ
Public Function GetMenu(strtype,strlist)
	    Dim attr,ListAll(4),NowClass,sql
		Dim RsArray,Menu_Html,Lits_Html,Class_bigid,WhereStr:Menu_Html=""
		If Strtype="" Then GetMenu=Err_Msg(19):Exit Function
		
		set attr=parseAttr(Strtype)
		ListAll(1)=attr("max"):if ( ListAll(1)="") then ListAll(1)=0'
		ListAll(2)=attr("mix"):if ( ListAll(2)="") then ListAll(2)=0'
		ListAll(3)=attr("currentstyle")
		ListAll(4)=attr("ids")
	
	NowClass=M_Int(GetMaxClassID(List_Id),-1)'ǰ
	
    IF 		M_int(ListAll(1),0)=-1 then 
			WhereStr="class_bigid =0" 'д
    ELSEIF  M_int(ListAll(2),0)=-1 then 
			WhereStr="class_bigid <>0" 'С
    ELSEIF  M_int(ListAll(1),-1)=0 and M_int(ListAll(2),-1)=0 then 
			WhereStr="class_bigid ="&nowclass 'С
    ELSEIF  M_int(ListAll(1),-1)>0 or instr(ListAll(1),",")>0 then 
		   IF ListAll(2)=1 then
		      WhereStr="class_bigid in("&ListAll(1)&")" 'ָС
		   Else
		      WhereStr="class_id in("&ListAll(1)&")"    'ָ
		   End IF
    ELSE
		   WhereStr="class_id in("&ListAll(2)&")" 'ָС
    End IF
     
	sql="Select class_id,class_name,class_dir from {Pre}HiboCms_class where  "&WhereStr&" and class_show="&SqlBit(1)&"  order by class_orderid asc"
	set rs = HiConn.DB(sql,"records1")
	'Response.Write(NowClass&"<br>")
	If Not(rs.bof And rs.eof) Then
	   RsArray = rs.GetRows()
	   Dim UBoundrsArray:UBoundrsArray=UBound(rsArray,2)
	   For i=0 to  UBoundrsArray
		Lits_Html=ReplaceStr(strlist,"{$menu.number}",i+1)
		Lits_Html=ReplaceStr(Lits_Html,"{$menu.count}",UBoundrsArray)
		Lits_Html=ReplaceStr(Lits_Html,"{$menu.id}",rsArray(0,i))
		Lits_Html=ReplaceStr(Lits_Html,"{$menu.name}",rsArray(1,i))
		Lits_Html=ReplaceStr(Lits_Html,"{$menu.name.eng}",rsArray(2,i))
		Lits_Html=ReplaceStr(Lits_Html,"{$menu.link}",GetListLink("U",rsArray(0,i),1,"S"))
		If Instr(Lits_Html,"{$menu.currentstyle}")>0 Then
			If List_Id=rsArray(0,i) or NowClass=rsArray(0,i) Then 
				Lits_Html=ReplaceStr(Lits_Html,"{$menu.currentstyle}",iif(SiteChannel="movie" or SiteChannel="search",ListAll(3),""))
			Else
				Lits_Html=ReplaceStr(Lits_Html,"{$menu.currentstyle}","")
			End If
		End If
		Menu_Html=Menu_Html&Lits_Html
	   next 
	End If
	rs.close:Set rs=nothing
GetMenu=Menu_Html
End Function
'/////////////////////////////////////////////////////////////////////ȱǩ ɾ

Public Function IF_Replace(Replace_Str)
If StrContent<>"" Then Content=StrContent
Dim IfReplaceStr:IfReplaceStr=Replace_Str
  On Error Resume Next
  Dim CheckIf,CheckValue,TrueValue,FalseValue
  regEx.Pattern = "(<!--|){if:(.+?)}(-->|)([\s\S]*?)(<!--|){end if}(-->|)":Set Matches = regEx.Execute(Content)
  For Each Match In Matches
	CheckValue=Match.SubMatches(3)		
	If Instr(LCase(CheckValue),"{else}")>0 Then
	   CheckValue=replace(CheckValue,"<!--{else}","{else}",1,-1,1):CheckValue=replace(CheckValue,"{else}-->","{else}",1,-1,1)
	   TrueValue=Split(CheckValue,"{else}")(0):FalseValue=Split(CheckValue,"{else}")(1)
	Else
	   TrueValue=CheckValue:FalseValue=""
	End If
	Execute ("If " & replace(Match.SubMatches(1),"'","""") & " Then CheckIf = True Else CheckIf = False")
	If CheckIf Then Content = Replace(Content,Match.Value, TrueValue) Else Content = Replace(Content, Match.Value, FalseValue)
  Next
  	If Err  Then  Err.Clear
End Function

Public Function GetNewsChannel(strtype,strlist)
  Dim i,attr,ListAll(3),NowClass,sql
  Dim NewsChannel_i_0,ChannelStr,ChannellistStr
  set attr=parseAttr(Strtype)
  ListAll(1)=attr("currentstyle")
  ListAll(2)=attr("class"):if ListAll(2)="" then ListAll(2)=0
  For i=1 to UBound(NewsChannel)
  	  NewsChannel_i_0=Split(NewsChannel(i),"|")(0)
	  if ListAll(2)=0 or instr(","&ListAll(2)&",",","&NewsChannel_i_0)&",">0   then
	  ChannellistStr=strlist
	  ChannellistStr=replace(ChannellistStr,"{$newschannel.link}",GetNews("U","lists",NewsChannel_i_0,1))
	  ChannellistStr=replace(ChannellistStr,"{$newschannel.name}",Split(NewsChannel(i),"|")(2))
	  ChannellistStr=replace(ChannellistStr,"{$newschannel.currentstyle}",iif(M_int(NewsChannel_i_0,0)=newslist,ListAll(1),""))
	  ChannellistStr=replace(ChannellistStr,"{$newschannel.id}",NewsChannel_i_0)
	  ChannelStr=ChannelStr&ChannellistStr
	  End if
  Next
GetNewsChannel=	ChannelStr
End Function

Public Function OpenHiboCmsNewsList(StrContent)
  If StrContent<>"" Then Content=StrContent
  IF Instr(Content,"{hibocms:newslist")>0 then
  regEx.Pattern =  "(<!--|){hibocms:newslist(.*?)}(-->|)([\s\S]*?)(<!--|){\/hibocms:newslist}(-->|)"
  Set Matches = regEx.Execute(Content)
  For Each Match In Matches
	  Content=ReplaceStr(Content,Match.value,GetListNews(Match.SubMatches(1),Match.SubMatches(3)))
  Next:Set matches = Nothing
  Content=ReplaceStr(Content,"{$newslist.page.num}",CurrentPage)
  Content=ReplaceStr(Content,"{$newslist.page}",PageStr)
  Content=ReplaceStr(Content,"{$newslist.class.name}",GetNewsClass(newslist,2))
  End IF
End Function
	
Public Function GetListNews(Strtype,StrContent)
dim i:i=1
  on error resume next
  Dim limit,num,attr,SqlWhere,orderStr,ListAll(5),TopStr,List_Html:List_Html="":i=0
  If Strtype="" Then GetListNews=Err_Msg(19):Exit Function
  set attr=parseAttr(Strtype)
  num=attr("num")&",0"
  limit=M_int(Split(num,",")(1),0) 
  ListAll(0)=M_int(Split(num,",")(0),10)
    
  ListAll(1)=attr("class"):if ListAll(1)="" or ListAll(1)="-1"  then  ListAll(1)=M_int(newslist,0)
  ListAll(2)=attr("ids"):
  ListAll(3)=C_Bool(attr("showpage"))
  ListAll(4)=attr("order")
	select case ListAll(4)
	case "id":orderStr =" order by News_id desc"
	case "time":orderStr =" order by News_datetimes desc"
	case "hits":orderStr =" order by News_Hits desc"
	end select
  ListAll(5)=attr("flag")
	select case ListAll(5)
	case "elite":SqlWhere=SqlWhere&SqlFormat(SqlWhere,"where","and")&" News_Reco="&SqlBit(1)
	end select		
  If ListAll(1)<>0 then    SqlWhere=SqlWhere&SqlFormat(SqlWhere,"where","and")&" News_Class in ("&ListAll(1)&")" 
  If ListAll(2)<>"0" and ListAll(2)<>"" then SqlWhere=SqlWhere&SqlFormat(SqlWhere,"where","and")&" News_id in ("&sqlin(ListAll(2))&")" 
  If ListAll(0)=0 or ListAll(3)=True    Then TopStr="" Else TopStr="Top "&ListAll(0)&"" End If
  Set rs = Server.CreateObject(OBJ_Reco)
  Sql = "select "&TopStr&" * From {Pre}HiboCms_News "&SqlWhere&orderStr
  set rs = HiConn.DB(sql,"records1")
  
  List_Html=""
  If Not(rs.bof And rs.eof) Then
	i=0
	If ListAll(3) Then
	  rs.pagesize=ListAll(0)
	  rs.AbsolutePage=CurrentPage
	  m=rs.recordcount
	  n=rs.PageCount
	  z=rs.pagesize
	  Do while not rs.eof and i<rs.pagesize
	  	  List_str=GetHtmlNews(StrContent,i+1,ListAll(2))
	  	  List_Html=List_Html&List_str	
	  	  i=i+1
	  rs.movenext
	  Loop
	  PageStr=PageShow(GetNews("U","lists",newslist,"{page}"), m, ListAll(0), CurrentPage, True, False, "", False,1)
	Else
	  Do while not rs.eof and i<ListAll(0)
	  	  if i>=limit then
	  	  List_str=GetHtmlNews(StrContent,i+1,ListAll(2))
	  	  List_Html=List_Html&List_str	
	  	  end if
	  	  i=i+1
		rs.movenext
	  Loop
	End If
 Else
	  List_Html="<li>"&Err_Msg(25)&"</li>"
 End If
 rs.Close:Set rs=nothing
GetListNews=List_Html
IF Err Then errid=err.number:errdes=err.description::errline=err.Line:Err.Clear:ShowErr errline,Err_Msg(2),errid,errdes
End Function

Public Function  GetHiboCmsNewsData(StrContent)
  sql = " select * From {Pre}HiboCms_News where News_id="&newsid&" "
  set rs = HiConn.DB(sql,"execute")
	If Not(rs.bof And rs.eof) Then
		set rs2 = HiConn.DB("update {Pre}HiboCms_News Set News_Hits=News_Hits+1 where News_id="&newsid,"execute"):Content=GetHtmlNews(StrContent,1,150)
	Else
		ShowErr "",Err_Msg(30),"DB0000",Err_Msg(25)
	End If
  rs.Close:Set rs=nothing
End Function 

Public Function GetHtmlNews(strList,listnum,StrNum)
  dim List_str,RSContent
  RSContent=rs("News_Content")
  List_str=ReplaceStr(strList,"{$news.number}",listnum)
  List_str=ReplaceStr(List_str,"{$news.id}",rs("News_id"))
  For sss=1 to 7 
	  List_str=ReplaceStr(List_str,"{$news.time."&sss&"}",HiboCMS_Time(rs("News_datetimes"),sss))
  next
  List_str=ReplaceStr(List_str,"{$news.title}",rs("News_Title"))
  List_str=ReplaceStr(List_str,"{$news.title.style}",GetColor(rs("News_Title"),rs("News_color")))
  List_str=ReplaceStr(List_str,"{$news.url}",GetNews("U","details",rs("News_Class"),rs("News_id")))  
  List_str=ReplaceStr(List_str,"{$news.hits}",rs("News_hits"))
  List_str=ReplaceStr(List_str,"{$news.content}",RSContent)
  List_str=ReplaceStr(List_str,"{$news.author}",rs("News_Author"))
  List_str=ReplaceStr(List_str,"{$news.from}",rs("News_From"))
  List_str=ReplaceStr(List_str,"{$news.img}",iif(trim(rs("News_Image"))="","",Config(55)&GetSiteUnionPath(53)&Trim(rs("News_Image"))))
  List_str=ReplaceStr(List_str,"{$news.class.name}",GetNewsClass(rs("News_Class"),2))
  List_str=ReplaceStr(List_str,"{$news.class.id}",rs("News_Class"))
  
  IF Instr(List_str,"{$news.content(")>0 Then
  RegEx.Pattern = "{\$news.content\(([\s\S]*?)\)}":Set Matches = regEx.Execute(List_str)
  For Each Match In Matches
	  List_str=ReplaceStr(List_str,Match.value,GetSubStr(FormatallHtml(RSContent,true),M_int(Match.SubMatches(0),100),True))
  Next:Set matches = Nothing
  End if 
  
  
  GetHtmlNews=List_str
End Function 

Public Function OpenHiboCmsSpecialList(StrContent)
  If StrContent<>"" Then Content=StrContent
  IF Instr(Content,"{hibocms:speciallist")>0 then
  regEx.Pattern = "(<!--|){hibocms:speciallist(.*?)}(-->|)([\s\S]*?)(<!--|){\/hibocms:speciallist}(-->|)"
  Set Matches = regEx.Execute(Content)
  For Each Match In Matches
  	Content=ReplaceStr(Content,Match.value,GetListSpecial(Match.SubMatches(1),Match.SubMatches(3)))
  Next:Set matches = Nothing
  Content=ReplaceStr(Content,"{$speciallist:page:num}",CurrentPage)
  Content=ReplaceStr(Content,"{$speciallist:page}",PageStr)
  End IF
End Function	
	
Public Function GetListSpecial(Strtype,StrContent) 
dim List_str,attr,i,Sql,orderStr,SqlWhere,ListAll(3),TopStr,List_Html:List_Html=""
	If Strtype="" Then GetListSpecial=Err_Msg(19):Exit Function
	set attr=parseAttr(Strtype)
	ListAll(0)=m_int(attr("num"),0):if ListAll(0)=0 then ListAll(0)=10
	ListAll(1)=attr("ids"):if ListAll(1)="" then ListAll(1)="0"
	ListAll(2)=C_Bool(attr("showpage"))
	ListAll(3)=attr("order")
	  select case ListAll(3)
		  case "id":orderStr =" order by Special_id desc"
		  case "time":orderStr =" order by Special_Time desc"
		  case "hits":orderStr =" order by Special_hits desc"
	  end select
	If ListAll(0)=0 or ListAll(2) Then TopStr="" Else TopStr="Top "&ListAll(0)&"" End If
	if ListAll(1)<>0 then SqlWhere=" Where Special_id in("&ListAll(1)&")" 
	Sql = "select "&TopStr&" * From {Pre}HiboCms_Special "&SqlWhere&orderStr
	set rs = HiConn.DB(sql,"records1")
	List_Html=""
	If Not(rs.bof And rs.eof) Then
	  i=0
	If ListAll(2) Then
		rs.pagesize=ListAll(0)
		rs.AbsolutePage=CurrentPage
		m=rs.recordcount
		n=rs.PageCount
		z=rs.pagesize
		Do while not rs.eof and i<rs.pagesize
			List_str=GetHtmlSpecial(StrContent,i+1,ListAll(1))
			List_Html=List_Html&List_str	
			i=i+1
		rs.movenext:Loop
		PageStr=PageShow(GetSpecial("U","lists","{page}"), m, ListAll(0), CurrentPage, True, True, "", False,1)
	 Else
		Do while not rs.eof
			List_str=GetHtmlSpecial(StrContent,i+1,ListAll(1))
			List_Html=List_Html&List_str	
			i=i+1
		rs.movenext:Loop
	 End If
   Else
		List_Html="<li>"&Err_Msg(25)&"</li>"
   End If
   rs.Close:Set rs=nothing
GetListSpecial=List_Html
End Function

Public Function  GetHiboCmsSpecialData(StrContent)
  set rs = HiConn.DB("select * From {Pre}HiboCms_Special where Special_id="&Specialid,"records1")
	If Not(rs.bof And rs.eof) Then
	Content=GetHtmlSpecial(StrContent,1,150)
  Else
	ShowErr "",Err_Msg(30),"DB0000",Err_Msg(25)
  End If
  rs.Close:Set rs=nothing
End Function 

Public Function GetHtmlSpecial(strList,listnum,StrNum)
  On Error Resume Next
  Dim RSid,RSContent,RSmovieIds,RSnewsIds
  RSid=rs("Special_id")
  RSContent=rs("Special_Content")
  RSmovieIds=HiboCms_Trim(rs("Special_Movie"))
  RSnewsIds =HiboCms_Trim(rs("Special_News"))
  List_str=ReplaceStr(strList, "{$special.number}",listnum)
  List_str=ReplaceStr(List_str,"{$special.id}",RSid)
  For sss=1 to 7 
  	List_str=ReplaceStr(List_str,"{$special.time."&sss&"}",HiboCMS_Time(rs("Special_Time"),sss))
  next
  List_str=ReplaceStr(List_str,"{$special.title}",rs("Special_Title"))
  List_str=ReplaceStr(List_str,"{$special.url}",GetSpecial("U","details",RSid))
  List_str=ReplaceStr(List_str,"{$special.logo}",GetSiteUnionPath(53)&rs("Special_logo"))
  List_str=ReplaceStr(List_str,"{$special.banner}", iif(trim(rs("Special_Banner"))="","",GetSiteUnionPath(53)&rs("Special_Banner")))
  List_str=ReplaceStr(List_str,"{$special.content}",RSContent)
  List_str=ReplaceStr(List_str,"{$special.movie}",iif(RSmovieIds="","-1",replace(RSmovieIds,",","|")))
  List_str=ReplaceStr(List_str,"{$special.news}", iif(RSnewsIds="","-1",RSnewsIds))
  
  IF Instr(List_str,"{$special.content(")>0 Then
  RegEx.Pattern = "{\$special.content\(([\s\S]*?)\)}":Set Matches = regEx.Execute(List_str)
  For Each Match In Matches
	  List_str=ReplaceStr(List_str,Match.value,GetSubStr(FormatallHtml(RSContent,true),M_int(Match.SubMatches(0),100),True))
  Next:Set matches = Nothing
  End if 
  
  GetHtmlSpecial=List_str
End Function 	
	
Public Function OpenHiboCmsMovieList(StrContent)
  If StrContent<>"" Then Content=StrContent
  if Instr(Content,"{hibocms:movielist")>0 Then
  regEx.Pattern = "(<!--|){hibocms:movielist(.*?)}(-->|)([\s\S]*?)(<!--|){\/hibocms:movielist}(-->|)"
  Set Matches = regEx.Execute(Content)
  For Each Match In Matches
	  Content=ReplaceStr(Content,Match.value,GetMovieList(Match.SubMatches(1), Match.SubMatches(3)))'
  Next:Set matches = Nothing
  Content=ReplaceStr(Content,"{$movielist.class.id}",List_Id)
  Content=ReplaceStr(Content,"{$movielist.class.name}",GetClassName(List_Id,2))
  Content=ReplaceStr(Content,"{$movielist.class.eng}",GetClassName(List_Id,4))
  Content=ReplaceStr(Content,"{$movielist.class.url}",GetListLink("U",List_Id,1,"S"))
  Content=ReplaceStr(Content,"{$movielist.class.keywords}",trim(GetClassName(List_Id,10)))
  Content=ReplaceStr(Content,"{$movielist.class.description}",trim(GetClassName(List_Id,11)))
  Content=ReplaceStr(Content,"{$movielist.page}",PageStr)
  Content=ReplaceStr(Content,"{$movielist.page.num}",CurrentPage)
  Content=ReplaceStr(Content,"{$movielist.page.nums}",Mlistpagenums)
  Content=ReplaceStr(Content,"{$movielist.page.count}",Mlistpagecount)
  Content=ReplaceStr(Content,"{$movielist.ranks}",GetRanks(Ranks))
  End if
End Function

Public Function GetMovieList(Strtype,StrContent)
  Dim List_str,limit,num,sql,attr,ListAll(11),TopStr,L1,WhereStr,EliteStr,ContinuStr,List_Html:List_Html="":WhereStr=" where Movie_Status="&SqlBit(1)
  If Strtype="" Then GetMovieList=Err_Msg(19):Exit Function
  set attr=parseAttr(Strtype)  
  num=attr("num")&",0"
  limit=M_int(Split(num,",")(1),0) 
  ListAll(0)=M_int(Split(num,",")(0),0)
  ListAll(1)=attr("ids")
  ListAll(2)=attr("class")
  ListAll(3)=attr("flag")
  ListAll(4)=""
  ListAll(5)=C_Bool(attr("showpage"))
  ListAll(6)=M_int(attr("date"),0)
  ListAll(7)=attr("order")
  ListAll(8)=M_int(attr("level"),0)
  ListAll(9)=M_int(attr("year"),0)
  ListAll(10)=attr("release")
  ListAll(11)=attr("actor")
  
  If Instr(ListAll(2),",")>0 Then 
	  WhereStr=WhereStr&SqlFormat(WhereStr,"where","and")&"class_id in("&SqlIn(ListAll(2))&")"
  Else
	 If M_int(ListAll(2),0)=-1 Then ListAll(2)=M_int(list_id,0)'ǰ
	 If M_int(ListAll(2),0)=0 Then  WhereStr=WhereStr Else WhereStr=WhereStr&SqlFormat(WhereStr,"where","and")&"class_id in ("&iif(GetClassName(ListAll(2),1)=0,sqlin(GetClassName(ListAll(2),6)&",998877"),ListAll(2))&")"&iif(Config(73)="1","","") End If
     If Config(73)="100" Then 
  		If Config(1)="SQL" Then ExpandClass=" or movie_class_expand like '%"&SqlIn(M_int(list_id,0))&"%'" Else ExpandClass=" or InStr(1,LCase(movie_class_expand),LCase('"&SqlIn(M_int(list_id,0))&"'),0)<>0"
	 	WhereStr =WhereStr&ExpandClass
	 End if
  End If	
  IF ListAll(8)>0 Then	WhereStr=WhereStr&SqlFormat(WhereStr,"where","and")&"Movie_level="&ListAll(8)
  IF ListAll(9)>0 Then	WhereStr=WhereStr&SqlFormat(WhereStr,"where","and")&"Movie_Year=" &ListAll(9)
  
  IF instr(ListAll(11),"|")>1 or instr(ListAll(11),"actor")>1 or instr(ListAll(11),"director")>0  then
     dim actorType,actorValue:actorType=Split(ListAll(11),"|")(0):actorValue=Split(ListAll(11),"|")(1)
	 WhereStr=WhereStr&SqlFormat(WhereStr,"where","and")&IIF(Config(1)="SQL"," Movie_"&actorType&" like '%"&actorValue&"%' "," InStr(1,LCase(Movie_"&actorType&"),LCase('"&actorValue&"'),0)<>0 ")
  End if
  IF ListAll(6)<>0 Then	
	 If Config(1)="SQL" Then
	 	WhereStr=WhereStr&SqlFormat(WhereStr,"where","and")&"Movie_LastTime>='"&(date()-ListAll(6))&"'"'"
	 Else
	 	WhereStr=WhereStr&SqlFormat(WhereStr,"where","and")&"DateDiff('d',Movie_LastTime,#"&HiboCMS_Time(now(),1)&"#)<"&ListAll(6)
	 End If
  End IF
  If ListAll(0)=0 Then TopStr="" Else TopStr="Top "&ListAll(0)&"" End If
  If instr(ListAll(3),"hot")>0 Then WhereStr=WhereStr&SqlFormat(WhereStr,"where","and")&"Movie_Hits>="&Config(68) Else WhereStr=WhereStr End If  
  If instr(ListAll(3),"elite")>0 or Ranks=3 Then WhereStr=WhereStr&SqlFormat(WhereStr,"where","and")&"Movie_Elite="&SqlBit(1) End If    
  If instr(ListAll(3),"slide")>0 Then WhereStr=WhereStr&SqlFormat(WhereStr,"where","and")&"Movie_Slideed="&SqlBit(1) End If    
  If instr(ListAll(3),"continu")>0 Then WhereStr=WhereStr&SqlFormat(WhereStr,"where","and")&"Movie_Continu="&SqlBit(1) End If 
  If instr(ListAll(10),"release")>0 Then WhereStr=WhereStr&SqlFormat(WhereStr,"where","and")&"Movie_Release="&SqlBit(1) End If 
  If instr(ListAll(10),"prevue")>0 Then WhereStr=WhereStr&SqlFormat(WhereStr,"where","and")&"Movie_Release="&SqlBit(2) End If 
   
  If ListAll(1)<>"0" and ListAll(1)<>"" then 
	ListAll(0)=999999
	 Sql = "select  "&DbFieldList&" From {Pre}HiboCms_Movie where Movie_id in("&Sqlin(ListAll(1))&") "&GetOrderStr(ListAll(7))&""
  ElseIf Ranks=3 Then
	 Sql = "select "&TopStr&DbFieldList&" from  {Pre}HiboCms_Movie    "&WhereStr&" "&GetOrderStr(ListAll(6))&" "
  ElseIf ListAll(5) Then' page?
	 
	 Dim idcount,pagec,sqlid
	 krssql="select "&TopStr&" count(Movie_id) as idcount From {Pre}HiboCms_Movie "&WhereStr
	 set krs = HiConn.DB(krssql,"execute"):idcount=krs("idcount")
	 
	 If (idcount>0) then
		pagec=FormatPage(idcount,ListAll(0))
	 crszsql="select  Movie_id  From {Pre}HiboCms_Movie "&WhereStr&" "&GetOrderStr(ListAll(7))
	 set crsz = HiConn.DB(crszsql,"records1")
	 crsz.pagesize = ListAll(0)
	 If CurrentPage > pagec then CurrentPage = pagec
	 If pagec > 0 then crsz.absolutepage = CurrentPage 
	   For i=1 to crsz.pagesize
		If crsz.eof then exit for  
		If(i=1)then
		   sqlid=crsz("Movie_id")
		Else
		   sqlid=sqlid &","&crsz("Movie_id")
		End if
	   crsz.movenext:next:crsz.Close:Set crsz=Nothing
	   
	 End If:krs.Close:Set krs=Nothing
	 If(idcount>0 and sqlid<>"") then
		  Sql = "select "&TopStr&DbFieldList&" From {Pre}HiboCms_Movie where Movie_id in("& sqlid &") "&GetOrderStr(ListAll(7))&""
	 Else
		  Sql = "select "&TopStr&DbFieldList&" From {Pre}HiboCms_Movie"&WhereStr&" "&GetOrderStr(ListAll(7))&" "
	 End If
  Else
  Sql = "select "&TopStr&DbFieldList&" From {Pre}HiboCms_Movie "&WhereStr&" "&GetOrderStr(ListAll(7))&" "
 End If 
  set rs = HiConn.DB(sql,"records1")
  If Not (rs.bof and rs.eof) Then 
	i=0
  If ListAll(5)=True Then
	  rs.pagesize=ListAll(0)
	  m=idcount
	  n=pagec
	  z=ListAll(0)
	  Mlistpagenums=n:Mlistpagecount=m
	  Do while not rs.eof and i<rs.pagesize
		  List_str=GetHtmlLable(StrContent,i+1,"")
		  List_Html=List_Html&List_str
		  i=i+1
		  rs.movenext
	  Loop
	  PageStr=GetLinkPage(list_id,CurrentPage,Ranks,ListAll(0),m)
  Else
	  Do while not rs.eof and i<ListAll(0)
		  if i>=limit then
		  	  List_str=GetHtmlLable(StrContent,i+1,"")
		  	  List_Html=List_Html&List_str	
		  End if	
		  i=i+1
		  rs.movenext
	  Loop
  End If
  Else
	  List_Html=Err_Msg(23)
  End If
  rs.Close:Set rs=Nothing
GetMovieList=List_Html
End Function

Public Function GetHtmlLable(strList,listnum,LableType)
	Dim PicUrls,PicUrlb,List_str,MovieIntro,SeoMovieIntro,MovieName,MovieSubtitle,MovieDirector,MovieActor,MovieArea,Moviealias,MovieTaglist,MovieSlideFile,MovieClass,MovieScoreNum,MovieScoreEr,MovieRelease,ClassExpandList,MovieHBSource
	Dim RSid,RSclssid,RSpinyin,RSpicbig,RSpicsmall,RSplayType,RSplayUrl,RSExtensible,RSMovieClassExpand,RSMovielevel,RSMovieMd5
	dim sss
	
	List_str=strList
	RSid=rs("Movie_id")
	MovieHBSource=Trim(rs("Movie_Source"))
	RSclssid=rs("class_id")
	RSMovieClassExpand=rs("Movie_Class_Expand")
	RSpinyin=Trim(rs("Movie_PinYin"))
	RSpicbig=rs("Movie_PicBig")
	RSpicsmall=rs("Movie_PicSmall")
	RSplayType=Trim(rs("Movie_Play_Path"))
	RSplayUrl=Trim(rs("Movie_Play_Url"))
	RSExtensible=rs("Movie_Extensible")
	RSMovielevel=M_int(rs("Movie_level"),0)
	RSMovieMd5=rs("Movie_Md5")
	
	MovieName=Trim(rs("Movie_Name"))
	Moviealias=Trim(rs("Movie_Alias"))
	MovieTaglist=Trim(rs("Movie_Taglist"))
	MovieSubtitle=Trim(rs("Movie_subtitle"))
	MovieActor=htmlActor(rs("Movie_Actor"),",")
	MovieDirector=htmlActor(rs("Movie_Director"),",")
	MovieArea=GetReplace(rs("Movie_Erea"))
	MovieIntro=ReplaceHtml(rs("Movie_Intro"))
	MovieSlideFile=Trim(rs("Movie_Slide")&""):MovieSlideFile=iif(MovieSlideFile="",Config(0)&"Images/default.gif",GetSiteUnionPath(53)&MovieSlideFile)
	MovieRelease=iif(rs("Movie_Release"),"Ƭ","ԤƬ")
	SeoMovieIntro=SEO_MovieIntro(MovieIntro,MovieName,MovieDirector,MovieActor,MovieArea,MovieClass)
	
	PicUrls=MoviePicture(RSpicsmall)
	PicUrlb=MoviePicture(RSpicbig)
    If  LableType="details" and RSExtensible  then Call GetMovieExtensible(RSid&"-"&RSMovieMd5)

	    IF RSMovieClassExpand<>"" then 
		Dim ClassExpand:ClassExpand= Split(RSMovieClassExpand,",")
	    for ce=0 to UBound(ClassExpand)
			ClassExpandList=ClassExpandList&"<a href='"&GetListLink("U",ClassExpand(ce),1,"S")&"'>"&GetClassName(ClassExpand(ce),2)&"</a>&nbsp;"
		next
		End if
	List_str=ReplaceStr(List_str,"{$movie"&LableType&".number}",listnum)
	List_str=ReplaceStr(List_str,"{$movie"&LableType&".hbcode}",MovieHBSource)
	List_str=ReplaceStr(List_str,"{$movie"&LableType&".level}",RSMovielevel)
	List_str=ReplaceStr(List_str,"{$movie"&LableType&".class.expand.url}",ClassExpandList)
	List_str=ReplaceStr(List_str,"{$movie"&LableType&".id}",RSid)
	List_str=ReplaceStr(List_str,"{$movie"&LableType&".class.id}",RSclssid)
	List_str=ReplaceStr(List_str,"{$movie"&LableType&".class.url}","<a href="""&GetListLink("U",RSclssid,1,"S")&""" target=""_blank"">"&GetClassName(RSclssid,2)&"</a>")'
	List_str=ReplaceStr(List_str,"{$movie"&LableType&".class.name}",GetClassName(RSclssid,2))
	List_str=ReplaceStr(List_str,"{$movie"&LableType&".fav}",M_int(rs("Movie_Fav"),0))
	List_str=ReplaceStr(List_str,"{$movie"&LableType&".url}",Config(9)&GetMovieDataLink("U",RSclssid,RSid,RSpinyin,RSMovieMd5))
	List_str=ReplaceStr(List_str,"{$movie"&LableType&".area}",MovieArea)
	List_str=ReplaceStr(List_str,"{$movie"&LableType&".hits}",M_int(rs("Movie_Hits"),0))
	List_str=ReplaceStr(List_str,"{$movie"&LableType&".pic.small}",PicUrls) 
	List_str=ReplaceStr(List_str,"{$movie"&LableType&".pic}",PicUrlb) 
	IF Instr(List_str,"{$movie"&LableType&".css}")>0 THEN  List_str=ReplaceStr(List_str,"{$movie"&LableType&".css}",ReurlToCss(rs("Movie_Reurl")))'
		For sss=1 to 7 
			List_str=ReplaceStr(List_str,"{$movie"&LableType&".time."&sss&"}",HiboCMS_Time(rs("Movie_LastTime"),sss))
		next
	List_str=ReplaceStr(List_str,"{$movie"&LableType&".lianzai}",GetReplace(rs("Movie_Reurl")))
	List_str=ReplaceStr(List_str,"{$movie"&LableType&".intro}",SeoMovieIntro)
	List_str=ReplaceStr(List_str,"{$movie"&LableType&".release}",MovieRelease)
	List_str=ReplaceStr(List_str,"{$movie"&LableType&".reurl}",GetUrl(7))
	List_str=ReplaceStr(List_str,"{$movie"&LableType&".year}",GetReplace(rs("Movie_Year")))
	List_str=ReplaceStr(List_str,"{$movie"&LableType&".language}",GetReplace(rs("Movie_Language")))  
	MovieScoreNum=rs("Movie_ScoreNum"):if isnull(MovieScoreNum) then MovieScoreNum=0
	MovieScoreEr=rs("Movie_ScoreEr"):if isnull(MovieScoreEr) then MovieScoreEr=0
	List_str=ReplaceStr(List_str,"{$movie"&LableType&".score}",MovieScoreNum)
	List_str=ReplaceStr(List_str,"{$movie"&LableType&".scoreer}",MovieScoreEr)
	List_str=ReplaceStr(List_str,"{$movie"&LableType&".scoreperc}",FormatPercent(cint(MovieScoreNum)/10,0,True))
	List_str=ReplaceStr(List_str,"{$movie"&LableType&".slide}",MovieSlideFile)                  
	List_str=ReplaceStr(List_str,"{$movie"&LableType&".actor}",MovieActor)
	IF Instr(List_str,"{$movie"&LableType&".actor.url}")>0 Then  List_str=ReplaceStr(List_str,"{$movie"&LableType&".actor.url}",GetActor(MovieActor,"actor"))
	List_str=ReplaceStr(List_str,"{$movie"&LableType&".director}",MovieDirector)
	IF Instr(List_str,"{$movie"&LableType&".director.url}")>0 Then  List_str=ReplaceStr(List_str,"{$movie"&LableType&".director.url}",GetActor(MovieDirector,"director"))
	List_str=ReplaceStr(List_str,"{$movie"&LableType&".name}",MovieName)
	List_str=ReplaceStr(List_str,"{$movie"&LableType&".alias}",Moviealias)
	List_str=ReplaceStr(List_str,"{$movie"&LableType&".taglist}",MovieTaglist)
	List_str=ReplaceStr(List_str,"{$movie"&LableType&".pinyin}",RSpinyin)
	List_str=ReplaceStr(List_str,"{$movie"&LableType&".subtitle}",MovieSubtitle)
	IF Instr(List_str,"{$movie"&LableType&".play.default}")>0 Then  List_str=ReplaceStr(List_str,"{$movie"&LableType&".play.default}",GetPlayList2(RSplayType,RSplayUrl,"ids=""9999"" ",""))
	
		IF Instr(List_str,"{$movie"&LableType&".")>0 Then
		regEx.Pattern = "{\$movie"&LableType&".(.*?)\(([\s\S]*?)\)}":Set Matches = regEx.Execute(List_str)
		For Each Match In Matches
		    Select Case Trim(Match.SubMatches(0))
			Case "name" 
				List_str=ReplaceStr(List_str,Match.value,GetSubStr(FormatallHtml(MovieName,true),M_int(Match.SubMatches(1),100),True))
            Case "intro" 
				List_str=ReplaceStr(List_str,Match.value,GetSubStr(FormatallHtml(MovieIntro,true),M_int(Match.SubMatches(1),100),True))
            Case "subtitle" 
				List_str=ReplaceStr(List_str,Match.value,GetSubStr(FormatallHtml(MovieSubtitle,true),M_int(Match.SubMatches(1),100),True))
			Case Else 
			End Select 
		Next:Set matches = Nothing
		End if
        IF Instr(Content,"{hibocms:playlist")>0 then
			regEx.Pattern =  "(<!--|){hibocms:playlist(.*?)}(-->|)([\s\S]*?)(<!--|){\/hibocms:playlist}(-->|)"
			Set Matches = regEx.Execute(List_str)
		For Each Match In Matches
			List_str=ReplaceStr(List_str,Match.value,GetPlayList2(RSplayType,RSplayUrl, Match.SubMatches(1), Match.SubMatches(3)))
		Next:Set matches = Nothing
		End IF
        IF Instr(Content,"{hibocms:dramalist")>0 then
			regEx.Pattern =  "(<!--|){hibocms:dramalist(.*?)}(-->|)([\s\S]*?)(<!--|){\/hibocms:dramalist}(-->|)"
			Set Matches = regEx.Execute(List_str)
		For Each Match In Matches
			List_str=ReplaceStr(List_str,Match.value,GetDramaList(RSExtensible,RSid,Match.SubMatches(1), Match.SubMatches(3),MovieIntro))
		Next:Set matches = Nothing
		End IF
		
		If Instr(List_str,"{$movie"&LableType&".actor.items(")>0 Then
			regEx.Pattern = "{\$movie"&LableType&".actor.items\(([\s\S]*?)\)}":Set Matches = regEx.Execute(List_str)
		For Each Match In Matches
			List_str=ReplaceStr(List_str,Match.value,GetActorList(MovieExtensible(2),Match.SubMatches(0)))
		Next:Set matches = Nothing
		End if

		If Instr(List_str,"{$movie"&LableType&".poster.items(")>0 Then
			regEx.Pattern = "{\$movie"&LableType&".poster.items\(([\s\S]*?)\)}":Set Matches = regEx.Execute(List_str)
		For Each Match In Matches
			List_str=ReplaceStr(List_str,Match.value,GetPosterList(MovieExtensible(3),Match.SubMatches(0)))
		Next:Set matches = Nothing
		End if

	GetHtmlLable=List_str
End Function


Public Function GetPosterList(Extensible,str)
on error resume next
if Extensible="" then GetPosterList="":exit function
dim PicUrls,LiStr,PosterHtml,n,PosterList:PosterList=split(Extensible,chr(10))
	for n=0 to Ubound(PosterList)
		LiStr=str
		If PosterList(n)<>"" Then 
		If Instr(PosterList(n),"http://")>0 Then PicUrls=PosterList(n)     Else PicUrls=GetSiteUnionPath(53)&Trim(PosterList(n)) End If
		LiStr=replace(LiStr,"{$poster.items.number}",n+1)
		LiStr=replace(LiStr,"{$poster.items.pic}",PicUrls)
		PosterHtml=PosterHtml&LiStr
		End if
    next
if Err Then 
   GetPosterList="":Err.Clear
Else
   GetPosterList=PosterHtml
end if
End Function

Public Function GetActorList(Extensible,str)
on error resume next
dim LiStr,ActorHtml,n,ActorList:ActorList=split(Extensible,chr(10))
	for n=0 to Ubound(ActorList)
		LiStr=str
		If ActorList(n)<>"" Then 
		LiStr=replace(LiStr,"{$actor.items.number}",n+1)
		LiStr=replace(LiStr,"{$actor.items.url}",GetActor(Split(ActorList(n),"$$")(0),"actor"))
		LiStr=replace(LiStr,"{$actor.items.actor}",Split(ActorList(n),"$$")(0))
		LiStr=replace(LiStr,"{$actor.items.name}",Split(ActorList(n),"$$")(0))
		LiStr=replace(LiStr,"{$actor.items.role}",Split(ActorList(n),"$$")(1))
		LiStr=replace(LiStr,"{$actor.items.msg}",Split(ActorList(n),"$$")(2))
		ActorHtml=ActorHtml&LiStr
		End if
    next
if Err Then 
   GetActorList="":Err.Clear
Else
   GetActorList=ActorHtml
end if
End Function


Public Function GetDramaList(D_Yn,M_ID,Mat1,Mat2,M_Intro)
'on error resume next
Dim LiStr,attr,PlayAll(2),DramaList,GetDramaHtml
set attr=parseAttr(Mat1)
PlayAll(0)=M_int(attr("ids"),0)
PlayAll(1)=attr("null")

if D_Yn Then
	DramaList=replace(MovieExtensible(1)&"","<hr />","<hr>")
End if

if M_Intro="" then M_Intro=C_L_DramaEmpty
IF DramaList="" and  PlayAll(1)<>"default" Then 
	GetDramaHtml=""
Else
	if DramaList="" then DramaList=M_Intro
	DramaSplit=Split(DramaList,"<hr>")
	if PlayAll(0)=1 Then 
	   A1=PlayJD-1:A2=A1
	Else
	   A1=0:A2=Ubound(DramaSplit)
	End if
	if Ubound(DramaSplit)=0 or Ubound(DramaSplit)<a1  then A1=0:A2=0
	IF Ubound(DramaSplit)<=PlayJD-1 then  DramaSplit(0)=M_Intro
		For n=A1 to A2
		  LiStr=Mat2
		  LiStr=Replace(LiStr,"{$movie.drama.number}",N+1)  
		  LiStr=Replace(LiStr,"{$movie.drama.intro.html}",FormatallHtml(DramaSplit(n),False))
		  LiStr=Replace(LiStr,"{$movie.drama.intro}",     DramaSplit(n))
			
			IF Instr(LiStr,"{$movie.drama.intro")>0 Then
			regEx.Pattern = "{\$movie.drama.intro(.*?)\(([\s\S]*?)\)}":Set Matches = regEx.Execute(LiStr)
			For Each Match In Matches
			if Match.SubMatches(0)="html" then DramaSplit(n)=FormatallHtml(DramaSplit(n),true)
				 LiStr=ReplaceStr(LiStr,Match.value,GetSubStr(DramaSplit(n),M_int(Match.SubMatches(1),100),True))
			Next:Set matches = Nothing
			End if 
		GetDramaHtml=GetDramaHtml&LiStr
		Next
End if
GetDramaList=GetDramaHtml
End Function	

Public Function GetPlayList2(PlayPath,PlayUrl,Strtype,StrlistAll)
'on error resume next
  Dim attr,Player_num,PlayAll(3),vnum,PlayUrlData,playIn,playfr,playal,playfren,PlayHtml,PlaySortLevs,PlayLevs,k,ks,kl,m
  Dim listItem,listItems,movieplaymode:movieplaymode=Split("|player|share|down","|")
  dim DefaultItems:DefaultItems="{$movie.play.items(<li><a href='{$play.items.url}' title='{$play.items.name}{$play.items.title}'>{$play.items.title}</a></li>)}"
  set attr=parseAttr(Strtype)
  PlayAll(0)=M_int(attr("ids"),0) '0=ȫ 1=ǰԴ,PlaySvs
  PlayAll(1)=attr("target")        
  PlayAll(2)=attr("currentstyle")        
  PlayAll(3)=attr("order"):if PlayAll(3)="" then PlayAll(3)="asc"  
  If isNul(PlayPath) or isNul(PlayUrl) Then Exit Function
  PlayFm=Split(PlayPath,"$$")
  PlayUrlData=Split(PlayUrl,"$$$")
  'Response.Write(PlayAll(4))
	 IF Ubound(PlayFm)<>Ubound(PlayUrlData) Then
		IF Ubound(PlayFm)<Ubound(PlayUrlData) Then
		  vnum=Ubound(PlayFm)
		Else
		  vnum=Ubound(PlayUrlData)
		End IF
	 Else
		  vnum=Ubound(PlayFm)
	 End IF
	 
	StrlistAll=replace(StrlistAll,"{$movie.play.url}",DefaultItems)
	IF Instr(StrlistAll,"{$movie.play.items(")>0 Then
	regEx.Pattern = "{\$movie.play.items\(([\s\S]*?)\)}":Set Matches = regEx.Execute(StrlistAll)
	For Each Match In Matches
		listItem=Match.SubMatches(0)
		listItems=Match.value
	Next:Set matches = Nothing
	End if
	 if PlayAll(0)=1 Then
		  For k=0 to vnum
		  if k=Clng(PlaySvs) then Exit for
			m=GetPlayNumber(PlayFm(k))
			playfr=playfrom(m):playIn=playInfo(m):playal=PlayAlias(m):playfren=replace(PlayFile(m),".html","",1,-1,1):if playal="" then playal=playfr
		  Next
			PlayHtml=StrlistAll
		  IF listItem<>"" Then PlayHtml=ReplaceStr(PlayHtml,listItems, PlayDataShow("all", m,PlayUrlData(k-1),k-1,rs("Movie_id"),PlayAll(1),rs("Movie_Name"),rs("Class_id"),0,PlayJD,PlayAll(2),listItem))
			PlayHtml=ReplaceStr(PlayHtml,"{$movie.play.from}",playfr)
			PlayHtml=ReplaceStr(PlayHtml,"{$movie.play.name}",playfren)
			PlayHtml=ReplaceStr(PlayHtml,"{$movie.play.alias}",playal)
			PlayHtml=ReplaceStr(PlayHtml,"{$movie.play.msg}",playIn)
			PlayHtml=ReplaceStr(PlayHtml,"{$movie.play.number}",1)
			PlayHtml=ReplaceStr(PlayHtml,"{$movie.play.mode}",movieplaymode(PlayMode(m)))
	 	k=1
	 Else
		For Levs=1 to UBound(PlayFrom)
	     if instr("$$"&PlayPath&"$$","$$"&PlayFrom(Levs)&"$$")>0 then
		    PlaySortLevs=PlaySortLevs&GetChrDuan(PlayPath,"$$",PlayFrom(Levs))&","
			PlayLevs=PlayLevs&Levs&","
		 End if
		Next
		
		For k=0 to vnum
		  ks=Split(PlaySortLevs,",")(k)
		  kl=Split(PlayLevs,",")(k)
		  IF kl="" then
			 PlayHtml=PlayHtml&Err_Msg(22)&"&nbsp;"&Err_Msg(35)
		  else
			 playfr=playfrom(kl):playIn=playInfo(kl):playal=PlayAlias(kl):playfren=replace(PlayFile(kl),".html","",1,-1,1):if playal="" then playal=playfr
		  PlayHtml=PlayHtml&StrlistAll
		  IF listItem<>"" Then PlayHtml=ReplaceStr(PlayHtml,listItems,PlayDataShow("all",kl,PlayUrlData(ks),ks,rs("Movie_id"),PlayAll(1),rs("Movie_Name"),rs("Class_id"),PlayAll(3),PlayJD,PlayAll(2),listItem))
		  'IF Instr(PlayHtml,"{$movie.play.media}")>0 Then PlayHtml=ReplaceStr(PlayHtml,"{$movie.play.media}",PlayDataShow("media",kl,PlayUrlData(ks),ks,rs("Movie_id"),PlayAll(1),rs("Movie_Name"),rs("Class_id"),PlayAll(3),PlayJD,PlayAll(2)))
		  PlayHtml=ReplaceStr(PlayHtml,"{$movie.play.from}",playfr)
		  PlayHtml=ReplaceStr(PlayHtml,"{$movie.play.name}",playfren)
		  PlayHtml=ReplaceStr(PlayHtml,"{$movie.play.alias}",playal)
		  PlayHtml=ReplaceStr(PlayHtml,"{$movie.play.msg}",playIn)
		  PlayHtml=ReplaceStr(PlayHtml,"{$movie.play.number}",k+1)
		  PlayHtml=ReplaceStr(PlayHtml,"{$movie.play.mode}",movieplaymode(PlayMode(kl)))
		  if PlayAll(0)=9999 Then 
		  	 PlayHtml=PlayDataShow("default",kl,PlayUrlData(ks),ks,rs("Movie_id"),PlayAll(1),rs("Movie_Name"),rs("Class_id"),PlayAll(3),PlayJD,PlayAll(2),listItems)
		  	 exit for
		  end if
		  end if
		Next		  
	 End if
		  PlayHtml=ReplaceStr(PlayHtml,"{$movie.play.count}",k)
	GetPlayList2=PlayHtml
if Err Then GetPlayList2="":errid=err.number:errdes=err.description::errline=Err.Line:Err.Clear:ShowErr errline,Err_Msg(22),errid,Err_Msg(35)
End Function	

Public Function OpenHiboCmsSearch(StrContent)
	If StrContent<>"" Then Content=StrContent
	regEx.Pattern = "(<!--|){hibocms:searchlist(.*?)}(-->|)([\s\S]*?)(<!--|){\/hibocms:searchlist}(-->|)"
	Set Matches = regEx.Execute(Content)
	For Each Match In Matches
	Content=ReplaceStr(Content,Match.value,GetSearchAll(Match.SubMatches(1), Match.SubMatches(3)))'
	Next:Set matches = Nothing
	dim S1,S2
	IF SearchType="year" Then S1=C_L_Year
	IF SearchType="director" Then S1=C_L_M_Director
	IF SearchType="actor" Then S1=C_L_M_Actor
	IF SearchType="tagkey" Then S1="TAG:"
	IF instr(",year,language,area,letter",SearchType)>0 then 
		S2=keyword&S1&GetClassName(List_Id,2)
    Elseif instr(",director,actor,tagkey",SearchType)>0 then
		S2=S1&keyword
	else
		S2=keyword
	end if
	Content=ReplaceStr(Content,"{$searchlist.keyword}",S2)
	Content=ReplaceStr(Content,"{$searchlist.page}",PageStr)
	Content=ReplaceStr(Content,"{$searchlist.page.num}",CurrentPage)
	Content=ReplaceStr(Content,"{$searchlist.page.nums}",Mlistpagenums)
	Content=ReplaceStr(Content,"{$searchlist.page.count}",Mlistpagecount)
End Function

Public Function GetSearchAll(Strtype,StrContent)
	Dim attr,ListAll(3),WhereStr,ContinuStr,List_Html:List_Html=""
	If Strtype="" Then GetListSpecial=Err_Msg(19):Exit Function
	set attr=parseAttr(Strtype)
	
	ListAll(0)=m_int(attr("num"),0):if ListAll(0)=0 then ListAll(0)=10
	ListAll(1)=attr("order")
	SELECT CASE  ListAll(1)
		CASE "id":orderStr =" order by Movie_id desc"
		CASE "time":orderStr =" order by Movie_LastTime desc"
		CASE "hits":orderStr =" order by Movie_Hits desc"
		CASE "fav":orderStr =" order by Movie_Fav desc"
		CASE "elite":orderStr =" order by Movie_Elite desc"
		CASE "year":orderStr =" order by Movie_Year desc"
	END SELECT
	Sql = "select "&DbFieldList&" From {Pre}HiboCms_Movie where "&GetSearchStr(SearchType,List_Id,keyword)&orderStr
	set rs = HiConn.DB(sql,"records1")
	If Not (rs.bof and rs.eof) Then 
		i=0
		rs.pagesize=ListAll(0)
		rs.AbsolutePage=iif(CurrentPage=0,1,CurrentPage)
		m=rs.recordcount
		n=rs.PageCount
		z=rs.pagesize
		Mlistpagenums=n:Mlistpagecount=m
		Do while not rs.eof and i<rs.pagesize
		List_str=GetHtmlLable(StrContent,i,"")
		List_Html=List_Html&List_str
		i=i+1
		rs.movenext
		Loop
		PageFile=IIF(instr(",year,language,area,letter,tagkey",","&SearchType)>0,Config(0)&"index.asp?Hi=search/"&searchtype&"/"&List_Id&"/"&Server.URLEncode(keyword)&"/{page}.html",Config(0)&"index.asp?Hi=search/"&searchtype&"/"&Server.URLEncode(keyword)&"/{page}.html")
		PageStr=PageShow(PageFile, m, ListAll(0), CurrentPage, False, True, "", False,1)
	Else
		'List_Html="<center><br><br>Բ,վ޴, <a href=""http://www.Hibocms.com/s/?key="&keyword&""" target=""_blank""><font color=red><b>Դ ["&keyword&"] !</b></font></a></center>"
		List_Html="<font color=red><b>Բûҵ["&keyword&"].</b></font>"
	End If
	rs.Close:Set rs=Nothing
GetSearchAll=List_Html
End Function

Public Function OpenHiboCmsSlide(StrContent)
	If StrContent<>"" Then Content=StrContent
	regEx.Pattern = "(<!--|){hibocms:slide(.*?)}(-->|)([\s\S]*?)(<!--|){\/hibocms:slide}(-->|)"
	Set Matches = regEx.Execute(Content)
	For Each Match In Matches
	Content=ReplaceStr(Content,Match.value,GetSlide(Match.SubMatches(1), Match.SubMatches(3)))
	Next:Set matches = Nothing
End Function

Public Function GetSlide(Strtype,StrContent)
Dim GetSlideStr,attr,ListAll(1),SlideS,i,x,GetSlideStrt,SqlWhere
	set attr=parseAttr(Strtype)
	ListAll(0)=attr("ids")
	ListAll(1)=M_int(attr("num"),5)
	If ListAll(0)="" Then
		sql = " Select top "&ListAll(1)&" * From {Pre}HiboCms_Slide order by Slide_id desc"
	Else
		sql = " Select *  From {Pre}HiboCms_Slide where Slide_id in ("&ListAll(0)&") order by Slide_id desc"
	End IF
	set rs = HiConn.DB(sql,"records1")
	i=0
	Do while not rs.eof
	   i=i+1
	   GetSlideStr=GetSlideStr&StrContent
	   GetSlideStr=ReplaceStr(GetSlideStr,"{$slide.title}",rs("Slide_title"))
	   GetSlideStr=ReplaceStr(GetSlideStr,"{$slide.pic}",  GetSiteUnionPath(53)&rs("Slide_pic"))	
	   GetSlideStr=ReplaceStr(GetSlideStr,"{$slide.intro}", rs("Slide_intro"))
	   GetSlideStr=ReplaceStr(GetSlideStr,"{$slide.url}", rs("Slide_Http"))
	   GetSlideStr=ReplaceStr(GetSlideStr,"{$slide.number}",i)
	rs.movenext
	Loop
	rs.close:Set rs=nothing
GetSlide=GetSlideStr
End Function

Public Function OpenData(StrContent)
   dim i:i=1
	sql = " Select  "&DbFieldList&"	From {Pre}HiboCms_Movie where Movie_Status="&SqlBit(1)&" and Movie_id="&Movie_id&" "
	set rs = HiConn.DB(sql,"records1")
	If Not(rs.bof And rs.eof) Then
		Content=GetHtmlLable(Content,i,"details")
	Else 
		ShowErr "",Err_Msg(30),"DB0000",Err_Msg(25)
	End If
	rs.Close:Set rs=nothing
End Function

Public Function OpenHiboCmsPlayer(StrContent,O_Sv,O_Type)
dim i:i=1
   If StrContent<>"" Then Content=StrContent
   if (PlaySv<>CreatePlaySvs Or TypeName(CreatePlaySvs)="Empty") Then
      CreatePlaySvs=PlaySv 
     sql="Select "&DbFieldList&" From {Pre}HiboCms_Movie where Movie_Status="&SqlBit(1)&" and Movie_id="&Data_Id
     set rs = HiConn.DB(sql,"execute")
     If Not(rs.bof And rs.eof) Then
	   Movie_Reurl=Trim(rs("Movie_Reurl")):Movie_Play_Url=Trim(rs("Movie_Play_Url")):Movie_Play_Path=Trim(rs("Movie_Play_Path")):Movie_Name=Trim(rs("Movie_Name")):Movie_id=rs("Movie_id")
	   Content=GetHtmlLable(Content,i,"details")
	   if O_Type Then set rs2 = HiConn.DB("update {Pre}HiboCms_Movie Set Movie_Hits=Movie_Hits+1 Where Movie_id="&Data_Id,"execute")
	   Call OpenAll()
     Else
	   ShowErr "",Err_Msg(30),"DB0000",Err_Msg(25)
     End If
     rs.close:Set rs=nothing
	Call LableObj.OpenHiboCmsMovieList(LableObj.Content) 
	CreatePlayerHtml=Content
   end if
   Content=PlayUrlShow(Content,Movie_Name,Movie_Play_Path,Movie_Play_Url,Movie_id,Movie_Reurl)
END Function			

Public Function OpenHiboCmsCommentList(StrContent)
	If StrContent<>"" Then Content=StrContent
	IF Instr(Content,"{hibocms:contentlist")>0 then
	regEx.Pattern =  "(<!--|){hibocms:contentlist(.*?)}(-->|)([\s\S]*?)(<!--|){\/hibocms:contentlist}(-->|)"
	Set Matches = regEx.Execute(Content)
	For Each Match In Matches
		Content=ReplaceStr(Content,Match.value,GetCommentList(Match.SubMatches(1),Match.SubMatches(3)))
	Next:Set matches = Nothing
	IF Instr(Content,"{$content.page}")>0 then  Content=ReplaceStr(Content,"{$content.page}",PageStr)
	IF Instr(Content,"{$content.data}")>0 then  Content=ReplaceStr(Content,"{$content.data}",PingLun_Data)
	IF Instr(Content,"{$content.type}")>0 then  Content=ReplaceStr(Content,"{$content.type}",PingLun_Type)
	End IF
End Function

Public Function GetCommentList(Strtype,StrContent)
dim RsArray,attr,i,p,orderStr,SqlWhere,ListAll(3),TopStr,Liststr,List_Html
bgcolorArr=Array("#D66103","#512DBD","#780E1A","#C5A200","#DA4912","#530752","#C5A200","#512DBD","#D66103","#530752")
set attr=parseAttr(Strtype)	
	ListAll(0)=m_int(attr("num"),0):if ListAll(0)=0 then ListAll(0)=10'
	set rs = HiConn.DB("select PingLun_username,PingLun_content,PingLun_date,PingLun_pic,PingLun_ip From {Pre}HiboCms_PingLun where PingLun_data="&PingLun_Data&" and PingLun_Type="&PingLun_Type&" order by PingLun_id desc","records1")
	i=0
	If rs.bof Or rs.eof Then
		GetCommentList="<center><h4>"&Err_Msg(24)&"</h4></center>":Exit Function
	Else 
		rs.pagesize=ListAll(0)
		total=rs.pagecount
		p=rs.recordcount
		If page>total then
			page=total
		Else
			rs.absolutepage = page
		End If
		PageStr=getPageInfo(total,Page,PingLun_Data)
		RsArray = rs.GetRows()
		  For i=0 to  UBound(rsArray,2)
		  PingLun_add=iif(m_int(Config(49),0)=1,"&nbsp;"&IPtoAdd(rsArray(4,i))&"&nbsp;","") '
		  PingLun_t=IIF(PingLun_pic<=0,"nobody",PingLun_pic)
		  List_Html=List_Html&StrContent
		  IF Instr(List_Html,"{$content.time}")>0 then       List_Html=ReplaceStr(List_Html,"{$content.time}",rsArray(2,i))
		  IF Instr(List_Html,"{$content.content}")>0 then       List_Html=ReplaceStr(List_Html,"{$content.content}",rsArray(1,i))
		  IF Instr(List_Html,"{$content.reco}")>0 then       List_Html=ReplaceStr(List_Html,"{$content.reco}",p-(page-1)*ListAll(0)-(i))
		  IF Instr(List_Html,"{$content.user.faces}")>0 then 		 List_Html=ReplaceStr(List_Html,"{$content.user.faces}","/images/faces/"&RandNum(1,16)&".gif")
		  IF Instr(List_Html,"{$content.user.name}")>0 then       List_Html=ReplaceStr(List_Html,"{$content.user.name}",rsArray(0,i))
		  IF Instr(List_Html,"{$content.user.add}")>0 then       List_Html=ReplaceStr(List_Html,"{$content.user.add}",PingLun_add)
		  IF Instr(List_Html,"{$content.user.ip}")>0 then       List_Html=ReplaceStr(List_Html,"{$content.user.ip}",rsArray(4,i))
		  Liststr=Liststr&List_Html
		  If i>=ListAll(0) Then Exit For 
		next 
		rs.Close:Set rs=nothing
	End If 
GetCommentList=List_Html
End Function
	
Public Function GetTongJi(str)
  Select Case str
  Case 0
	  sql="select count(Movie_id) From {Pre}HiboCms_Movie"
  Case 999
	  If Config(1)="SQL" Then
		  sql=" select count(Movie_id) From {Pre}HiboCms_Movie where datediff(d,Movie_LastTime,getdate())=0 "
	  Else
		  sql=" select count(*) From {Pre}HiboCms_Movie where datediff('d',Movie_LastTime,#"&HiboCMS_Time(now(),1)&"#)=0 "
	  End If
  Case Else 
	  If str=-1 Then str=M_Int(List_Id,0)
	  sql=" select count(Movie_id) From {Pre}HiboCms_Movie where (class_id="&str&" or class_id in (select class_id from {Pre}HiboCms_Class where class_bigid="&str&")) "
  End Select 
  set rs = HiConn.DB(sql,"execute"):GetTongJi=Rs(0):rs.close:set rs=nothing
End Function
	
Public Function GetLink(strtype,strlist)
  Dim RsArray,attr,ListAll(1),i,Link_Html,Lits_Html,Where_Link,Cache_Link:Link_Html="":Cache_Link="Cache_Link"
  If Strtype="" Then GetMenu=Err_Msg(19):Exit Function
  set attr=parseAttr(strtype)
  ListAll(1)=attr("type")

  If Cint(Config(20))>0 and CacheObj.ChkCache(Cache_Link) Then
	   Link_Html = CacheObj.GetCache(Cache_Link,True)
  Else
	  If ListAll(1)="pic" Then Where_Link="where link_typeid=1"
	  set rs = HiConn.DB("Select link_id,link_name,link_url,link_logo,link_about,link_orderid,link_typeid From {Pre}HiboCms_Link "&Where_Link&" order by link_orderid asc","records1")
	  If Not(rs.bof And rs.eof) Then
         RsArray = rs.GetRows()
		  For i=0 to  UBound(rsArray,2)
					  Lits_Html=ReplaceStr(strlist,"{$link.number}",i+1)
					  Lits_Html=ReplaceStr(Lits_Html,"{$link.name}",rsArray(1,i))
					  Lits_Html=ReplaceStr(Lits_Html,"{$link.url}",rsArray(2,i))
					  Lits_Html=ReplaceStr(Lits_Html,"{$link.logo}",rsArray(3,i))
					  Lits_Html=ReplaceStr(Lits_Html,"{$link.msg}",rsArray(4,i))
					  Link_Html=Link_Html&Lits_Html
		  next
	  End If
	  rs.close:Set rs=nothing
	  CacheObj.SetCache Cache_Link,Link_Html,True
  End If
  GetLink=Link_Html
End Function
	
Public Function parseAttr(Byval attr)
On Error Resume Next
		dim attrStr,attrArray,i,singleAttr,singleAttrKey,singleAttrValue
		attr=replace(attr,chr(34),"")
		attrStr=regExpReplace(attr,"[\s]+",chr(32))
		attrStr=trimOuter(attrStr)
		attrArray=split(attrStr,chr(32)):strDictionary.removeall()
		for i=0 to ubound(attrArray)
			singleAttr=split(attrArray(i),chr(61))
			singleAttrKey= singleAttr(0):singleAttrValue= singleAttr(1)
			if not strDictionary.Exists(singleAttrKey) then strDictionary.add singleAttrKey,singleAttrValue  else  strDictionary(singleAttrKey)=singleAttrValue
		next
		set parseAttr=strDictionary
If Err Then errid=err.number:errdes=err.description:errline=err.Line:Err.Clear:ShowErr errline,Err_Msg(19),errid,errdes
End Function

Public Function regExpReplace(contentstr,patternstr,replacestr)
	regEx.Pattern=patternstr:regExpReplace=regEx.replace(contentstr,replacestr)
End Function

Public Sub Class_Terminate()
	Set regEx = nothing:Set strDictionary = nothing
End Sub

Function trimOuter(Byval str)
	dim vstr:vstr=str
	if left(vstr,1)=chr(32) then vstr=right(vstr,len(vstr)-1) 
	if right(vstr,1)=chr(32) then  vstr=left(vstr,len(vstr)-1)
	trimOuter=vstr
End Function

Public Function GetMenuHtml(G_number,G_Type,G_Str,G_id,G_MaxClass,G_ListId,G_Style)
dim MenuHtmlStr,Mh_id:Mh_id=M_int(Split(Menu(G_id),"|")(0),0)
	MenuHtmlStr=ReplaceStr(G_Str,"{$menu"&G_Type&".number}",G_number)
	MenuHtmlStr=ReplaceStr(MenuHtmlStr,"{$menu"&G_Type&".id}",Mh_id)
	MenuHtmlStr=ReplaceStr(MenuHtmlStr,"{$menu"&G_Type&".name}",Split(Menu(G_id),"|")(2))
	MenuHtmlStr=ReplaceStr(MenuHtmlStr,"{$menu"&G_Type&".name.eng}",Split(Menu(G_id),"|")(5))
	MenuHtmlStr=ReplaceStr(MenuHtmlStr,"{$menu"&G_Type&".link}",GetListLink("U",mh_id,1,"S"))
	If Instr(MenuHtmlStr,"{$menu"&G_Type&".currentstyle}")>0 Then
		If G_ListId=mh_id or G_MaxClass=mh_id Then 
			MenuHtmlStr=ReplaceStr(MenuHtmlStr,"{$menu"&G_Type&".currentstyle}",iif(SiteChannel="movie" or SiteChannel="search",G_Style,""))
		Else
			MenuHtmlStr=ReplaceStr(MenuHtmlStr,"{$menu"&G_Type&".currentstyle}","")
		End If
	End If
	CMenuCount=CMenuCount+1
	GetMenuHtml=MenuHtmlStr
End Function

End Class

Sub Moban_Index_Str(MoBan_Path)
	With LableObj : .OpenSkin(MoBan_Path) :.OpenHiboCmsSlide(Content): .OpenAll :.OpenHiboCmsNewsList(Content) :.OpenHiboCmsSpecialList(Content):.OpenHiboCmsMovieList(Content):End With
End Sub
Sub Moban_Search_Str(MoBan_Path)
	With LableObj : .OpenSkin(MoBan_Path) : .OpenAll :.OpenHiboCmsSlide(Content):.OpenHiboCmsNewsList(Content):.OpenHiboCmsSpecialList(Content): .OpenHiboCmsMovieList(Content):End With
End Sub
Sub Moban_News_Str(MoBan_Path)
	With LableObj : .OpenSkin(MoBan_Path) : .OpenAll :.OpenHiboCmsSlide(Content):.OpenHiboCmsSpecialList(Content): .OpenHiboCmsMovieList(Content):End With
End Sub
Sub Moban_Specia_Str(MoBan_Path)
	With LableObj : .OpenSkin(MoBan_Path) : .OpenAll :.OpenHiboCmsSlide(Content): End With
End Sub
Sub Moban_Class_Str(MoBan_Path)
	With LableObj : .OpenSkin(MoBan_Path) : .OpenAll :.OpenHiboCmsSlide(Content):.OpenHiboCmsNewsList(Content):.OpenHiboCmsSpecialList(Content):End With
End Sub
Sub Moban_Data_Str(MoBan_Path)
	With LableObj : .OpenSkin(MoBan_Path) : .OpenAll :.OpenHiboCmsSlide(Content):.OpenHiboCmsNewsList(Content):.OpenHiboCmsSpecialList(Content): End With
End Sub
Sub Moban_Play_Str(MoBan_Path)
	With LableObj : .OpenSkin(MoBan_Path) : .OpenAll :.OpenHiboCmsSlide(Content):.OpenHiboCmsNewsList(Content):.OpenHiboCmsSpecialList(Content):  End With
End Sub
Sub Moban_Other_Str(MoBan_Path)
	With LableObj : .OpenSkin(MoBan_Path) : .OpenAll:End With
End Sub
Sub MobanLast(StrContent)
	With LableObj :.IF_Replace(Content):.Gettaglist(Content):End With
End Sub
%>
