<?php
///////////////////////////////////////////////////////////////////
// Author:dahong | E-mail: dahongy@gmail.com
// Copyright (c) Http://www.phpstcms.cn
// This is not a free software, please to pay for more functions
// $Id: 2009-06-02 version V2.7 $
///////////////////////////////////////////////////////////////////
function addslash($str)
{
	if(is_array($str))
	{
		foreach($str as $key => $value)
		{
			$result[$key] = addslash($value);
		}
	}
	else
	{
		$result = addslashes($str);
	}
	return $result;
}

function stripslash($str)
{
	if(is_array($str))
	{
		foreach($str as $key => $value)
		{
			$result[$key] = stripslash($value);
		}
	}
	else
	{
		$result = stripslashes($str);
	}
	return $result;
}

function getIp()
{
	if(getenv('HTTP_CLIENT_IP') && strcasecmp(getenv('HTTP_CLIENT_IP'), 'unknown'))
	{
		$IP = getenv('HTTP_CLIENT_IP');
	}
	elseif(getenv('HTTP_X_FORWARDED_FOR') && strcasecmp(getenv('HTTP_X_FORWARDED_FOR'), 'unknown'))
	{
		$IP = getenv('HTTP_X_FORWARDED_FOR');
	}
	elseif(getenv('REMOTE_ADDR') && strcasecmp(getenv('REMOTE_ADDR'), 'unknown'))
	{
		$IP = getenv('REMOTE_ADDR');
	}
	elseif(isset($_SERVER['REMOTE_ADDR']) && $_SERVER['REMOTE_ADDR'] && strcasecmp($_SERVER['REMOTE_ADDR'], 'unknown'))
	{
		$IP = $_SERVER['REMOTE_ADDR'];
	}
	return $IP ? $IP : "unknow";
}

function stripSql($str,$search_arr,$replace_arr)
{
	if(is_array($str))
	{
		foreach($str as $key => $value)
		{
			$result[$key] = stripSql($value,$search_arr,$replace_arr);
		}
	}
	else
	{
		$result = preg_replace($search_arr,$replace_arr,$str);
	}
	return $result;
}

function msg($msg="过程中出错啦~",$url="javascript:history.back()",$time=2)
{
	global $CONFIG,$TPL,$STCMS,$smarty;
	$smarty->assign("tpl",$TPL);
	$smarty->assign("config",$CONFIG);
	$smarty->assign("webTitle","提示信息");
	$smarty->assign("msg",$msg);
	$smarty->assign("url",$url);
	$smarty->assign("time",$time);
	$smarty->display("msg.html");
}
function addLog($msg="错误信息")
{
	global $CONFIG,$STCMS,$mysql;
	if($CONFIG['enableLog'] == "1")
	{
		$mysql->insert("log",array("ip"=>$STCMS['CLIENT_IP'],"time"=>NOW,"url"=>$STCMS['URI'],"msg"=>$msg));
	}
}
function sHtml($var='')
{
	return htmlspecialchars($var);
}
function getFileSize($filesize) {
	if($filesize >= 1073741824) {
		$filesize = round($filesize / 1073741824 * 100) / 100 . ' G';
	} elseif($filesize >= 1048576) {
		$filesize = round($filesize / 1048576 * 100) / 100 . ' M';
	} elseif($filesize >= 1024) {
		$filesize = round($filesize / 1024 * 100) / 100 . ' K';
	} else {
		$filesize = $filesize . ' bytes';
	}
	return $filesize;
}
function checkPath($str)
{
	$str = str_replace("\\","/",$str);
	$str = substr($str,-1)=="/" ? $str : $str."/";
	return $str;
}
function serverList($value=false)
{
	global $mysql;
	$server = $mysql->select("server","*",false,"id DESC");
	$code = "<select name=\"server\">\n";
	$code .= "<option value=\"0\">本地服务器</option>\n";
	if($server)
	{
		foreach($server as $temp)
		{
			$code .= "<option value=\"{$temp['id']}\"".($value==$temp['id'] ? " selected=\"selected\"" :"").">{$temp['name']}</option>\n";
		}
	}
	$code .= "</select>";
	return $code;
}
function writeFile($path, $content, $mod)
{
	if (!file_exists($dirname = dirname($path)))
	{
		mkdirs($dirname);
	}
	$fp = fopen($path, $mod);
	if ($fp)
	{
		$r = @fwrite($fp, $content);
		fclose($fp);
		return $r;
	}
	return false;
}
function mkdirs($path)
{
	if (!is_dir(dirname($path)))
	{
		mkdirs(dirname($path));
	}
	if(!file_exists($path))
	{
		return @mkdir($path);
	}
}
function getFileExt($path)
{
	return strtolower(trim(substr(strrchr($path, '.'), 1)));
}
function listFile($path)
{
	if(is_dir($path))
	{
		$handle = @opendir($path);
		while( ($file = @readdir($handle)) !== false)
		{
			$fileArr[] = array('name'=>$file, 'type'=>(is_dir($path.$file) ? "dir" : "file"), 'size'=>getFileSize(@filesize($path.$file)), 'mtime'=>date("Y-m-d h:i:s",@filemtime($path.$file)));
		}
	}
	else
	{
		return false;
	}
	return $fileArr;
}
function cookieEncode($arg)
{
	if(is_array($arg))
	{
		foreach($arg as $k => $v)
		{
			$str[] = $k."=".$v;
		}
		$str = implode("|",$str);
	}
	return $str;
}
function cookieDecode($arg)
{
	$p = explode("|", $arg);
	foreach($p as $tmp)
	{
		$sv = explode("=",$tmp);
		$array[$sv[0]] = $sv[1];
	}
	return $array;
}

/* compatibility with PHP versions older than 4.3 */
if ( !function_exists('file_get_contents') ) {
	function file_get_contents( $file ) {
		$file = file($file);
		return !$file ? false : implode('', $file);
	}
}
/* compatibility with PHP versions older than 5.0*/
if(!function_exists('file_put_contents'))
{
	function file_put_contents( $file, $content ) {
		return writeFile($file, $content, "w+");
	}
}
function wordCut($str,$len)
{
	for($i=0;$i<$len;$i++)
	{
		$temp_str=substr($str,0,1);
		if(ord($temp_str) > 127)
		{
			$i++;
			if($i<$len)
			{
				$new_str[]=substr($str,0,3);
				$str=substr($str,3);
			}
		}
		else
		{
			$new_str[]=substr($str,0,1);
			$str=substr($str,1);
		}
	}
	return join($new_str);
}

function initHit()
{
	global $mysql;
	require_once(CACHE_PATH."hit.cache.php");
	{
		$hit_now = strtotime(NOW);
		foreach($HIT_UPDATE_TIME as $key => $value)
		{
			$hit_time[$key] = strtotime($value);
		}
		if($hit_now-$hit_time['today_hit']>3600*24)
		{
			$mysql->update("music",array('today_hit'=>0));
			$mysql->update("special",array('today_hit'=>0));
			$mysql->update("artist",array('today_hit'=>0));
			$content = file_get_contents(CACHE_PATH."hit.cache.php");
			$content = str_replace("'today_hit' => \"".$HIT_UPDATE_TIME['today_hit']."\"","'today_hit' => \"".NOW."\"",$content);
			file_put_contents(CACHE_PATH."hit.cache.php",$content);
		}
		if($hit_now-$hit_time['week_hit']>3600*24*7)
		{
			$mysql->update("music",array('week_hit'=>0));
			$mysql->update("special",array('week_hit'=>0));
			$mysql->update("artist",array('week_hit'=>0));
			$content = file_get_contents(CACHE_PATH."hit.cache.php");
			$content = str_replace("'week_hit' => \"".$HIT_UPDATE_TIME['week_hit']."\"","'week_hit' => \"".NOW."\"",$content);
			file_put_contents(CACHE_PATH."hit.cache.php",$content);
		}
		if($hit_now-$hit_time['month_hit']>3600*24*30)
		{
			$mysql->update("music",array('month_hit'=>0));
			$mysql->update("special",array('month_hit'=>0));
			$mysql->update("artist",array('month_hit'=>0));
			$content = file_get_contents(CACHE_PATH."hit.cache.php");
			$content = str_replace("'month_hit' => \"".$HIT_UPDATE_TIME['month_hit']."\"","'month_hit' => \"".NOW."\"",$content);
			file_put_contents(CACHE_PATH."hit.cache.php",$content);
		}
	}
}

function initMenu()
{
	global $mysql;
	$menu = $mysql->select("channel","id,name,url,type",array('display'=>1),"`order` ASC");
	require_once(CACHE_PATH."menu.cache.php");
	$content = file_get_contents(CACHE_PATH."menu.cache.php");
	$content = str_replace("\$WEB_MENU_CACHE = ".var_export($WEB_MENU_CACHE, true), "\$WEB_MENU_CACHE = ".var_export($menu, true), $content);
	$content = str_replace("define('MENU_UPDATE_DATE', '".MENU_UPDATE_DATE."');", "define('MENU_UPDATE_DATE', '".NOW."');", $content);
	file_put_contents(CACHE_PATH."menu.cache.php", $content);
}
?>