<?php
namespace app\Common\taglib;
use think\template\TagLib;

/**
 * 自定义标签 适用于default模板
 */
class Def extends TagLib
{
    protected $tags = [
        'menu'      => ['attr' => 'name', 'close' => 1], //0闭合标签 ，1不闭合（默认）
        'hot'       => ['attr' => 'catid,num,name,table,field', 'close' => 1],
        'news'      => ['attr' => 'catid,num,name,table,field', 'close' => 1],
        'assessment'  => ['attr' => 'catid,num,name,table,field', 'close' => 1],
        'pascase'    => ['attr' => 'catid,num,name,table,field', 'close' => 1],
        'syshop'    => ['attr' => 'catid,num,name,table,field', 'close' => 1],
        'recommend' => ['attr' => 'catid,num,name,table,field', 'close' => 1],
        'list'      => ['attr' => 'catid,num,name,table,field', 'close' => 1],
        'page'      => ['attr' => 'catid', 'close' => 1], //实际不使用，仅供教学参考
    ];
   
    public function tagSyshop($tag, $content) {
        $table = $tag['table'];
        $field = $tag['field']; //可为空，则查询所有字段
        if(empty($tag['catid']) || $tag['catid']=='0'){
            $where = '';
        }else{
            $where = "catid=" . $tag['catid'];
        }
        if(empty($tag['num']) || $tag['num']=='0'){
            $num = 8;
        }else{
            $num = $tag['num'];
        }
        $cache = 'syshop_' . $tag['catid'];

        $php = <<<php
<?php
        \$syshop = think\Db::name('$table')->where("$where")->field('$field')->limit('$num')->order('views desc')->cache("$cache",config('cache.expire'))->select();
        \$__LIST__ = \$syshop;
?>
php;

        $name = $tag['name'];
        $parse = $php;
        $parse .= '{volist name="__LIST__" id="' . $name . '"}';
        $parse .= $content;
        $parse .= '{/volist}';
        return $parse;
    }

      public function tagNews($tag, $content) {
        $table = $tag['table'];
        $field = $tag['field']; //可为空，则查询所有字段
        if(empty($tag['catid']) || $tag['catid']=='0'){
            $where = '';
        }else{
            $where = "catid=" . $tag['catid'];
        }
        if(empty($tag['num']) || $tag['num']=='0'){
            $num = 8;
        }else{
            $num = $tag['num'];
        }
        $cache = 'news_' . $tag['catid'];

        $php = <<<php
<?php
        \$news = think\Db::name('$table')->where("$where")->field('$field')->limit('$num')->order('views desc')->cache("$cache",config('cache.expire'))->select();
        \$__LIST__ = \$news;
?>
php;

        $name = $tag['name'];
        $parse = $php;
        $parse .= '{volist name="__LIST__" id="' . $name . '"}';
        $parse .= $content;
        $parse .= '{/volist}';
        return $parse;
    }
    
public function tagAssessment($tag, $content) {
        $table = $tag['table'];
        $field = $tag['field']; //可为空，则查询所有字段
        if(empty($tag['catid']) || $tag['catid']=='0'){
            $where = '';
        }else{
            $where = "catid=" . $tag['catid'];
        }
        if(empty($tag['num']) || $tag['num']=='0'){
            $num = 8;
        }else{
            $num = $tag['num'];
        }
        $cache = 'Dssessment_' . $tag['catid'];

        $php = <<<php
<?php
        \$Dssessment = think\Db::name('$table')->where("$where")->field('$field')->limit('$num')->order('views desc')->cache("$cache",config('cache.expire'))->select();
        \$__LIST__ = \$Dssessment;
?>
php;

        $name = $tag['name'];
        $parse = $php;
        $parse .= '{volist name="__LIST__" id="' . $name . '"}';
        $parse .= $content;
        $parse .= '{/volist}';
        return $parse;
    }
    

    public function tagHot($tag, $content) {
        $table = $tag['table'];
        $field = $tag['field']; //可为空，则查询所有字段
        if(empty($tag['catid']) || $tag['catid']=='0'){
            $where = '';
        }else{
            $where = "catid=" . $tag['catid'];
        }
        if(empty($tag['num']) || $tag['num']=='0'){
            $num = 8;
        }else{
            $num = $tag['num'];
        }
        $cache = 'hot_' . $tag['catid'];

        $php = <<<php
<?php
        \$hot = think\Db::name('$table')->where("$where")->field('$field')->limit('$num')->order('views desc')->cache("$cache",config('cache.expire'))->select();
        \$__LIST__ = \$hot;
?>
php;

        $name = $tag['name'];
        $parse = $php;
        $parse .= '{volist name="__LIST__" id="' . $name . '"}';
        $parse .= $content;
        $parse .= '{/volist}';
        return $parse;
    }


     public function tagPascase($tag, $content) {
        $table = $tag['table'];
        $field = $tag['field']; //可为空，则查询所有字段
        if(empty($tag['catid']) || $tag['catid']=='0'){
            $where = '';
        }else{
            $where = "catid=" . $tag['catid'];
        }
        if(empty($tag['num']) || $tag['num']=='0'){
            $num = 8;
        }else{
            $num = $tag['num'];
        }
        $cache = 'pascase_' . $tag['catid'];

        $php = <<<php
<?php
        \$pascase = think\Db::name('$table')->where("$where")->field('$field')->limit('$num')->order('views desc')->cache("$cache",config('cache.expire'))->select();
        \$__LIST__ = \$pascase;
?>
php;

        $name = $tag['name'];
        $parse = $php;
        $parse .= '{volist name="__LIST__" id="' . $name . '"}';
        $parse .= $content;
        $parse .= '{/volist}';
        return $parse;
    }

    public function tagRecommend($tag, $content) {
        $table = $tag['table'];
        $field = $tag['field'];
        if(empty($tag['catid']) || $tag['catid']=='0'){
            $where = 'recommend=1';
        }else{
            $where = "recommend=1 and catid=" . $tag['catid'];
        }
        if(empty($tag['num']) || $tag['num']=='0'){
            $num = 3;
        }else{
            $num = $tag['num'];
        }
        $cache = 'recommend_' . $tag['catid'];

        $php = <<<php
<?php
        \$recommend = think\Db::name('$table')->where("$where")->field('$field')->limit('$num')->order('listorder desc')->cache("$cache",config('cache.expire'))->select();
        \$__LIST__ = \$recommend;
?>
php;
        $name = $tag['name'];
        $parse = $php;
        $parse .= '{volist name="__LIST__" id="' . $name . '"}';
        $parse .= $content;
        $parse .= '{/volist}';
        return $parse;
    }

    public function tagList($tag, $content) {
        $table = $tag['table'];
        $field = $tag['field'];
        //首页cid=0,num>0 ; 分类页cid>0,num=0
        if(empty($tag['catid']) || $tag['catid']=='0'){
            $num = $tag['num'];
            $php = <<<php
<?php
            \$list = think\Db::name('$table')->field('$field')->limit("$num")->order('listorder desc')->cache('$table_index',config('cache.expire'))->select();
            \$__LIST__ = \$list;
?>
php;
        }else{
            $num = 0;
            $where = "catid=" . $tag['catid'];
            $php = <<<php
<?php
           \$list = think\Db::name('$table')->where("$where")->field('$field')->limit("$num")->order('listorder desc')->paginate();
           \$__LIST__ = \$list;
?>
php;
        }

        $name = $tag['name'];
        $parse = $php;
        $parse .= '{volist name="__LIST__" id="' . $name . '"}';
        $parse .= $content;
        $parse .= '{/volist}';
        return $parse;
    }

    public function tagPage($tag, $content) {
        //实际不使用，仅供教学参考
        $where = "catid=" . $tag['catid'];
        $php = <<<php
<?php
       \$article_list = think\Db::name('article')->where("$where")->field('id,catid,title,thumb,description,inputtime,views')->limit("$num")->order('listorder desc')->paginate();
       \$vo = \$article_list;
?>
php;
        $parse = $php;
        $parse .= $content;
        return $parse;
    }
}
