<?php
namespace app\admin\controller;
use think\Controller;
use think\Db;
use util\Auth;

class Base extends Controller
{
    public function _initialize() {
        // 用户未登录则跳转前台登录页面
        if(session('uid') == null){
            session(null);
            $this->redirect('/admin/login.html');
        }

        // 获取配置信息
        if(!cache('system')){
            $site = db('system')->column('enname,value');
            cache('site',$site);
        }
         $this->assign('site',cache('site'));
    }

    public function loginout(){
        session(null);
        $this->redirect('/admin/login.html');
    }

 
    
    
    public function add($requireField = '', $requireFieldName = ''){
        if(request()->isPost()){
            // 判断权限
            if(!checkAuth()){
                return error('您没有相应的操作权限!');
            }

            $table = request()->controller();
            $data = input('post.');

            // 判断唯一字段和是否为空
            if(trim($requireField) != ''){
                if(trim($data[$requireField]) == ''){
                    return error($requireFieldName.'不为空!');
                }else{
                    $count = db($table)->where($requireField, $data[$requireField])->count();
                    if($count){
                        return error($requireFieldName.'已存在!');
                    }
                }
            }

            $id = db($table)->strict(false)->insertGetId($data);
            if($id){
                return success('添加成功！', url('index'));
            }else{
                return error('添加失败！');
            }
        }
    }

    public function edit($id = 0, $requireField = '', $requireFieldName = ''){
        if(request()->isPost()){
            // 判断权限
            if(!checkAuth()){
                return error('您没有相应的操作权限!');
            }

            $table = request()->controller();
            $data = input('post.');

            // 判断唯一字段和是否为空
            if(trim($requireField) != ''){
                if(trim($data[$requireField]) == ''){
                    return error($requireFieldName.'不为空!');
                }else{
                    // 排除当前记录进行查询
                    $count = db($table)->where('id', 'neq', $id)->where($requireField, $data[$requireField])->count();
                    if($count){
                        return error($requireFieldName.'已存在!');
                    }
                }
            }

            $result = db($table)->where('id',$id)->strict(false)->update($data);
            // 判断更新失败或未更新
            if($result !== false){
                return success('编辑成功！', url('index'));
            }else{
                return error('编辑失败！');
            }
        }
    }

    public function delete($id = 0){
        
        // 判断权限
        if(!checkAuth()){
            return error('您没有相应的操作权限!');
        }
        // 获取当前数据表名（控制器名）
        $table = request()->controller();
        if(Db::name($table)->where('id', $id)->delete()){
            return success('删除成功!',url('index'));
        }else{
            return error('删除失败!');
        }
    }
    
}
