<?php
namespace app\admin\controller;
use think\Controller;
use think\Db;
use util\Tree;
use menutree\Menutree;
use catetree\Catetree;
use app\admin\model\Category as CategoryModel;

class Category extends Base
{
    public function index($tab = 1, $id = 0){
        // 判断权限
       

        // 1个分类（从表） 属于 1个模型（主表）  属于[belongsTo]
        // 1个模型  有 多个分类
        // $category = Db::name('category')->order('listorder')->select(); //原写法
        $category = CategoryModel::order('listorder')->select();
        $categoryList = array();
        foreach ($category as $key => $value) {
        $tidt=$value->modelid;
        $infot= Db::name('models')->where('id',$tidt)->find();
        //var_dump($infot);

 
            $categoryList[] = $value->toArray(); //对象转数组
            //一对一关联出对应模型
            if( 0 != $categoryList[$key]['isend'] && 0 != $categoryList[$key]['modelid']){
                $categoryList[$key]['models'] = $value->models->toArray(); //关联模型用时才加载
            }

         $categoryList[$key]['models']=$infot[name];
        }
        $tree = new Tree();
        $tree->tree($categoryList,'id','parentid','catname');
        $categoryArray = $tree->getArray();
        $this->assign('category',$categoryArray);

        // 获取模型数据
        $models = Db::name('models')->field('id, name')->select();
        $this->assign('models',$models);

        // 编辑分类
        if( 3 == $tab ){
            // 获取所要编辑分类的信息
            $category_info = Db::name('category')->where('id',$id)->find();
            if($category_info!=null && is_array($category_info)){
                $this->assign('category_info',$category_info);
            }
        }
        return view();
    }

    public function sort(){
        $id=input('param.id');

        $sort=input('param.sort');
        db('category')->where(array('id'=>$id))->update(array('listorder'=>$sort));
        $this->success('更新排序成功！',url('index'));
    }

    public function ajaxlst(){
        if(request()->isAjax()){
            $id=input('id');
            $menu=db('category');
            $menuTree=new menutree();
            $sonids=$menuTree->childrenids($id,$menu);
            echo json_encode($sonids);
        }else{
            $this->error('非法操作！');
        }
    }

 

    public function add($requireField = '', $requireFieldName = ''){
        if(request()->isPost()){
            // 判断权限
            if(!checkAuth()){
                return error('您没有相应的操作权限!');
            }

            // 顶级分类下只能添加终极分类
            if(input('post.parentid') && !input('post.isend')){
                return error('请勾选终极分类!');
            }
            // 检查分类名称和分类目录是否重名
            $count = Db::name('category')->where('catname',input('post.catname'))->whereOr('catdir',input('post.catdir'))->count();
            if($count){
                return error('分类名称或分类目录重名!');
            }

            $categoryModel = new CategoryModel;
            if($categoryModel->allowField(true)->save(input('post.'))){
                return success('分类添加成功!',url('index',['tab'=>1]));
            }else{
                return error('分类添加失败!');
            }
        }
    }

    public function edit($id = 0, $requireField = '', $requireFieldName = ''){
        if(request()->isPost()){
            // 判断权限
            if(!checkAuth()){
                return error('您没有相应的操作权限!');
            }
          
            // 顶级分类下只能添加终极分类
            // if(input('post.parentid') && !input('post.isend')){
            //     return error('请勾选终极分类!');
            // }
            // 检查分类名称和分类目录是否重名
            $count_one = Db::name('category')->where('id','<>',$id)->where('catname',input('post.catname'))->count();
            $count_two = Db::name('category')->where('id','<>',$id)->where('catdir',input('post.catdir'))->count();
            if($count_one){
                return error('分类名称重名!');
            }else if($count_two){
                return error('分类目录重名!');
            }
            // $data=input('post.');
            // $ins=$data['isend'];
            // if ($ins!==null) {
            //    $save=db('category')->update($ins);
            // }
            // $save=db('category')->where('isend')->update($data);
            // var_dump($save);
            // die;
            // if ($save !== flash) {
            //    return success('分类编辑成功!',url('index',['tab'=>1]));
            // }else{
            //    return success('123!',url('index',['tab'=>1]));
            // }
            
            // 编辑分类
            $categoryModel = new CategoryModel;
            // $cateid=input('id');
            // $cateres=db('category')->find($cateid);
            // var_dump($cateres);
            // die;
            // $this->assign('cateres',$cateres);

            // $cates=db('category')->catetree();
            // var_dump($cates);
            // die;
            // $this->assign('cates',$cates);

            if($categoryModel->allowField(true)->isUpdate()->save(input('post.'))){
                return success('分类编辑成功!',url('index',['tab'=>1]));
            }else{
                return error('该分类下有终极分类!请重新删除分类添加...',url('index',['tab'=>1]));
            }

        }
    }

   



}
