<?php
namespace app\admin\controller;
use think\Controller;
use app\admin\model\Menu;
use think\Cache;
use think\Log;
use think\Db;

class Index  extends Base
{
    public function index()
    {
        $adminUser=db('adminuser')->order('id')->find();
        
    	$menuArray = db('menu')->order('listorder')->select();
        $menuTree = Menu::tree($menuArray);
        // dump($menuTree);
        $this->assign('menu',$menuTree);
        $this->assign('adminUser',$adminUser);
        return view();
    }
    public function content()
    {
    
    	$info = array(
            '操作系统'=>PHP_OS,
            '运行环境'=>$_SERVER["SERVER_SOFTWARE"],
            '授权域名'=>$_SERVER['SERVER_NAME'],
            'WEB服务端口'=>$_SERVER['SERVER_PORT'],
            '网站文档目录'=>$_SERVER["DOCUMENT_ROOT"],
            '浏览器信息'=>substr($_SERVER['HTTP_USER_AGENT'], 0, 40),
            '通信协议'=>$_SERVER['SERVER_PROTOCOL'],
            '上传附件限制'=>ini_get('upload_max_filesize'),
            '执行时间限制'=>ini_get('max_execution_time').'秒',
            '服务器时间'=>date("Y年n月j日 H:i:s"),
            '服务器域名/IP'=>$_SERVER['SERVER_NAME'].' [ '.gethostbyname($_SERVER['SERVER_NAME']).' ]',
            '用户的IP地址'=>$_SERVER['REMOTE_ADDR'],
            '剩余空间'=>round((disk_free_space(".")/(1024*1024)),2).'M',
        );
        $this->assign('info',$info);

        //统计该类别的文章数目
        $pages=Db::table('zhandao_pages')->count('id');
        $article=Db::table('zhandao_article')->count('id');
        $product=Db::table('zhandao_product')->count('id');
        $cpcase=Db::table('zhandao_case')->count('id');
        $this->assign('pages',$pages);
        $this->assign('article',$article);
        $this->assign('product',$product);
        $this->assign('cpcase',$cpcase);
        return view();
    }

    public function cache(){
      $dir = $_SERVER['DOCUMENT_ROOT'].'/runtime';
    
       $this->rmdirs($dir);
       $this->success('清空缓存成功！');
    }
    public function rmdirs($dir){
        $dir_arr = scandir($dir);
        foreach($dir_arr as $key=>$val){
            if($val == '.' || $val == '..'){}
            else {
                if(is_dir($dir.'/'.$val))    
                {                            
                    if(@rmdir($dir.'/'.$val) == 'true'){}        
                    else
                    $this->rmdirs($dir.'/'.$val);                    
                }
                else                
                unlink($dir.'/'.$val);
            }
        }
    }    
   
}
