<?php
namespace app\admin\controller;
use think\Controller;
use think\Db;
use util\Tree;
use menutree\Menutree;
use app\admin\model\Menu as MenuModel;

class Menu extends Base
{
    public function index($tab = 1, $id = 0){
        // 判断权限
       
        $menuArray = MenuModel::order('listorder asc,id asc')->select();
        foreach ($menuArray as $key => $value) {
            $menuList[] = $value->toArray(); //对象转数组
        }
        $tree = new Tree();
        $tree->tree($menuList,'id','parentid','name');
        $menu = $tree->getArray();
        $this->assign('menu',$menu);

        // 编辑菜单，默认加载
        if( 3 == $tab ){
            // 获取所要编辑菜单的信息
            $info = Db::name('menu')->where('id',$id)->find();
            
            if($info!=null && is_array($info)){
                $this->assign('info',$info);
            }
        }
        return view();
    }


    public function sort(){
        $id=input('param.id');

        $sort=input('param.sort');
        db('menu')->where(array('id'=>$id))->update(array('listorder'=>$sort));
        $this->success('更新排序成功！',url('index'));
    }

    public function ajaxlst(){
        if(request()->isAjax()){
            $id=input('id');
            $menu=db('menu');
            $menuTree=new menutree();
            $sonids=$menuTree->childrenids($id,$menu);
            echo json_encode($sonids);
        }else{
            $this->error('非法操作！');
        }
    }

    public function add($requireField = '', $requireFieldName = ''){
        if(request()->isPost()){
            // 判断权限
            // if(!checkAuth()){
            //     return error('您没有相应的操作权限!');
            // }
            $data = input('post.');
            if (strlen($data['name'])>13 || strlen($data['name'])<10)
            {
                return error("菜单项名称只能4个中文！");
            }
            if(preg_match("/^[A-Za-z0-9]+$/",$data['name']))
            {
                return error("菜单项名称必须是中文！");//全数字
            }
            // 第三层菜单禁止勾选子菜单项
            $parentid = Db::name('menu')->where('id',input('post.parentid'))->value('parentid');
            if($parentid && input('post.child')){
                return error('不能勾选拥有子菜单项!');
            }
            // 检查菜单名称是否重名
            $count = Db::name('menu')->where('name',input('post.name'))->count();
            if($count){
                return error('菜单名称重复!');
            }

            $menuModel = new MenuModel;
            if($menuModel->allowField(true)->save(input('post.'))){
                return success('新菜单添加成功!',url('index',['tab'=>1]));
            }else{
                return error('菜单添加失败!');
            }
        }
    }

    public function edit($id = 0, $requireField = '', $requireFieldName = ''){
        if(request()->isPost()){

            // 判断权限
            // if(!checkAuth()){
            //     return error('您没有相应的操作权限!');
            // }
            // 第三层菜单禁止勾选子菜单项
            $parentid = Db::name('menu')->where('id',input('post.parentid'))->value('parentid');
            if($parentid && input('post.child')){
                return error('不能勾选拥有子菜单项!');
            }
            // 检查菜单名称是否重名
            $count = Db::name('menu')->where('id','<>',$id)->where('name',input('post.name'))->count();
            if($count){
                return error('菜单名称重复!');
            }
            $menu_form = input('post.');
            //判断child状态
            if(input('post.child')==null){

                $menu_form['child'] = 0;
                $count = Db::name('menu')->where('parentid',$id)->count();
                if($count){
                    return error('该菜单拥有子菜单项，无法取消勾选!');
                }
            }
            // 编辑菜单
            $menuModel = new MenuModel;
            
            if($menuModel->allowField(true)->isUpdate()->save($menu_form)){
                return success('菜单编辑成功!',url('index',['tab'=>1]));
            }else{
                return error('菜单信息未修改或编辑失败!',url('index',['tab'=>1]));
            }
        }
    }

    public function getcharl($id){
            static $re=array();
    $re='';
         $data=Db::name('menu')->where('parentid', $id)->select();
      for($i=0;$i<count($data);$i++){
        $re[]=$data[$i];
      }
      return $re;
}
 public function deletet($id = 0){
        $data=$this->getcharl($id);

        if($data){

       Db::name('menu')->where('id', $id)->delete();

        for($i=0;$i<count($data);$i++){
        $newid=$data[$i]['id'];
        $this->deletet($newid);

        }
        }else{
       Db::name('menu')->where('id', $id)->delete();
        }
       
    }
    public function delete($id = 0){
        $data=$this->getcharl($id);
         
        if($data){

       Db::name('menu')->where('id', $id)->delete();

        for($i=0;$i<count($data);$i++){
        $newid=$data[$i]['id'];
        $this->deletet($newid);

        }
        $result=1;
        }else{
       $result=Db::name('menu')->where('id', $id)->delete();
        }
        if($result){
            return success('删除成功!',url('index',['tab'=>1]));
        }else{
            return error('删除失败!');
        }
    }

 

 

   

}
