<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006-2016 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 流年 <liu21st@gmail.com>
// +----------------------------------------------------------------------

// 应用公共文件

// 设置异常错误报错级别，关闭notice错误
error_reporting(E_ALL ^ E_NOTICE);

use think\Db;
use util\Auth;

// 自定义success助手函数
function success($msg = '成功', $url = '')
{
    $data['status'] = 200;
    $data['msg'] = $msg;
    $data['url'] = $url;
    return json($data);
}

// 自定义successIframe助手函数
function successIframe($msg = '成功', $url = '')
{
    $data['status'] = 201;
    $data['msg'] = $msg;
    return json($data);
}

// 自定义error助手函数
function error($msg = '失败', $url = '')
{
    $data['status'] = 202;
    $data['msg'] = $msg;
    $data['url'] = $url;
    return json($data);
}



// 判断权限
function checkAuth() {
    if(!in_array(session('uid'), explode(',',config('auth_superadmin')))){
        $auth = new Auth();
        $rule = strtolower(request()->module().'/'.request()->controller().'/'.request()->action());
        return $auth->check($rule, session('uid'));
    }else{
        return true;
    }
}

/**
 * [table_exists 检测数据表是否存在]
 * @param  string $tablename [表名，不含前缀]
 * @return [bool]            [存在返回true，不存在返回false]
 */
function table_exists($tablename='')
{
    //获取所有数据表名
    $tables = [];
    $data = Db::query('SHOW TABLES');
    foreach ($data as $value) {
        $tables[] = $value['Tables_in_'.config('database.database')];
    }
    //获取表前缀
    $dbPrefix = config('database.prefix');
    //当前的表名
    $tablename=$dbPrefix.$tablename;
    if(in_array($tablename,$tables)){
        return true; //存在
    }else {
        return false; //不存在
    }
}

/**
 * [field_exists 检测数据表字段是否存在]
 * @param  string $tablename [表名，不含前缀]
 * @param  string $field [字段名]
 * @return [bool]            [存在返回true，不存在返回false]
 */
function field_exists($tablename='', $field='')
{
    //获取表前缀
    $dbPrefix = config('database.prefix');
    //先判断数据表是否存在
    if(table_exists($tablename)){
        $fieldArray = Db::query("Describe `{$dbPrefix}{$tablename}` `{$field}` ;");
        if(is_array($fieldArray[0])){
            return true; //存在
        }else {
            return false; //不存在
        }
    }else {
        return false;  //不存在
    }
}

// 根据分类ID获取相应分类信息
function getCatInfoById($id=0, $field=''){
    if($field == ''){
        //获取单条数据
        return Db::name('category')->where('id',$id)->find();
    }else{
        //获取某个字段
        return Db::name('category')->where('id',$id)->value($field);
    }
}

// 根据分类ID获取相应模型信息
function getModInfoById($id=0, $field=''){
    //模型ID、
    $modelId = getCatInfoById($id, 'modelid');
    if($field == ''){
        //获取单条数据
        return Db::name('models')->where('id',$modelId)->find();
    }else{
        //获取某个字段
        return Db::name('models')->where('id',$modelId)->value($field);
    }
}

function timeToDate($time){
    return date("m-d",strtotime($time));
}


//字符串截取
function str_cut($sourcestr,$cutlength,$suffix='...')
{
    $str_length = strlen($sourcestr);
    if($str_length <= $cutlength) {
        return $sourcestr;
    }
    $returnstr='';  
    $n = $i = $noc = 0;
    while($n < $str_length) {
            $t = ord($sourcestr[$n]);
            if($t == 9 || $t == 10 || (32 <= $t && $t <= 126)) {
                $i = 1; $n++; $noc++;
            } elseif(194 <= $t && $t <= 223) {
                $i = 2; $n += 2; $noc += 2;
            } elseif(224 <= $t && $t <= 239) {
                $i = 3; $n += 3; $noc += 2;
            } elseif(240 <= $t && $t <= 247) {
                $i = 4; $n += 4; $noc += 2;
            } elseif(248 <= $t && $t <= 251) {
                $i = 5; $n += 5; $noc += 2;
            } elseif($t == 252 || $t == 253) {
                $i = 6; $n += 6; $noc += 2;
            } else {
                $n++;
            }
            if($noc >= $cutlength) {
                break;
            }
    }
    if($noc > $cutlength) {
            $n -= $i;
    }
    $returnstr = substr($sourcestr, 0, $n);
 

    if ( substr($sourcestr, $n, 6)){
          $returnstr = $returnstr . $suffix;//超过长度时在尾处加上省略号
      }
    return $returnstr;
}


 






