﻿<%
Const Msxml_DllName = "Microsoft.XMLDOM"

Class class_xmlupdate
    Public xmldom, xml_root, xmlfile, thisNodeLabel, thisNodeUrl, thisNodeTarget, thisNodeMId

    Private Sub class_initialize()
        Set xmldom = Server.CreateObject(Msxml_DllName)
    End Sub

    Public Sub load_xmldoc(filepath)
        xmlfile = server.mappath(filepath)
        xmldom.preserveWhiteSpace = True
        If Not xmldom.load(xmlfile) Then
            xmldom.loadxml "<?xml version=""1.0"" encoding=""utf-8""?><root/>"
        Else
            For var_i = 0 To xmldom.documentElement.childNodes.Length -1
                xmldom.documentElement.removechild(xmldom.documentElement.firstchild)
            Next
        End If
        Set xml_root = xmldom.documentElement
        Call save_xmldom()
    End Sub

    Public Function create_newattrnode(node_obj, attr_name, attr_text)
        Dim NewAttribute_Node, NowAttributeNode
        Set NowAttributeNode = node_obj.Attributes.getNamedItem(attr_name)
        If Not(NowAttributeNode Is Nothing) Then
            node_obj.Attributes.getNamedItem(attr_name).text = attr_text
            Set NowAttributeNode = Nothing
        Else
            Set NewAttribute_Node = xmldom.createNode(2, attr_name, "")
            node_obj.Attributes.setNamedItem(NewAttribute_Node).text = attr_text
        End If
        Set create_newattrnode = node_obj
    End Function

    Public Function create_newnode(node_obj, sub_nodename)
        Dim NewNode, AttributeLabel, AttributeUrl, AttributeTarget, AttributeMId
        Set NewNode = xmldom.createNode(1, sub_nodename, "")
        Set AttributeMId = xmldom.createNode(2, "mid", "")
        Set AttributeLabel = xmldom.createNode(2, "label", "")
        Set AttributeUrl = xmldom.createNode(2, "url", "")
        Set AttributeTarget = xmldom.createNode(2, "target", "")
        NewNode.Attributes.setNamedItem(AttributeMId).text = thisNodeMId
        NewNode.Attributes.setNamedItem(AttributeLabel).text = thisNodeLabel
        If Trim(thisNodeUrl)<>"" Then
            NewNode.Attributes.setNamedItem(AttributeUrl).text = thisNodeUrl
            NewNode.Attributes.setNamedItem(AttributeTarget).text = thisNodeTarget
        Else
            NewNode.Attributes.setNamedItem(AttributeUrl).text = "#"
            NewNode.Attributes.setNamedItem(AttributeTarget).text = "_self"
        End If
        node_obj.appendChild(NewNode)
        Set create_newnode = NewNode
    End Function

    Public Sub save_xmldom()
        xmldom.preserveWhiteSpace = True
        xmldom.save xmlfile
    End Sub

    Public Sub xmldom_clear()
        Set xmldom = Nothing
        Set xml_root = Nothing
        xmlfile = ""
    End Sub

End Class
%>