﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:variable name="MainMenuDoc" select="document(concat('../../',$web_editionfolder,'/page_data/inc_xmldata/webMainMenu', '.xml'))"/>
  <xsl:variable name="webMainMenu" select="$MainMenuDoc/web_mainmenu"/>
  <xsl:template name="import_mainmenubar">
    <xsl:param name="parentId" select="0"/>
    <xsl:param name="sortUlClass">
      <xsl:text disable-output-escaping="yes">main_menunav</xsl:text>
    </xsl:param>
    <xsl:element name="ul">
      <xsl:if test="$sortUlClass!=''">
        <xsl:attribute name="class">
          <xsl:value-of select="$sortUlClass"/>
        </xsl:attribute>
      </xsl:if>
      <xsl:for-each select="$webMainMenu/menuitem[@parentid=$parentId]">
        <xsl:if test="@subsortnum &gt; '0'">
          <li class="toplevel_li" onmouseover="startlist(this,1);" onmouseout="startlist(this,0);">
            <xsl:element name="a">
              <xsl:attribute name="href">
                <xsl:value-of select="@urlpath"/>
              </xsl:attribute>
              <xsl:value-of select="."/>
              <xsl:if test="@urltarget=''">
                <xsl:attribute name="target">
                  <xsl:value-of select="@urltarget"/>
                </xsl:attribute>
              </xsl:if>
            </xsl:element>
            <div class="secondlevel_div">
              <xsl:call-template name="import_mainmenubar">
                <xsl:with-param name="parentId" select="@menuid"/>
                <xsl:with-param name="sortUlClass">
                  <xsl:text disable-output-escaping="yes"></xsl:text>
                </xsl:with-param>
              </xsl:call-template>
            </div>
          </li>
        </xsl:if>
        <xsl:if test="@subsortnum = '0'">
          <li class="toplevel_li">
            <xsl:element name="a">
              <xsl:attribute name="href">
                <xsl:value-of select="@urlpath"/>
              </xsl:attribute>
              <xsl:value-of select="."/>
              <xsl:if test="@urltarget=''">
                <xsl:attribute name="target">
                  <xsl:value-of select="@urltarget"/>
                </xsl:attribute>
              </xsl:if>
            </xsl:element>
          </li>
        </xsl:if>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
</xsl:stylesheet>