<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:template match="/">
    <div class="thetitle">
      <strong>
        <xsl:value-of select="gbookmail/otherinfo/comefrom"/>：
      </strong>
      <a href="{gbookmail/otherinfo/weburl}" target="_blank"><xsl:value-of select="gbookmail/otherinfo/webname"/></a>
    </div>
    <div class="gbook_maintext">
      <table class="gbook_sendlist" border="2" cellpadding="0" cellspacing="4">
        <xsl:for-each select="gbookmail/gbookitem">
          <xsl:if test="paramuitype!=4">
            <tr class="gbook_item">
              <td class="gbook_ptitle">
                <xsl:value-of select="paramname"/>：
              </td>
              <td>
                <xsl:value-of select="parampostvalue" disable-output-escaping="yes"/>
              </td>
            </tr>
          </xsl:if>
          <xsl:if test="paramuitype=4">
            <tr class="gbook_item">
              <td class="gbook_ptitle2" colspan="2">
                <xsl:value-of select="paramname"/>：
              </td>
            </tr>
            <tr class="gbook_item">
              <td colspan="2">
                <xsl:value-of select="parampostvalue" disable-output-escaping="yes"/>
              </td>
            </tr>
          </xsl:if>
        </xsl:for-each>
      </table>
    </div>
    <style type="text/css">
        body
        {
            font-size: 12px;
        }
        .thetitle
        {
            display: block;
            line-height: 30px;
            padding-left: 4px;
            border: solid 1px #CCCCCC;
        }
        .gbook_sendlist
        {
            width: 100%;
            border: solid 1px #CCCCCC;
            line-height: 24px;
        }
        .gbook_item
        {
            word-break: break-all;
        }
        .gbook_ptitle
        {
            font-weight: bold;
            width: 12%;
        }
        .gbook_ptitle2
        {
            font-weight: bold;
        }
        .gbook_sendlist table td
        {
            border: solid 1px #CCCCCC;
            padding: 2px;
        }
    </style>
  </xsl:template>
</xsl:stylesheet>