<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:variable name="TopNewsDoc" select="document(concat('../../',$web_editionfolder,'/page_data/inc_xmldata/indexNewsList', '.xml'))"/>
  <xsl:variable name="isTopNews" select="$TopNewsDoc/newslists"/>
  <xsl:template name="import_indexnews">
    <dl class="i_n_text">
      <xsl:for-each select="$isTopNews/newsitem">
        <xsl:if test="position()&lt;2">
          <dt>
            <a href="{urlpath}"><img src="{newsimage}" title="{newstopic}"/></a>
          </dt>
          <dd>
            <strong>
              <a href="{urlpath}" title="{newstopic}"><xsl:value-of select="newstopic" /></a>
            </strong>
          </dd>
          <h4>
            <xsl:value-of select="newsinfos" />
          </h4>
        </xsl:if>
      </xsl:for-each>
    </dl>
    <div class="nlist">
      <ul>
        <xsl:for-each select="$isTopNews/newsitem">
          <xsl:if test="position()&lt;8 and position()&gt; 1">
            <li>
              <a href="{urlpath}" title="{newstopic}"><xsl:value-of select="newstopic" /></a>
            </li>
          </xsl:if>
        </xsl:for-each>
      </ul>
    </div>
  </xsl:template>
  <xsl:template name="import_indexnews2">
    <div id="marqueebox0" class="marqueebox">
      <ul class="i_n_news">
        <xsl:for-each select="$isTopNews/newsitem">
          <xsl:if test="position()&lt;6">
            <li>
              <a href="{urlpath}" title="{newstopic}"><xsl:value-of select="newstopic"/><span>[<xsl:value-of select="newstime"/>]</span></a>
            </li>
          </xsl:if>
        </xsl:for-each>
      </ul>
    </div>
    <script language="javascript" type="text/javascript">
      function start_upmarquee(lh,speed,delay,index_obj){
      var the_time;
      var the_stop=false;
      var moveObj=document.getElementById(index_obj);
      moveObj.innerHTML+=moveObj.innerHTML;
      moveObj.onmouseover=function(){the_stop=true}
      moveObj.onmouseout=function(){the_stop=false}
      moveObj.scrollTop = 0;
      function start(){
      the_time=setInterval(scrolling,speed);
      if(!the_stop) moveObj.scrollTop += 2;
      }
      function scrolling(){
      if(moveObj.scrollTop%lh!=0){
      moveObj.scrollTop += 2;
      if(moveObj.scrollTop<xsl:text disable-output-escaping="yes">&gt;</xsl:text>=moveObj.scrollHeight/2) moveObj.scrollTop = 0;
      }else{
      clearInterval(the_time);
      setTimeout(start,delay);
      }
      }
      setTimeout(start,delay);
      }
      start_upmarquee(26,60,6000,"marqueebox0");
    </script>
  </xsl:template>
</xsl:stylesheet>