<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:variable name="surveyListDoc" select="document(concat('../../',$web_editionfolder,'/page_data/inc_xmldata/indexSurveyList', '.xml'))"/>
  <xsl:variable name="surveyList" select="$surveyListDoc/surveylists"/>
  <xsl:template name="import_websurveylists">
    <div class="survey_indexpost">
      <xsl:if test="$surveyList/@surveyuitype=0">
        <form name="add_frm" action="/ajax_asp/survey_add.asp" method="post">
          <input type="hidden" name="chk" value="yes" />
          <input type="hidden" name="surveytype" value="{$surveyList/@surveyuitype}" />
          <table class="survey_tblist" border="0" cellpadding="0" cellspacing="4">
            <xsl:for-each select="$surveyList/surveyitem">
              <tr class="survey_post">
                <td width="1%">
                  <input type="radio" id="survey_{position()}" name="survey_item" value="{@surveyid}" />&#32;
                </td>
                <td>
                  <label for="survey_{position()}">
                    <xsl:value-of select="surveytopic" />
                  </label>
                </td>
              </tr>
            </xsl:for-each>
            <tr class="survey_postbtn">
              <td colspan="2">
                <input type="submit" name="add_btn" class="survey_ibtn" title="{$surveyList/surveybutton/@submitbtn}" value="" />
                <input type="reset" name="clear_btn" class="survey_ibtn2" title="{$surveyList/surveybutton/@resetbtn}" value="" />
              </td>
            </tr>
          </table>
        </form>
      </xsl:if>
      <xsl:if test="$surveyList/@surveyuitype=1">
        <form name="add_frm" action="/ajax_asp/survey_add.asp" method="post">
          <input type="hidden" name="chk" value="yes" />
          <input type="hidden" name="surveytype" value="{$surveyList/@surveyuitype}" />
          <table class="survey_tblist" border="0" cellpadding="0" cellspacing="4">
            <xsl:for-each select="$surveyList/surveyitem">
              <tr class="survey_post">
                <td width="1%">
                  <input type="checkbox" id="survey_{position()}" name="survey_item" value="{@surveyid}" />&#32;
                </td>
                <td>
                  <label for="survey_{position()}">
                    <xsl:value-of select="surveytopic" />
                  </label>
                </td>
              </tr>
            </xsl:for-each>
            <tr class="survey_postbtn">
              <td colspan="2">
                <input type="submit" name="add_btn" value="{$surveyList/surveybutton/@submitbtn}" />
                <input type="reset" name="clear_btn" value="{$surveyList/surveybutton/@resetbtn}" />
              </td>
            </tr>
          </table>
        </form>
      </xsl:if>
      <xsl:if test="$surveyList/@surveyuitype=2">
        <ul>
          <xsl:for-each select="$surveyList/surveyitem">
            <li>
              <form name="add_frm" action="/ajax_asp/survey_add.asp" method="post">
                <input type="hidden" name="chk" value="yes" />
                <input type="hidden" name="surveytype" value="{$surveyList/@surveyuitype}" />
                <input type="hidden" name="survey_item" value="{@surveyid}" /><xsl:value-of select="surveytopic" />&#32;&#32;&#32;
                <input type="submit" name="add_btn" value="{$surveyList/surveybutton/@submitbtn}" />
              </form>
            </li>
          </xsl:for-each>
        </ul>
      </xsl:if>
    </div>
  </xsl:template>
</xsl:stylesheet>