<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" version="1.0" encoding="utf-8" omit-xml-declaration="yes" media-type="text/xml" indent="yes"/>
  <xsl:template match="/">
    <xsl:variable name="prevRecord" select="prevnextrecord/prevrecord"/>
    <xsl:variable name="nextRecord" select="prevnextrecord/nextrecord"/>
    <div class="prevnext">
      <xsl:if test="$prevRecord!=''">
        <span class="prevrecord">
          <xsl:value-of select="$prevRecord/@prevtitle"/>&#65306;<a href="{$prevRecord/@theprevurl}" title="{$prevRecord}">
            <xsl:value-of select="$prevRecord"/>
          </a>
        </span>
      </xsl:if>
      <xsl:if test="$nextRecord!=''">
        <span class="nextrecord">
          <xsl:value-of select="$nextRecord/@nexttitle"/>&#65306;<a href="{$nextRecord/@thenexturl}" title="{$nextRecord}">
            <xsl:value-of select="$nextRecord"/>
          </a>
        </span>
      </xsl:if>
    </div>
  </xsl:template>
</xsl:stylesheet>